/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.project.BrokenReferencesCustomizer;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokenReferencesModel
extends AbstractListModel {
    private String[] props;
    private String[] platformsProps;
    private AntProjectHelper helper;
    private ReferenceHelper resolver;
    private List<OneReference> references;
    public static final int REF_TYPE_PROJECT = 1;
    public static final int REF_TYPE_FILE = 2;
    public static final int REF_TYPE_LIBRARY = 3;
    public static final int REF_TYPE_PLATFORM = 4;
    public static final int REF_TYPE_LIBRARY_CONTENT = 5;
    public static final int REF_TYPE_VARIABLE = 6;
    public static final int REF_TYPE_VARIABLE_CONTENT = 7;

    public BrokenReferencesModel(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, String[] stringArray, String[] stringArray2) {
        this.props = stringArray;
        this.platformsProps = stringArray2;
        this.resolver = referenceHelper;
        this.helper = antProjectHelper;
        this.references = new ArrayList<OneReference>();
        this.refresh();
    }

    public void refresh() {
        LinkedHashSet<OneReference> linkedHashSet = new LinkedHashSet<OneReference>();
        Set<OneReference> set = BrokenReferencesModel.getReferences(this.helper, this.resolver, this.helper.getStandardPropertyEvaluator(), this.props, false);
        linkedHashSet.addAll(set);
        set = BrokenReferencesModel.getPlatforms(this.helper.getStandardPropertyEvaluator(), this.platformsProps, false);
        linkedHashSet.addAll(set);
        BrokenReferencesModel.updateReferencesList(this.references, linkedHashSet);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    @Override
    public Object getElementAt(int n) {
        String string;
        OneReference oneReference = this.getOneReference(n);
        switch (oneReference.type) {
            case 3: {
                string = "LBL_BrokenLinksCustomizer_BrokenLibrary";
                break;
            }
            case 5: {
                string = "LBL_BrokenLinksCustomizer_BrokenLibraryContent";
                break;
            }
            case 1: {
                string = "LBL_BrokenLinksCustomizer_BrokenProjectReference";
                break;
            }
            case 2: {
                string = "LBL_BrokenLinksCustomizer_BrokenFileReference";
                break;
            }
            case 6: {
                string = "LBL_BrokenLinksCustomizer_BrokenVariable";
                break;
            }
            case 7: {
                string = "LBL_BrokenLinksCustomizer_BrokenVariableContent";
                break;
            }
            case 4: {
                string = "LBL_BrokenLinksCustomizer_BrokenPlatform";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)string, (Object)oneReference.getDisplayID());
    }

    public String getDesciption(int n) {
        String string;
        OneReference oneReference = this.getOneReference(n);
        switch (oneReference.type) {
            case 3: {
                string = "LBL_BrokenLinksCustomizer_BrokenLibraryDesc";
                break;
            }
            case 5: {
                string = "LBL_BrokenLinksCustomizer_BrokenLibraryContentDesc";
                break;
            }
            case 1: {
                string = "LBL_BrokenLinksCustomizer_BrokenProjectReferenceDesc";
                break;
            }
            case 2: {
                string = "LBL_BrokenLinksCustomizer_BrokenFileReferenceDesc";
                break;
            }
            case 6: {
                string = "LBL_BrokenLinksCustomizer_BrokenVariableReferenceDesc";
                break;
            }
            case 7: {
                string = "LBL_BrokenLinksCustomizer_BrokenVariableContentDesc";
                break;
            }
            case 4: {
                string = "LBL_BrokenLinksCustomizer_BrokenPlatformDesc";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)string, (Object)oneReference.getDisplayID());
    }

    public OneReference getOneReference(int n) {
        assert (n >= 0 && n < this.references.size());
        return this.references.get(n);
    }

    public boolean isBroken(int n) {
        return this.references.get(n).broken;
    }

    @Override
    public int getSize() {
        return this.references.size();
    }

    public static boolean isBroken(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, PropertyEvaluator propertyEvaluator, String[] stringArray, String[] stringArray2) {
        Set<OneReference> set = BrokenReferencesModel.getReferences(antProjectHelper, referenceHelper, propertyEvaluator, stringArray, true);
        if (set.size() > 0) {
            return true;
        }
        set = BrokenReferencesModel.getPlatforms(propertyEvaluator, stringArray2, true);
        return set.size() > 0;
    }

    private static Set<OneReference> getReferences(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, PropertyEvaluator propertyEvaluator, String[] stringArray, boolean bl) {
        Object object;
        Object object2;
        String string4;
        Object object3;
        Object object4;
        Object object5;
        String string2;
        LinkedHashSet<OneReference> linkedHashSet = new LinkedHashSet<OneReference>();
        StringBuffer stringBuffer = new StringBuffer();
        Library[] libraryArray = LibraryManager.getDefault().getLibraries();
        Object object6 = stringArray;
        int n = ((String[])object6).length;
        for (int i = 0; i < n; ++i) {
            string2 = object6[i];
            object5 = propertyEvaluator.getProperty(string2);
            if (object5 == null) continue;
            for (String object7 : object4 = PropertyUtils.tokenizePath((String)object5)) {
                if (!(object7.startsWith("${file.reference.") || object7.startsWith("${project.") || object7.startsWith("${libs.") || object7.startsWith("${var."))) {
                    stringBuffer.append(object7);
                    continue;
                }
                if (object7.startsWith("${project.")) {
                    object3 = object7.substring(2, object7.indexOf(125));
                    linkedHashSet.add(new OneReference(1, (String)object3, true));
                } else {
                    int n2 = 3;
                    if (object7.startsWith("${file.reference")) {
                        n2 = 2;
                    } else if (object7.startsWith("${var")) {
                        n2 = 6;
                    }
                    string4 = object7.substring(2, object7.length() - 1);
                    linkedHashSet.add(new OneReference(n2, string4, true));
                }
                if (bl) break;
            }
            if (linkedHashSet.size() > 0 && bl) break;
            object2 = antProjectHelper.getProperties("nbproject/project.properties");
            String string3 = object2.getProperty(string2);
            if (string3 == null) continue;
            for (String string4 : PropertyUtils.tokenizePath((String)string3)) {
                String string5;
                if (string4.startsWith("${file.reference.")) {
                    string4 = object2.getProperty(string4.substring(2, string4.length() - 1));
                }
                if (string4 == null || !string4.startsWith("${var.") || (string5 = propertyEvaluator.evaluate(string4)).startsWith("${var.") || ((File)(object = BrokenReferencesModel.getFile(antProjectHelper, propertyEvaluator, string5))).exists()) continue;
                linkedHashSet.add(new OneReference(7, string4, true));
            }
        }
        if ((object6 = propertyEvaluator.getProperties()) == null) {
            throw new IllegalArgumentException("Properies mapping could not be computed (e.g. due to a circular definition). Evaluator: " + propertyEvaluator.toString());
        }
        for (Map.Entry entry : object6.entrySet()) {
            int n3;
            string2 = (String)entry.getKey();
            object5 = (String)entry.getValue();
            if (string2.startsWith("project.")) {
                if ("project.license".equals(string2) || ((File)(object4 = BrokenReferencesModel.getFile(antProjectHelper, propertyEvaluator, (String)object5))).exists() || stringBuffer.indexOf((String)object5) == -1) continue;
                linkedHashSet.add(new OneReference(1, string2, true));
                continue;
            }
            if (!string2.startsWith("file.reference")) continue;
            object4 = BrokenReferencesModel.getFile(antProjectHelper, propertyEvaluator, (String)object5);
            object2 = antProjectHelper.getProperties("nbproject/project.properties").getProperty(string2);
            int n4 = n3 = object2 != null ? (int)(((String)object2).startsWith("${var.") ? 1 : 0) : 0;
            if (((File)object4).exists() || stringBuffer.indexOf((String)object5) == -1 || n3 != 0) continue;
            linkedHashSet.add(new OneReference(2, string2, true));
        }
        HashSet hashSet = new HashSet();
        Pattern pattern = Pattern.compile("\\$\\{(libs\\.[-._a-zA-Z0-9]+\\.classpath)\\}");
        string2 = antProjectHelper.getProperties("nbproject/project.properties");
        for (String string6 : stringArray) {
            String string7 = string2.getProperty(string6);
            if (string7 == null) continue;
            for (String string5 : PropertyUtils.tokenizePath((String)string7)) {
                object = pattern.matcher(string5);
                if (!((Matcher)object).matches()) continue;
                hashSet.add(((Matcher)object).group(1));
            }
        }
        object5 = hashSet.iterator();
        block6: while (object5.hasNext()) {
            String string8 = (String)object5.next();
            String string9 = string8.substring(5, string8.length() - 10);
            Library library = referenceHelper.findLibrary(string9);
            if (library == null) {
                linkedHashSet.add(new OneReference(3, string8, true));
                continue;
            }
            for (URI uRI : library.getURIContent("classpath")) {
                object3 = LibrariesSupport.getArchiveFile((URI)uRI);
                if (object3 == null) {
                    object3 = uRI;
                }
                if (null != (string4 = LibrariesSupport.resolveLibraryEntryFileObject((URL)library.getManager().getLocation(), (URI)object3)) || BrokenReferencesModel.canResolveEvaluatedUri(antProjectHelper.getStandardPropertyEvaluator(), library.getManager().getLocation(), (URI)object3)) continue;
                linkedHashSet.add(new OneReference(5, string8, true));
                continue block6;
            }
        }
        return linkedHashSet;
    }

    private static boolean canResolveEvaluatedUri(PropertyEvaluator propertyEvaluator, URL uRL, URI uRI) {
        if (uRI.isAbsolute()) {
            return false;
        }
        String string = LibrariesSupport.convertURIToFilePath((URI)uRI);
        String string2 = propertyEvaluator.evaluate(string);
        if (string2.equals(string)) {
            return false;
        }
        URI uRI2 = LibrariesSupport.convertFilePathToURI((String)string2);
        return null != LibrariesSupport.resolveLibraryEntryFileObject((URL)uRL, (URI)uRI2);
    }

    private static File getFile(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, String string) {
        if (antProjectHelper != null) {
            return new File(antProjectHelper.resolvePath(string));
        }
        File file = new File(string);
        if (!file.exists()) {
            String string2 = propertyEvaluator.getProperty("basedir");
            assert (string2 != null);
            file = new File(new File(string2), string);
        }
        return file;
    }

    private static Set<OneReference> getPlatforms(PropertyEvaluator propertyEvaluator, String[] stringArray, boolean bl) {
        LinkedHashSet<OneReference> linkedHashSet = new LinkedHashSet<OneReference>();
        for (String string : stringArray) {
            String string2 = propertyEvaluator.getProperty(string);
            if (string2 == null) continue;
            if (!BrokenReferencesModel.existPlatform(string2)) {
                if (propertyEvaluator.getProperty(string + ".description") != null) {
                    string2 = propertyEvaluator.getProperty(string + ".description");
                }
                linkedHashSet.add(new OneReference(4, string2, true));
            }
            if (linkedHashSet.size() > 0 && bl) break;
        }
        return linkedHashSet;
    }

    private static void updateReferencesList(List<OneReference> list, Set<OneReference> set) {
        for (OneReference oneReference : list) {
            if (set.contains(oneReference)) {
                oneReference.broken = true;
                continue;
            }
            oneReference.broken = false;
        }
        for (OneReference oneReference : set) {
            if (list.contains(oneReference)) continue;
            list.add(oneReference);
        }
    }

    private static boolean existPlatform(String string) {
        if (string.equals("default_platform")) {
            return true;
        }
        for (JavaPlatform javaPlatform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!string.equals(javaPlatform.getProperties().get("platform.ant.name")) || javaPlatform.getInstallFolders().size() <= 0) continue;
            return true;
        }
        return false;
    }

    void updateReference(int n, File file) {
        this.updateReference0(n, file);
        OneReference oneReference = this.getOneReference(n);
        if (oneReference.getType() != 2) {
            return;
        }
        for (int i = 0; i < this.getSize(); ++i) {
            File file2;
            if (!this.isBroken(i) || i == n || (oneReference = this.getOneReference(i)).getType() != 2 || !(file2 = new File(file.getParentFile(), oneReference.getDisplayID())).exists()) continue;
            this.updateReference0(i, file2);
        }
    }

    private void updateReference0(int n, File file) {
        Project project;
        final String string = this.getOneReference(n).ID;
        FileObject fileObject = this.helper.getProjectDirectory();
        File file2 = FileUtil.toFile((FileObject)fileObject);
        final String string2 = file.getAbsolutePath();
        try {
            project = ProjectManager.getDefault().findProject(fileObject);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            project = null;
        }
        final Project project2 = project;
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                EditableProperties editableProperties = BrokenReferencesModel.this.helper.getProperties("nbproject/private/private.properties");
                if (!string2.equals(editableProperties.getProperty(string))) {
                    editableProperties.setProperty(string, string2);
                    BrokenReferencesModel.this.helper.putProperties("nbproject/private/private.properties", editableProperties);
                }
                if (project2 != null) {
                    try {
                        ProjectManager.getDefault().saveProject(project2);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(16, (Throwable)iOException);
                    }
                }
            }
        });
    }

    LibraryManager getProjectLibraryManager() {
        return this.resolver.getProjectLibraryManager() != null ? this.resolver.getProjectLibraryManager() : LibraryManager.getDefault();
    }

    public static class OneReference {
        private int type;
        private boolean broken;
        private String ID;

        public OneReference(int n, String string, boolean bl) {
            this.type = n;
            this.ID = string;
            this.broken = bl;
        }

        public int getType() {
            return this.type;
        }

        public String getDisplayID() {
            switch (this.type) {
                case 3: 
                case 5: {
                    return this.ID.substring(5, this.ID.length() - 10);
                }
                case 1: {
                    return this.ID.substring(8);
                }
                case 2: {
                    return this.ID.substring(15);
                }
                case 4: {
                    return this.ID;
                }
                case 6: {
                    return this.ID.substring(4, this.ID.indexOf("}"));
                }
                case 7: {
                    return this.ID.substring(6, this.ID.indexOf("}")) + this.ID.substring(this.ID.indexOf("}") + 1);
                }
            }
            assert (false);
            return this.ID;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof OneReference)) {
                return false;
            }
            OneReference oneReference = (OneReference)object;
            return this.type == oneReference.type && this.ID.equals(oneReference.ID);
        }

        public int hashCode() {
            int n = 7 * this.type;
            n = 31 * n + this.ID.hashCode();
            return n;
        }
    }
}

