/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.project.BrokenReferencesModel;
import org.netbeans.spi.project.support.ant.ui.VariablesSupport;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class BrokenReferencesCustomizer
extends JPanel {
    private BrokenReferencesModel model;
    private File lastSelectedFile;
    private JTextArea description;
    private JLabel descriptionLabel;
    private JList errorList;
    private JLabel errorListLabel;
    private JButton fix;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private static Icon brokenRef = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/project/resources/broken-reference.gif", (boolean)false);
    private static Icon resolvedRef = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/project/resources/resolved-reference.gif", (boolean)false);

    public BrokenReferencesCustomizer(BrokenReferencesModel brokenReferencesModel) {
        this.initComponents();
        this.model = brokenReferencesModel;
        this.errorList.setModel(brokenReferencesModel);
        this.errorList.setSelectedIndex(0);
        this.errorList.setCellRenderer(new ListCellRendererImpl(brokenReferencesModel));
    }

    private void initComponents() {
        this.errorListLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.errorList = new JList();
        this.fix = new JButton();
        this.descriptionLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.description = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(450, 300));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"ACSN_BrokenReferencesCustomizer"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"ACSD_BrokenReferencesCustomizer"));
        this.errorListLabel.setLabelFor(this.errorList);
        Mnemonics.setLocalizedText((JLabel)this.errorListLabel, (String)NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_List"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(6, 12, 3, 0);
        this.add((Component)this.errorListLabel, gridBagConstraints);
        this.errorListLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"ACSD_BrokenLinksCustomizer_List"));
        this.errorList.setSelectionMode(0);
        this.errorList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                BrokenReferencesCustomizer.this.errorListValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.errorList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.fix, (String)NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_Fix"));
        this.fix.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrokenReferencesCustomizer.this.fixActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 12);
        this.add((Component)this.fix, gridBagConstraints);
        this.fix.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"ACSD_BrokenLinksCustomizer_Fix"));
        this.descriptionLabel.setLabelFor(this.description);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_Description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 3, 0);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        this.descriptionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"ACSD_BrokenLinksCustomizer_Description"));
        this.description.setEditable(false);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.description);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 60;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
    }

    private void errorListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateSelection();
    }

    private void fixActionPerformed(ActionEvent actionEvent) {
        int n = this.errorList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        BrokenReferencesModel.OneReference oneReference = this.model.getOneReference(n);
        if (oneReference.getType() == 3 || oneReference.getType() == 5) {
            LibrariesCustomizer.showCustomizer(null, (LibraryManager)this.model.getProjectLibraryManager());
        } else if (oneReference.getType() == 4) {
            PlatformsCustomizer.showCustomizer(null);
        } else if (oneReference.getType() == 6 || oneReference.getType() == 7) {
            VariablesSupport.showVariablesCustomizer();
        } else {
            int n2;
            JFileChooser jFileChooser;
            if (oneReference.getType() == 1) {
                jFileChooser = ProjectChooser.projectChooser();
                jFileChooser.setDialogTitle(NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_Resolve_Project", (Object)oneReference.getDisplayID()));
            } else {
                jFileChooser = new JFileChooser();
                FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
                jFileChooser.setFileSelectionMode(2);
                jFileChooser.setDialogTitle(NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_Resolve_File", (Object)oneReference.getDisplayID()));
            }
            if (this.lastSelectedFile != null) {
                jFileChooser.setSelectedFile(this.lastSelectedFile);
            }
            if ((n2 = jFileChooser.showOpenDialog(null)) == 0) {
                this.model.updateReference(this.errorList.getSelectedIndex(), jFileChooser.getSelectedFile());
                this.lastSelectedFile = jFileChooser.getSelectedFile();
            }
        }
        this.model.refresh();
        this.updateSelection();
    }

    private void updateSelection() {
        if (this.errorList.getSelectedIndex() != -1 && this.errorList.getSelectedIndex() < this.model.getSize()) {
            if (this.model.isBroken(this.errorList.getSelectedIndex())) {
                this.description.setText(this.model.getDesciption(this.errorList.getSelectedIndex()));
                this.fix.setEnabled(true);
            } else {
                this.description.setText(NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_Problem_Was_Resolved"));
                this.fix.setEnabled(true);
            }
        } else {
            this.description.setText("");
            this.fix.setEnabled(false);
        }
    }

    private static class ListCellRendererImpl
    extends DefaultListCellRenderer {
        private BrokenReferencesModel model;

        public ListCellRendererImpl(BrokenReferencesModel brokenReferencesModel) {
            this.model = brokenReferencesModel;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (this.model.isBroken(n)) {
                this.setIcon(brokenRef);
            } else {
                this.setIcon(resolvedRef);
            }
            return this;
        }
    }
}

