/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.vmd.componentssupport.ui.UIUtils;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.JavaMELibsPreviewHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.DocumentAdapter;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.NameAndLocationWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NameAndLocationVisualPanel
extends JPanel {
    private static final String MSG_EMPTY_LIB_NAME = "MSG_EmptyLibraryName";
    private static final String MSG_EMPTY_LIB_DISPLAY_NAME = "MSG_EmptyLibraryDisplayName";
    private static final String MSG_LIB_EXISTS = "MSG_LibraryExists";
    private JLabel createdFiles;
    private JTextArea createdFilesValue;
    private JScrollPane createdFilesValueS;
    private JLabel libraryDisplayName;
    private JTextField libraryDisplayNameValue;
    private JLabel libraryName;
    private JTextField libraryNameValue;
    private JLabel modifiedFiles;
    private JTextArea modifiedFilesValue;
    private JScrollPane modifiedFilesValueS;
    private JLabel projectName;
    private JTextField projectNameValue;
    private WizardDescriptor mySettings;
    private NameAndLocationWizardPanel myPanel;

    NameAndLocationVisualPanel(NameAndLocationWizardPanel nameAndLocationWizardPanel) {
        this.myPanel = nameAndLocationWizardPanel;
        this.initComponents();
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                NameAndLocationVisualPanel.this.setEnabledForFilesInfo(NameAndLocationVisualPanel.this.checkValidity());
                NameAndLocationVisualPanel.this.setFilesInfoIntoTextAreas();
            }
        };
        this.libraryNameValue.getDocument().addDocumentListener(documentAdapter);
        this.libraryDisplayNameValue.getDocument().addDocumentListener(documentAdapter);
    }

    private static String getMessage(String string, Object ... objectArray) {
        return NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)string, (Object[])objectArray);
    }

    protected void storeData(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("libName", (Object)this.getLibNameValue());
        wizardDescriptor.putProperty("displayName", (Object)this.getDisplayNameValue());
    }

    void readData(WizardDescriptor wizardDescriptor) {
        this.mySettings = wizardDescriptor;
        this.libraryNameValue.setText(this.getLibName());
        this.libraryDisplayNameValue.setText(this.getDisplayName());
        this.projectNameValue.setText((String)wizardDescriptor.getProperty("projName"));
        this.checkValidity();
    }

    private void setEnabledForFilesInfo(boolean bl) {
        this.createdFilesValue.setEnabled(bl);
        this.modifiedFilesValue.setEnabled(bl);
    }

    private void setFilesInfoIntoTextAreas() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.addLibJarToList(arrayList, arrayList2);
        this.addLibXmlToList(arrayList, arrayList2);
        this.addLayerXmlToList(arrayList, arrayList2);
        this.addBundleToList(arrayList, arrayList2);
        this.createdFilesValue.setText(UIUtils.generateTextAreaContent(arrayList.toArray(new String[0])));
        this.modifiedFilesValue.setText(UIUtils.generateTextAreaContent(arrayList2.toArray(new String[0])));
    }

    private void addLibJarToList(List<String> list, List<String> list2) {
        List<String> list3 = NameAndLocationVisualPanel.getExistingArchives(this.getExistingLibraries(), this.getExistingLibraryNames());
        Library library = (Library)this.mySettings.getProperty("library");
        List<String> list4 = JavaMELibsPreviewHelper.extractLibraryJarsPaths(library, this.getLibNameValue());
        for (String string : list4) {
            if (list3.contains(string)) continue;
            list.add(string);
        }
    }

    private static List<String> getExistingArchives(List<Library> list, List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list == null || list2 == null) {
            return arrayList;
        }
        Iterator<Library> iterator = list.iterator();
        Iterator<String> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            Library library = iterator.next();
            String string = iterator2.next();
            arrayList.addAll(JavaMELibsPreviewHelper.extractLibraryJarsPaths(library, string));
        }
        return arrayList;
    }

    private void addLibXmlToList(List<String> list, List<String> list2) {
        String string = this.getCodeNameBase();
        String string2 = this.getLibNameValue();
        String string3 = string.replace('.', '/');
        list.add(string3 + "/" + string2 + ".xml");
    }

    private void addLayerXmlToList(List<String> list, List<String> list2) {
        String string = this.getCodeNameBase();
        String string2 = string.replace('.', '/');
        list2.add(string2 + "/" + "layer.xml");
    }

    private void addBundleToList(List<String> list, List<String> list2) {
        String string = this.getCodeNameBase();
        String string2 = string.replace('.', '/');
        list2.add(string2 + "/" + "Bundle.properties");
    }

    private String getDisplayName() {
        String string = (String)this.mySettings.getProperty("displayName");
        if (string == null) {
            Library library = (Library)this.mySettings.getProperty("library");
            string = library.getDisplayName();
        }
        return string;
    }

    private String getLibName() {
        String string = (String)this.mySettings.getProperty("libName");
        if (string == null) {
            Library library = (Library)this.mySettings.getProperty("library");
            string = library.getName();
        }
        return string;
    }

    private String getDisplayNameValue() {
        return this.libraryDisplayNameValue.getText();
    }

    private String getLibNameValue() {
        return this.libraryNameValue.getText();
    }

    private boolean checkValidity() {
        if (!this.isValidLibraryName()) {
            this.setError(NameAndLocationVisualPanel.getMessage(MSG_EMPTY_LIB_NAME, new Object[0]));
            return false;
        }
        if (!this.isValidLibraryDisplayName()) {
            this.setError(NameAndLocationVisualPanel.getMessage(MSG_EMPTY_LIB_DISPLAY_NAME, new Object[0]));
            return false;
        }
        if (this.isLibraryNameAlreadyExists()) {
            this.setError(NameAndLocationVisualPanel.getMessage(MSG_LIB_EXISTS, this.getLibNameValue()));
            return false;
        }
        this.markValid();
        return true;
    }

    private boolean isValidLibraryName() {
        return this.getLibNameValue() != null && this.getLibNameValue().trim().length() != 0;
    }

    public boolean isValidLibraryDisplayName() {
        return this.getDisplayNameValue() != null && this.getDisplayNameValue().trim().length() != 0;
    }

    public boolean isLibraryNameAlreadyExists() {
        String string = this.getLibNameValue();
        List<String> list = this.getExistingLibraryNames();
        if (list == null || list.size() == 0) {
            return false;
        }
        for (String string2 : list) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private List<String> getExistingLibraryNames() {
        return (List)this.mySettings.getProperty("existLibName");
    }

    private List<Library> getExistingLibraries() {
        return (List)this.mySettings.getProperty("existLibrary");
    }

    private String getCodeNameBase() {
        return (String)this.mySettings.getProperty("codeBaseName");
    }

    protected final void setError(String string) {
        assert (string != null);
        this.setMessage(string);
        this.setValid(false);
    }

    protected final void markValid() {
        this.setMessage(null);
        this.setValid(true);
    }

    private final void setMessage(String string) {
        this.mySettings.putProperty("WizardPanel_errorMessage", (Object)string);
    }

    private final void setValid(boolean bl) {
        this.myPanel.setValid(bl);
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(NameAndLocationVisualPanel.class);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.checkValidity();
    }

    private void initComponents() {
        this.libraryName = new JLabel();
        this.libraryNameValue = new JTextField();
        this.libraryDisplayName = new JLabel();
        this.libraryDisplayNameValue = new JTextField();
        this.projectName = new JLabel();
        this.projectNameValue = new JTextField();
        this.createdFiles = new JLabel();
        this.modifiedFiles = new JLabel();
        this.createdFilesValueS = new JScrollPane();
        this.createdFilesValue = new JTextArea();
        this.modifiedFilesValueS = new JScrollPane();
        this.modifiedFilesValue = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.libraryName.setLabelFor(this.libraryNameValue);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/vmd/componentssupport/ui/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.libraryName, (String)resourceBundle.getString("LBL_LibraryName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 0, 6, 12);
        this.add((Component)this.libraryName, gridBagConstraints);
        this.libraryName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_Name"));
        this.libraryName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 6, 0);
        this.add((Component)this.libraryNameValue, gridBagConstraints);
        this.libraryDisplayName.setLabelFor(this.libraryDisplayNameValue);
        Mnemonics.setLocalizedText((JLabel)this.libraryDisplayName, (String)resourceBundle.getString("LBL_LibraryDisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.libraryDisplayName, gridBagConstraints);
        this.libraryDisplayName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_DisplayName"));
        this.libraryDisplayName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_DisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.libraryDisplayNameValue, gridBagConstraints);
        this.projectName.setLabelFor(this.projectNameValue);
        Mnemonics.setLocalizedText((JLabel)this.projectName, (String)resourceBundle.getString("LBL_LibraryProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(18, 0, 6, 12);
        this.add((Component)this.projectName, gridBagConstraints);
        this.projectName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_LibraryProjectName"));
        this.projectName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_LibraryProjectName"));
        this.projectNameValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 6, 0);
        this.add((Component)this.projectNameValue, gridBagConstraints);
        this.projectNameValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACSN_ProjectName"));
        this.projectNameValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACSD_ProjectName"));
        this.createdFiles.setLabelFor(this.createdFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.createdFiles, (String)resourceBundle.getString("LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add((Component)this.createdFiles, gridBagConstraints);
        this.createdFiles.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_CreatedFiles"));
        this.createdFiles.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_CreatedFiles"));
        this.modifiedFiles.setLabelFor(this.modifiedFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFiles, (String)resourceBundle.getString("LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.modifiedFiles, gridBagConstraints);
        this.modifiedFiles.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_ModifiedFiles"));
        this.modifiedFiles.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_ModifiedFiles"));
        this.createdFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFilesValue.setColumns(20);
        this.createdFilesValue.setEditable(false);
        this.createdFilesValue.setRows(5);
        this.createdFilesValue.setToolTipText(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"LBL_CreatedFilesTip"));
        this.createdFilesValue.setBorder(null);
        this.createdFilesValueS.setViewportView(this.createdFilesValue);
        this.createdFilesValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACSN_CreatedFiles"));
        this.createdFilesValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACSD_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add((Component)this.createdFilesValueS, gridBagConstraints);
        this.modifiedFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFilesValue.setColumns(20);
        this.modifiedFilesValue.setEditable(false);
        this.modifiedFilesValue.setRows(5);
        this.modifiedFilesValue.setToolTipText(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"LBL_ModifiedFilesTip"));
        this.modifiedFilesValue.setBorder(null);
        this.modifiedFilesValueS.setViewportView(this.modifiedFilesValue);
        this.modifiedFilesValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACSN_ModifiedFiles"));
        this.modifiedFilesValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACSD_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.modifiedFilesValueS, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_NameLocationPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_NameLocationPanel"));
    }
}

