/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.componentssupport.ui.UIUtils;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.CustomComponentHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.ComponentDescriptorWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.DocumentAdapter;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.NewComponentDescriptor;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.Version;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class ComponentDescriptorVisualPanel
extends JPanel {
    public static final String TXT_DEFAULT_PREFIX = "TXT_DefaultClassNamePrefix";
    private static final String MSG_ERR_PREFIX_EMPTY = "MSG_CD_EmptyPrefix";
    private static final String MSG_ERR_PREFIX_WITH_DOT = "MSG_CD_DotInPrefix";
    private static final String MSG_ERR_PREFIX_INVALID = "MSG_CD_InvalidPrefix";
    private static final String MSG_ERR_CLASS_NAME_EMPTY = "MSG_CD_EmptyClassName";
    private static final String MSG_ERR_CLASS_NAME_INVALID = "MSG_CD_InvalidClassName";
    private static final String MSG_ERR_CLASS_NAME_EXISTS = "MSG_CD_ExistingClassName";
    private static final String MSG_ERR_TYPE_ID_EMPTY = "MSG_CD_EmptyTypeID";
    private static final String MSG_ERR_SUPER_CLASS_EMPTY = "MSG_CD_EmptySuperClass";
    private static final String MSG_ERR_SUPER_CLASS_INVALID = "MSG_CD_InvalidSuperClass";
    private JTextField myCDClassName;
    private JLabel myCDClassNameLabel;
    private JTextField myCDSuperClass;
    private JLabel myCDSuperClassLabel;
    private JTextField myCDTypeId;
    private JLabel myCDTypeIdLabel;
    private JComboBox myCDVersionCombo;
    private JLabel myCDVersionLabel;
    private JCheckBox myCanBeSuperChk;
    private JCheckBox myCanInstantiateChk;
    private JPanel myCompDescrPanel;
    private JPanel myCustCompPanel;
    private JPanel myCustCompPrefixPanel;
    private JTextField myPrefix;
    private JLabel myPrefixLabel;
    private WizardDescriptor mySettings;
    private ComponentDescriptorWizardPanel myPanel;
    private boolean isCDClassNameUpdated;
    private boolean isCDTypeIdUpdated;
    private boolean listenersAttached;
    private DocumentListener myPrefixListener;
    private DocumentListener myClassNAmeListener;
    private DocumentListener myTypeIdListener;
    private DocumentListener mySuperClassListener;

    ComponentDescriptorVisualPanel(ComponentDescriptorWizardPanel componentDescriptorWizardPanel) {
        this.myPanel = componentDescriptorWizardPanel;
        this.initComponents();
        this.myCDVersionCombo.setModel(Version.getComboBoxModel());
        this.myPrefixListener = new DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ComponentDescriptorVisualPanel.this.updateValuesOnPrefixUpdate();
                ComponentDescriptorVisualPanel.this.checkValidity();
            }
        };
        this.myClassNAmeListener = new DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ComponentDescriptorVisualPanel.this.isCDClassNameUpdated = true;
                ComponentDescriptorVisualPanel.this.updateValuesOnClassNameUpdate();
                ComponentDescriptorVisualPanel.this.checkValidity();
            }
        };
        this.myTypeIdListener = new DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ComponentDescriptorVisualPanel.this.isCDTypeIdUpdated = true;
                ComponentDescriptorVisualPanel.this.checkValidity();
            }
        };
        this.mySuperClassListener = new DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ComponentDescriptorVisualPanel.this.checkValidity();
            }
        };
    }

    void storeData(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("prefix", (Object)this.getPrefixValue());
        wizardDescriptor.putProperty("compDescrClassName", (Object)this.getClassNameValue());
        wizardDescriptor.putProperty("compDescrTypeId", (Object)this.getTypeIdValue());
        wizardDescriptor.putProperty("compDescrSuperClass", (Object)this.getSuperDescrValue());
        wizardDescriptor.putProperty("compDescrVersion", (Object)this.getVersionValue());
        wizardDescriptor.putProperty("compDescrCanInstantiate", (Object)this.getCanInstantiateValue());
        wizardDescriptor.putProperty("compDescrCanBeSuper", (Object)this.getCanBeSuperValue());
    }

    void readData(WizardDescriptor wizardDescriptor) {
        this.mySettings = wizardDescriptor;
        this.myPrefix.setText(this.getPrefix());
        if (this.getClassName() != null) {
            this.myCDClassName.setText(this.getClassName());
        }
        if (this.getTypeId() != null) {
            this.myCDTypeId.setText(this.getTypeId());
        }
        this.myCDSuperClass.setText(this.getSuperDescriptor());
        this.myCDVersionCombo.setSelectedItem((Object)this.getVersion());
        this.myCanInstantiateChk.setSelected(this.getCanInstantiate());
        this.myCanBeSuperChk.setSelected(this.getCanBeSuper());
        this.updateValuesOnPrefixUpdate();
        this.checkValidity();
    }

    public void addNotify() {
        super.addNotify();
        this.attachDocumentListeners();
        this.checkValidity();
    }

    public void removeNotify() {
        this.removeDocumentListeners();
        super.removeNotify();
    }

    private void attachDocumentListeners() {
        if (!this.listenersAttached) {
            this.myPrefix.getDocument().addDocumentListener(this.myPrefixListener);
            this.myCDClassName.getDocument().addDocumentListener(this.myClassNAmeListener);
            this.myCDTypeId.getDocument().addDocumentListener(this.myTypeIdListener);
            this.myCDSuperClass.getDocument().addDocumentListener(this.mySuperClassListener);
            this.listenersAttached = true;
        }
    }

    private void removeDocumentListeners() {
        if (this.listenersAttached) {
            this.myPrefix.getDocument().removeDocumentListener(this.myPrefixListener);
            this.myCDClassName.getDocument().removeDocumentListener(this.myClassNAmeListener);
            this.myCDTypeId.getDocument().removeDocumentListener(this.myTypeIdListener);
            this.myCDSuperClass.getDocument().removeDocumentListener(this.mySuperClassListener);
            this.listenersAttached = false;
        }
    }

    private String getTypeId() {
        return (String)this.mySettings.getProperty("compDescrTypeId");
    }

    private String getClassName() {
        return (String)this.mySettings.getProperty("compDescrClassName");
    }

    private String getSuperDescriptor() {
        String string = (String)this.mySettings.getProperty("compDescrSuperClass");
        if (string == null) {
            string = "org.netbeans.modules.vmd.midp.components.displayables.DisplayableCD";
        }
        return string;
    }

    private boolean getCanInstantiate() {
        Object object = this.mySettings.getProperty("compDescrCanInstantiate");
        return ComponentDescriptorVisualPanel.extractBoolean(object, true);
    }

    private boolean getCanBeSuper() {
        Object object = this.mySettings.getProperty("compDescrCanBeSuper");
        return ComponentDescriptorVisualPanel.extractBoolean(object, true);
    }

    private static boolean extractBoolean(Object object, boolean bl) {
        if (object == null || !(object instanceof Boolean)) {
            return bl;
        }
        return (Boolean)object;
    }

    private String getPrefix() {
        String string = (String)this.mySettings.getProperty("prefix");
        if (string == null) {
            string = this.getDefaultPrefix();
        }
        return string;
    }

    private String getDefaultPrefix() {
        String string = ComponentDescriptorVisualPanel.getMessage(TXT_DEFAULT_PREFIX, new Object[0]);
        int n = 1;
        String string2 = this.getDefaultFreePrefix(string, "");
        while (string2 == null) {
            string2 = this.getDefaultFreePrefix(string, "" + n);
            ++n;
        }
        return string2;
    }

    private String getDefaultFreePrefix(String string, String string2) {
        String string3 = string + string2;
        String string4 = NewComponentDescriptor.createDefaultCDClass(string3);
        String string5 = NewComponentDescriptor.createDefaultProducerClass(string3);
        if (this.getHelper().isCDClassNameExist(string4) || this.getHelper().isProducerClassNameExist(string5)) {
            string3 = null;
        }
        return string3;
    }

    private Version getVersion() {
        Object object = this.mySettings.getProperty("compDescrVersion");
        if (object == null || !(object instanceof Version)) {
            return Version.MIDP;
        }
        return (Version)((Object)object);
    }

    private boolean checkValidity() {
        if (!this.isCCPrefixValid()) {
            return false;
        }
        if (!this.isCCClassNameValid()) {
            return false;
        }
        if (!this.isCCTypeIDValid()) {
            return false;
        }
        if (!this.isCCSuperClassValid()) {
            return false;
        }
        this.markValid();
        return true;
    }

    private void updateValuesOnPrefixUpdate() {
        if (this.isCCPrefixValid()) {
            if (!this.isCDClassNameUpdated) {
                this.myCDClassName.setText(NewComponentDescriptor.createDefaultCDClass(this.getPrefixValue()));
                this.isCDClassNameUpdated = false;
            }
            if (!this.isCDTypeIdUpdated) {
                this.myCDTypeId.setText(this.getCodeNameBase() + "." + this.getPrefixValue());
                this.isCDTypeIdUpdated = false;
            }
        }
    }

    private void updateValuesOnClassNameUpdate() {
        if (this.isCCClassNameValid() && !this.isCDTypeIdUpdated) {
            this.myCDTypeId.setText(this.getCodeNameBase() + "." + this.getPrefixValue());
            this.isCDTypeIdUpdated = false;
        }
    }

    private String getCodeNameBase() {
        return this.getHelper().getCodeNameBase();
    }

    private CustomComponentHelper getHelper() {
        return (CustomComponentHelper)this.mySettings.getProperty("custCompHelper");
    }

    private boolean isCCClassNameValid() {
        String string = this.getClassNameValue();
        if (string.length() == 0) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_CLASS_NAME_EMPTY, new Object[0]));
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)string)) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_CLASS_NAME_INVALID, new Object[0]));
            return false;
        }
        if (this.getHelper().isCDClassNameExist(string)) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_CLASS_NAME_EXISTS, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isCCTypeIDValid() {
        String string = this.getTypeIdValue();
        if (string.length() == 0) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_TYPE_ID_EMPTY, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isCCSuperClassValid() {
        String string = this.getSuperDescrValue();
        if (string.length() == 0) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_SUPER_CLASS_EMPTY, new Object[0]));
            return false;
        }
        if (!UIUtils.isValidJavaFQN(string)) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_SUPER_CLASS_INVALID, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isCCPrefixValid() {
        String string = this.getPrefixValue();
        if (string.length() == 0) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_PREFIX_EMPTY, new Object[0]));
            return false;
        }
        if (string.contains(".")) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_PREFIX_WITH_DOT, new Object[0]));
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)string)) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_PREFIX_INVALID, new Object[0]));
            return false;
        }
        return true;
    }

    private String getPrefixValue() {
        return this.myPrefix.getText().trim();
    }

    private String getClassNameValue() {
        return this.myCDClassName.getText().trim();
    }

    private String getTypeIdValue() {
        return this.myCDTypeId.getText().trim();
    }

    private String getSuperDescrValue() {
        return this.myCDSuperClass.getText().trim();
    }

    private Version getVersionValue() {
        return (Version)((Object)this.myCDVersionCombo.getSelectedItem());
    }

    private Boolean getCanInstantiateValue() {
        return this.myCanInstantiateChk.isSelected();
    }

    private Boolean getCanBeSuperValue() {
        return this.myCanBeSuperChk.isSelected();
    }

    protected final void setError(String string) {
        assert (string != null);
        this.setMessage(string);
        this.setValid(false);
    }

    protected final void markValid() {
        this.setMessage(null);
        this.setValid(true);
    }

    private final void setMessage(String string) {
        this.mySettings.putProperty("WizardPanel_errorMessage", (Object)string);
    }

    private final void setValid(boolean bl) {
        this.myPanel.setValid(bl);
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(ComponentDescriptorVisualPanel.class);
    }

    private static String getMessage(String string, Object ... objectArray) {
        return NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)string, (Object[])objectArray);
    }

    private void initComponents() {
        this.myCustCompPanel = new JPanel();
        this.myCustCompPrefixPanel = new JPanel();
        this.myPrefixLabel = new JLabel();
        this.myPrefix = new JTextField();
        this.myCompDescrPanel = new JPanel();
        this.myCDVersionLabel = new JLabel();
        this.myCDVersionCombo = new JComboBox();
        this.myCDClassNameLabel = new JLabel();
        this.myCDTypeIdLabel = new JLabel();
        this.myCDSuperClassLabel = new JLabel();
        this.myCDSuperClass = new JTextField();
        this.myCDTypeId = new JTextField();
        this.myCDClassName = new JTextField();
        this.myCanInstantiateChk = new JCheckBox();
        this.myCanBeSuperChk = new JCheckBox();
        this.myCustCompPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_CustomComponentArea")));
        this.myPrefixLabel.setLabelFor(this.myPrefix);
        Mnemonics.setLocalizedText((JLabel)this.myPrefixLabel, (String)NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_Prefix"));
        this.myPrefix.setToolTipText(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_Prefix"));
        GroupLayout groupLayout = new GroupLayout((Container)this.myCustCompPrefixPanel);
        this.myCustCompPrefixPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.myPrefixLabel).addPreferredGap(0).add((Component)this.myPrefix, -1, 415, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.myPrefixLabel).add((Component)this.myPrefix, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.myPrefixLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_Prefix"));
        this.myPrefixLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_Prefix"));
        this.myPrefix.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_Prefix"));
        this.myPrefix.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_Prefix"));
        this.myCompDescrPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_ComponentDescriptor")));
        this.myCDVersionLabel.setLabelFor(this.myCDVersionCombo);
        Mnemonics.setLocalizedText((JLabel)this.myCDVersionLabel, (String)NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_Version"));
        this.myCDClassNameLabel.setLabelFor(this.myCDClassName);
        Mnemonics.setLocalizedText((JLabel)this.myCDClassNameLabel, (String)NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_ClassName"));
        this.myCDTypeIdLabel.setLabelFor(this.myCDTypeId);
        Mnemonics.setLocalizedText((JLabel)this.myCDTypeIdLabel, (String)NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_TypeId"));
        this.myCDSuperClassLabel.setLabelFor(this.myCDSuperClass);
        Mnemonics.setLocalizedText((JLabel)this.myCDSuperClassLabel, (String)NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_SuperDescriptorClass"));
        this.myCDSuperClass.setToolTipText(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_SuperDescriptorClass"));
        this.myCDTypeId.setToolTipText(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_TypeId"));
        this.myCDClassName.setToolTipText(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_ClassName"));
        Mnemonics.setLocalizedText((AbstractButton)this.myCanInstantiateChk, (String)NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_CanInstantiate"));
        Mnemonics.setLocalizedText((AbstractButton)this.myCanBeSuperChk, (String)NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_CanBeSuperType"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.myCompDescrPanel);
        this.myCompDescrPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.myCDClassNameLabel).add((Component)this.myCDTypeIdLabel).add((Component)this.myCDSuperClassLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (Component)this.myCDTypeId, -1, 323, Short.MAX_VALUE).add((Component)this.myCDClassName, -1, 323, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.myCDVersionCombo, -2, -1, -2).add((Component)this.myCDSuperClass, -1, 323, Short.MAX_VALUE))))).add((Component)this.myCDVersionLabel).add((Component)this.myCanInstantiateChk).add((Component)this.myCanBeSuperChk)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.myCDClassNameLabel).add((Component)this.myCDClassName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.myCDTypeIdLabel).add((Component)this.myCDTypeId, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.myCDSuperClass, -2, -1, -2).add((Component)this.myCDSuperClassLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.myCDVersionLabel).add((Component)this.myCDVersionCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.myCanInstantiateChk).addPreferredGap(0).add((Component)this.myCanBeSuperChk).addContainerGap(-1, Short.MAX_VALUE)));
        this.myCDVersionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_Version"));
        this.myCDVersionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_Version"));
        this.myCDClassNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_ClassName"));
        this.myCDClassNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_ClassName"));
        this.myCDTypeIdLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_TypeId"));
        this.myCDTypeIdLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_TypeId"));
        this.myCDSuperClassLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_SuperDescriptorClass"));
        this.myCDSuperClassLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_SuperDescriptorClass"));
        this.myCanInstantiateChk.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_CanInstantiate"));
        this.myCanInstantiateChk.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_CanInstantiate"));
        this.myCanBeSuperChk.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_CanBeSuperType"));
        this.myCanBeSuperChk.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_CanBeSuperType"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.myCustCompPanel);
        this.myCustCompPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (Component)this.myCustCompPrefixPanel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.myCompDescrPanel, -1, -1, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.myCustCompPrefixPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.myCompDescrPanel, -2, -1, -2)));
        GroupLayout groupLayout4 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add(2, (Component)this.myCustCompPanel, -1, -1, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.myCustCompPanel, -2, -1, -2).addContainerGap(102, Short.MAX_VALUE)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_Panel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_Panel"));
    }
}

