/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.LoadClass;
import org.netbeans.lib.profiler.heap.StackFrameSegment;

class StackFrame
extends HprofObject {
    static final int NO_LINE_INFO = 0;
    static final int UNKNOWN_LOCATION = -1;
    static final int COMPILED_METHOD = -2;
    static final int NATIVE_METHOD = -3;
    private final StackFrameSegment stackFrameSegment;

    StackFrame(StackFrameSegment stackFrameSegment, long l) {
        super(l);
        this.stackFrameSegment = stackFrameSegment;
        assert (this.getHprofBuffer().get(l) == 4);
    }

    long getStackFrameID() {
        return this.getHprofBuffer().getID(this.fileOffset + (long)this.stackFrameSegment.stackFrameIDOffset);
    }

    String getMethodName() {
        return this.getStringByOffset(this.stackFrameSegment.methodIDOffset);
    }

    String getMethodSignature() {
        return this.getStringByOffset(this.stackFrameSegment.methodSignatureIDOffset);
    }

    String getSourceFile() {
        return this.getStringByOffset(this.stackFrameSegment.sourceIDOffset);
    }

    String getClassName() {
        long l = this.getHprofBuffer().getID(this.fileOffset + (long)this.stackFrameSegment.classSerialNumberOffset);
        LoadClass loadClass = this.stackFrameSegment.hprofHeap.getLoadClassSegment().getClassBySerialNumber(l);
        return loadClass.getName();
    }

    int getLineNumber() {
        return this.getHprofBuffer().getInt(this.fileOffset + (long)this.stackFrameSegment.lineNumberOffset);
    }

    private HprofByteBuffer getHprofBuffer() {
        return this.stackFrameSegment.hprofHeap.dumpBuffer;
    }

    private String getStringByOffset(long l) {
        long l2 = this.getHprofBuffer().getID(this.fileOffset + l);
        return this.stackFrameSegment.hprofHeap.getStringSegment().getStringByID(l2);
    }
}

