/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;

class HprofLongMappedByteBuffer
extends HprofByteBuffer {
    private static int BUFFER_SIZE_BITS = 30;
    private static long BUFFER_SIZE = 1L << BUFFER_SIZE_BITS;
    private static int BUFFER_SIZE_MASK = (int)(BUFFER_SIZE - 1L);
    private static int BUFFER_EXT = 32768;
    private MappedByteBuffer[] dumpBuffer;

    HprofLongMappedByteBuffer(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        this.length = fileChannel.size();
        this.dumpBuffer = new MappedByteBuffer[(int)((this.length + BUFFER_SIZE - 1L) / BUFFER_SIZE)];
        for (int i = 0; i < this.dumpBuffer.length; ++i) {
            long l = (long)i * BUFFER_SIZE;
            long l2 = Math.min(BUFFER_SIZE + (long)BUFFER_EXT, this.length - l);
            this.dumpBuffer[i] = fileChannel.map(FileChannel.MapMode.READ_ONLY, l, l2);
        }
        fileChannel.close();
        this.readHeader();
    }

    char getChar(long l) {
        return this.dumpBuffer[this.getBufferIndex(l)].getChar(this.getBufferOffset(l));
    }

    double getDouble(long l) {
        return this.dumpBuffer[this.getBufferIndex(l)].getDouble(this.getBufferOffset(l));
    }

    float getFloat(long l) {
        return this.dumpBuffer[this.getBufferIndex(l)].getFloat(this.getBufferOffset(l));
    }

    int getInt(long l) {
        return this.dumpBuffer[this.getBufferIndex(l)].getInt(this.getBufferOffset(l));
    }

    long getLong(long l) {
        return this.dumpBuffer[this.getBufferIndex(l)].getLong(this.getBufferOffset(l));
    }

    short getShort(long l) {
        return this.dumpBuffer[this.getBufferIndex(l)].getShort(this.getBufferOffset(l));
    }

    byte get(long l) {
        return this.dumpBuffer[this.getBufferIndex(l)].get(this.getBufferOffset(l));
    }

    synchronized void get(long l, byte[] byArray) {
        MappedByteBuffer mappedByteBuffer = this.dumpBuffer[this.getBufferIndex(l)];
        mappedByteBuffer.position(this.getBufferOffset(l));
        mappedByteBuffer.get(byArray);
    }

    private int getBufferIndex(long l) {
        return (int)(l >> BUFFER_SIZE_BITS);
    }

    private int getBufferOffset(long l) {
        return (int)(l & (long)BUFFER_SIZE_MASK);
    }
}

