/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.indent.spi;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.editor.indent.ProxyPreferences;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeStylePreferences {
    private static final Logger LOG = Logger.getLogger(CodeStylePreferences.class.getName());
    private static final String NODE_CODE_STYLE = "CodeStyle";
    private static final String PROP_USED_PROFILE = "usedProfile";
    private static final String DEFAULT_PROFILE = "default";
    private static final String PROJECT_PROFILE = "project";
    private static final Map<Object, Map<String, CodeStylePreferences>> cache = new WeakHashMap<Object, Map<String, CodeStylePreferences>>();
    private final String mimeType;
    private final Reference<Document> refDoc;
    private final String filePath;
    private final Preferences projectRoot;
    private final Preferences globalPrefs;
    private Preferences projectPrefs;
    private boolean useProject;
    private final PreferenceChangeListener switchTrakcer = new PreferenceChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            if (preferenceChangeEvent.getKey() == null || CodeStylePreferences.PROP_USED_PROFILE.equals(preferenceChangeEvent.getKey())) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    CodeStylePreferences.this.useProject = CodeStylePreferences.PROJECT_PROFILE.equals(preferenceChangeEvent.getNewValue());
                    LOG.fine("file '" + CodeStylePreferences.this.filePath + "' (" + CodeStylePreferences.this.mimeType + ") is using " + (CodeStylePreferences.this.useProject ? CodeStylePreferences.PROJECT_PROFILE : "global") + " Preferences");
                }
            }
        }
    };

    public static CodeStylePreferences get(Document document) {
        return CodeStylePreferences.get(document, document != null ? (String)document.getProperty("mimeType") : null);
    }

    public static CodeStylePreferences get(Document document, String string) {
        if (document != null) {
            return CodeStylePreferences.getPreferences(document, string);
        }
        return CodeStylePreferences.getPreferences(null, null);
    }

    public static CodeStylePreferences get(FileObject fileObject) {
        return CodeStylePreferences.get(fileObject, fileObject != null ? fileObject.getMIMEType() : null);
    }

    public static CodeStylePreferences get(FileObject fileObject, String string) {
        if (fileObject != null) {
            return CodeStylePreferences.getPreferences(fileObject, string);
        }
        return CodeStylePreferences.getPreferences(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences getPreferences() {
        CodeStylePreferences codeStylePreferences = this;
        synchronized (codeStylePreferences) {
            Object object;
            Document document = this.refDoc == null ? null : this.refDoc.get();
            Object object2 = object = document == null ? null : document.getProperty("Tools-Options->Editor->Formatting->Preview - Preferences");
            if (object instanceof Preferences) {
                return (Preferences)object;
            }
            Preferences preferences = this.useProject ? this.projectPrefs : this.globalPrefs;
            return preferences == null ? AbstractPreferences.systemRoot() : preferences;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CodeStylePreferences getPreferences(Object object, String string) {
        Map<Object, Map<String, CodeStylePreferences>> map = cache;
        synchronized (map) {
            CodeStylePreferences codeStylePreferences;
            Map<String, CodeStylePreferences> map2 = cache.get(object);
            CodeStylePreferences codeStylePreferences2 = codeStylePreferences = map2 != null ? map2.get(string) : null;
            if (codeStylePreferences == null) {
                FileObject fileObject;
                Document document;
                if (object instanceof FileObject) {
                    document = null;
                    fileObject = (FileObject)object;
                } else {
                    document = (Document)object;
                    fileObject = CodeStylePreferences.findFileObject(document);
                }
                codeStylePreferences = new CodeStylePreferences(CodeStylePreferences.findProjectPreferences(fileObject), string, document == null ? null : new WeakReference<Document>(document), fileObject == null ? "no file" : fileObject.getPath());
                if (map2 == null) {
                    map2 = new HashMap<String, CodeStylePreferences>();
                    cache.put(object, map2);
                }
                map2.put(string, codeStylePreferences);
            }
            return codeStylePreferences;
        }
    }

    private CodeStylePreferences(Preferences preferences, String string, Reference<Document> reference, String string2) {
        this.projectRoot = preferences;
        this.mimeType = string;
        this.refDoc = reference;
        this.filePath = string2;
        this.globalPrefs = (Preferences)MimeLookup.getLookup((MimePath)(string == null ? MimePath.EMPTY : MimePath.parse((String)string))).lookup(Preferences.class);
        this.projectPrefs = null;
        this.useProject = false;
        ProjectManager.mutex().postReadRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                CodeStylePreferences codeStylePreferences = CodeStylePreferences.this;
                synchronized (codeStylePreferences) {
                    if (CodeStylePreferences.this.projectRoot != null) {
                        Preferences preferences = CodeStylePreferences.this.projectRoot.node(CodeStylePreferences.NODE_CODE_STYLE);
                        Preferences preferences2 = preferences.node(CodeStylePreferences.PROJECT_PROFILE);
                        String string = preferences.get(CodeStylePreferences.PROP_USED_PROFILE, CodeStylePreferences.DEFAULT_PROFILE);
                        CodeStylePreferences.this.useProject = CodeStylePreferences.PROJECT_PROFILE.equals(string);
                        CodeStylePreferences.this.projectPrefs = CodeStylePreferences.this.mimeType == null ? preferences2 : new ProxyPreferences(CodeStylePreferences.this.projectRoot.node(CodeStylePreferences.this.mimeType).node(CodeStylePreferences.NODE_CODE_STYLE).node(CodeStylePreferences.PROJECT_PROFILE), preferences2);
                        preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)CodeStylePreferences.this.switchTrakcer, (Object)preferences));
                    } else {
                        CodeStylePreferences.this.useProject = false;
                        CodeStylePreferences.this.projectPrefs = null;
                    }
                }
            }
        });
        LOG.fine("file '" + string2 + "' (" + string + ") is using " + (this.useProject ? PROJECT_PROFILE : "global") + " Preferences; doc=" + CodeStylePreferences.s2s(reference == null ? null : reference.get()));
    }

    private static final Preferences findProjectPreferences(FileObject fileObject) {
        Project project;
        if (fileObject != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null) {
            return ProjectUtils.getPreferences((Project)project, IndentUtils.class, (boolean)true);
        }
        return null;
    }

    private static final FileObject findFileObject(Document document) {
        if (document != null) {
            Object object = document.getProperty("stream");
            if (object instanceof DataObject) {
                return ((DataObject)object).getPrimaryFile();
            }
            if (object instanceof FileObject) {
                return (FileObject)object;
            }
        }
        return null;
    }

    private static String s2s(Object object) {
        return object == null ? "null" : object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }
}

