/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.ui.utils.ListEditorPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.FolderEntry;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.cnd.makeproject.ui.wizards.ParserConfigurationDescriptorPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ParserConfigurationPanel
extends JPanel
implements HelpCtx.Provider {
    private ParserConfigurationDescriptorPanel sourceFoldersDescriptorPanel;
    private boolean first = true;
    private JRadioButton automaticButton;
    private ButtonGroup buttonGroup1;
    private JLabel codeModelLabel;
    private JPanel codeModelPanel;
    private JButton includeEditButton;
    private JLabel includeLabel;
    private JTextField includeTextField;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JButton macroEditButton;
    private JTextField macroTextField;
    private JRadioButton manualButton;

    public ParserConfigurationPanel(ParserConfigurationDescriptorPanel parserConfigurationDescriptorPanel) {
        this.initComponents();
        this.sourceFoldersDescriptorPanel = parserConfigurationDescriptorPanel;
        this.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("INCLUDE_LABEL_AD"));
        this.includeTextField.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("INCLUDE_LABEL_AD"));
        this.includeEditButton.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("INCLUDE_BROWSE_BUTTON_AD"));
        this.macroTextField.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("MACRO_LABEL_AD"));
        this.macroEditButton.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("MACRO_EDIT_BUTTON_AD"));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NewMakeWizardP4");
    }

    private void update(DocumentEvent documentEvent) {
        this.sourceFoldersDescriptorPanel.stateChanged(null);
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.manualButton.setEnabled(true);
        this.automaticButton.setEnabled(true);
        this.automaticButton.setSelected(true);
        this.togglePanel(false);
        if (this.first) {
            this.first = false;
            ArrayList arrayList = (ArrayList)wizardDescriptor.getProperty("sourceFoldersList");
            if (arrayList != null) {
                StringBuilder stringBuilder = new StringBuilder();
                for (FolderEntry folderEntry : arrayList) {
                    File file;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(';');
                    }
                    if ((file = folderEntry.getFile()) == null) continue;
                    stringBuilder.append(file.getAbsolutePath());
                    if (!file.isDirectory()) continue;
                    for (File file2 : file.listFiles()) {
                        if (!file2.isDirectory() || !file2.getName().toLowerCase().endsWith("include")) continue;
                        stringBuilder.append(';');
                        stringBuilder.append(file2.getAbsolutePath());
                    }
                }
                this.includeTextField.setText(stringBuilder.toString());
            }
        }
    }

    void store(WizardDescriptor wizardDescriptor) {
        if (this.manualButton.isSelected()) {
            wizardDescriptor.putProperty("includeTextField", (Object)this.includeTextField.getText());
            wizardDescriptor.putProperty("macroTextField", (Object)this.macroTextField.getText());
            wizardDescriptor.putProperty("manualCA", (Object)"true");
        } else {
            wizardDescriptor.putProperty("includeTextField", (Object)"");
            wizardDescriptor.putProperty("macroTextField", (Object)"");
            wizardDescriptor.putProperty("manualCA", (Object)"false");
        }
        wizardDescriptor.putProperty("consolidationLevel", (Object)"file");
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        return true;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.codeModelPanel = new JPanel();
        this.includeLabel = new JLabel();
        this.includeTextField = new JTextField();
        this.includeEditButton = new JButton();
        this.jLabel2 = new JLabel();
        this.macroTextField = new JTextField();
        this.codeModelLabel = new JLabel();
        this.macroEditButton = new JButton();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.manualButton = new JRadioButton();
        this.automaticButton = new JRadioButton();
        this.jPanel1 = new JPanel();
        this.setMinimumSize(new Dimension(300, 158));
        this.setPreferredSize(new Dimension(323, 223));
        this.setLayout(new GridBagLayout());
        this.codeModelPanel.setLayout(new GridBagLayout());
        this.includeLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("INCLUDE_LABEL_MN").charAt(0));
        this.includeLabel.setLabelFor(this.includeTextField);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        this.includeLabel.setText(resourceBundle.getString("INCLUDE_LABEL_TXT"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.codeModelPanel.add((Component)this.includeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.codeModelPanel.add((Component)this.includeTextField, gridBagConstraints);
        this.includeEditButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("INCLUDE_BROWSE_BUTTON_MN").charAt(0));
        this.includeEditButton.setText(resourceBundle.getString("INCLUDE_BROWSE_BUTTON_TXT"));
        this.includeEditButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParserConfigurationPanel.this.includeEditButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.codeModelPanel.add((Component)this.includeEditButton, gridBagConstraints);
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("MACRO_LABEL_MN").charAt(0));
        this.jLabel2.setLabelFor(this.macroTextField);
        this.jLabel2.setText(resourceBundle.getString("MACRO_LABEL_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.codeModelPanel.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.codeModelPanel.add((Component)this.macroTextField, gridBagConstraints);
        this.codeModelLabel.setText(resourceBundle.getString("CODEMODEL_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.codeModelPanel.add((Component)this.codeModelLabel, gridBagConstraints);
        this.macroEditButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("MACRO_EDIT_BUTTON_MN").charAt(0));
        this.macroEditButton.setText(resourceBundle.getString("MACRO_EDIT_BUTTON_TXT"));
        this.macroEditButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParserConfigurationPanel.this.macroEditButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.codeModelPanel.add((Component)this.macroEditButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.codeModelPanel, gridBagConstraints);
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setText(resourceBundle.getString("SourceFoldersInstructions"));
        this.instructionsTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        this.instructionsTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ParserConfigurationPanel.class, (String)"INFO_AREA_AN"));
        this.instructionsTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParserConfigurationPanel.class, (String)"INFO_AREA_AD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.buttonGroup1.add(this.manualButton);
        this.manualButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("ParserManualConfiguration_MN").charAt(0));
        this.manualButton.setText(resourceBundle.getString("ParserManualConfiguration"));
        this.manualButton.setMargin(new Insets(0, 0, 0, 0));
        this.manualButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParserConfigurationPanel.this.manualButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.manualButton, gridBagConstraints);
        this.manualButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParserConfigurationPanel.class, (String)"ParserManualConfiguration_AD"));
        this.buttonGroup1.add(this.automaticButton);
        this.automaticButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("ParserAutomaticConfiguration_MN").charAt(0));
        this.automaticButton.setText(resourceBundle.getString("ParserAutomaticConfiguration"));
        this.automaticButton.setMargin(new Insets(0, 0, 0, 0));
        this.automaticButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParserConfigurationPanel.this.automaticButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.automaticButton, gridBagConstraints);
        this.automaticButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParserConfigurationPanel.class, (String)"ParserAutomaticConfiguration_AD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void automaticButtonActionPerformed(ActionEvent actionEvent) {
        this.togglePanel(false);
        this.update((DocumentEvent)null);
    }

    private void manualButtonActionPerformed(ActionEvent actionEvent) {
        this.togglePanel(true);
        this.update((DocumentEvent)null);
    }

    private void togglePanel(boolean bl) {
        for (Component component : this.codeModelPanel.getComponents()) {
            component.setEnabled(bl);
        }
        if (bl) {
            this.instructionsTextArea.setText(ParserConfigurationPanel.getString("SourceFoldersInstructions"));
        } else {
            this.instructionsTextArea.setText(ParserConfigurationPanel.getString("DiscoveryInstructions"));
        }
    }

    private void macroEditButtonActionPerformed(ActionEvent actionEvent) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.macroTextField.getText(), "; ");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        MacrosListPanel macrosListPanel = new MacrosListPanel((List<String>)arrayList);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.addOuterPanel(macrosListPanel), "Macro Definitions");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            Vector vector = macrosListPanel.getListData();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < vector.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(vector.elementAt(i));
            }
            this.macroTextField.setText(stringBuilder.toString());
        }
    }

    private void includeEditButtonActionPerformed(ActionEvent actionEvent) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.includeTextField.getText(), ";");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        IncludesListPanel includesListPanel = new IncludesListPanel((List<String>)arrayList);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.addOuterPanel(includesListPanel), ParserConfigurationPanel.getString("INCLUDE_DIRIRECTORIES_TXT"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            Vector vector = includesListPanel.getListData();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < vector.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(vector.elementAt(i));
            }
            this.includeTextField.setText(stringBuilder.toString());
        }
    }

    private JPanel addOuterPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("DIALOG_AD"));
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        jPanel2.setPreferredSize(new Dimension(500, 250));
        return jPanel2;
    }

    private static String getString(String string) {
        return NbBundle.getBundle(PanelProjectLocationVisual.class).getString(string);
    }

    private static class ConfigutationItem {
        private String ID;
        private String name;

        private ConfigutationItem(String string, String string2) {
            this.ID = string;
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        public String getID() {
            return this.ID;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MacrosListPanel
    extends ListEditorPanel<String> {
        public MacrosListPanel(List<String> list) {
            super(list);
            this.getDefaultButton().setVisible(false);
        }

        @Override
        public String addAction() {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(ParserConfigurationPanel.getString("ADD_DIALOG_LABEL_TXT"), ParserConfigurationPanel.getString("EDIT_DIALOG_TITLE_TXT"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (inputLine.getValue() != NotifyDescriptor.OK_OPTION) {
                return null;
            }
            String string = inputLine.getInputText();
            return string;
        }

        @Override
        public String getListLabelText() {
            return ParserConfigurationPanel.getString("MACROS_LIST_TXT");
        }

        @Override
        public char getListLabelMnemonic() {
            return ParserConfigurationPanel.getString("MACROS_LIST_MN").charAt(0);
        }

        @Override
        public String getAddButtonText() {
            return ParserConfigurationPanel.getString("ADD_BUTTON_TXT");
        }

        @Override
        public char getAddButtonMnemonics() {
            return ParserConfigurationPanel.getString("ADD_BUTTON_MN").charAt(0);
        }

        @Override
        public String getRenameButtonText() {
            return ParserConfigurationPanel.getString("EDIT_BUTTON_TXT");
        }

        @Override
        public char getRenameButtonMnemonics() {
            return ParserConfigurationPanel.getString("EDIT_BUTTON_MN").charAt(0);
        }

        @Override
        public String copyAction(String string) {
            return string;
        }

        @Override
        public void editAction(String string) {
            String string2 = string;
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(ParserConfigurationPanel.getString("EDIT_DIALOG_LABEL_TXT"), ParserConfigurationPanel.getString("EDIT_DIALOG_TITLE_TXT"));
            inputLine.setInputText(string2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (inputLine.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String string3 = inputLine.getInputText();
            Vector<String> vector = this.getListData();
            Object[] objectArray = this.getListData().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != string) continue;
                vector.remove(i);
                vector.add(i, string3);
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IncludesListPanel
    extends ListEditorPanel<String> {
        public IncludesListPanel(List<String> list) {
            super(list);
            this.getDefaultButton().setVisible(false);
        }

        @Override
        public String addAction() {
            FileChooser fileChooser;
            int n;
            String string = null;
            if (FileChooser.getCurrectChooserFile() != null) {
                string = FileChooser.getCurrectChooserFile().getPath();
            }
            if (string == null) {
                string = System.getProperty("user.home");
            }
            if ((n = (fileChooser = new FileChooser(ParserConfigurationPanel.getString("INCLUDE_DIR_DIALOG_TITLE_TXT"), ParserConfigurationPanel.getString("INCLUDE_DIR_DIALOG_BUTTON_TXT"), 1, null, string, true)).showOpenDialog((Component)this)) == 1) {
                return null;
            }
            String string2 = fileChooser.getSelectedFile().getPath();
            string2 = FilePathAdaptor.normalize(string2);
            return string2;
        }

        @Override
        public String getListLabelText() {
            return ParserConfigurationPanel.getString("DIR_LIST_TXT");
        }

        @Override
        public char getListLabelMnemonic() {
            return ParserConfigurationPanel.getString("DIR_LIST_MN").charAt(0);
        }

        @Override
        public String getAddButtonText() {
            return ParserConfigurationPanel.getString("ADD_BUTTON_TXT");
        }

        @Override
        public char getAddButtonMnemonics() {
            return ParserConfigurationPanel.getString("ADD_BUTTON_MN").charAt(0);
        }

        @Override
        public String getRenameButtonText() {
            return ParserConfigurationPanel.getString("EDIT_BUTTON_TXT");
        }

        @Override
        public char getRenameButtonMnemonics() {
            return ParserConfigurationPanel.getString("EDIT_BUTTON_MN").charAt(0);
        }

        @Override
        public String copyAction(String string) {
            return new String(string);
        }

        @Override
        public void editAction(String string) {
            String string2 = string;
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(ParserConfigurationPanel.getString("EDIT_DIALOG_LABEL_TXT"), ParserConfigurationPanel.getString("EDIT_DIALOG_TITLE_TXT"));
            inputLine.setInputText(string2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (inputLine.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String string3 = inputLine.getInputText();
            Vector<String> vector = this.getListData();
            Object[] objectArray = this.getListData().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != string) continue;
                vector.remove(i);
                vector.add(i, string3);
                break;
            }
        }
    }
}

