/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JOptionPane;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class DevelopmentHostCustomizer
extends JOptionPane
implements VetoableChangeListener {
    private DevelopmentHostConfiguration dhconf;
    private PropertyEnv propertyEnv;

    public DevelopmentHostCustomizer(DevelopmentHostConfiguration developmentHostConfiguration, PropertyEnv propertyEnv) {
        super(NbBundle.getMessage(DevelopmentHostCustomizer.class, (String)(developmentHostConfiguration.isConfigured() ? "ERR_NothingToDo" : "ERR_NeedToInitializeRemoteHost"), (Object)developmentHostConfiguration.getDisplayName(false)), developmentHostConfiguration.isConfigured() ? 1 : 3, -1, null, new Object[0]);
        this.dhconf = developmentHostConfiguration;
        this.propertyEnv = propertyEnv;
        if (!developmentHostConfiguration.isConfigured()) {
            propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            propertyEnv.addVetoableChangeListener((VetoableChangeListener)this);
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (!this.dhconf.isConfigured()) {
            ExecutionEnvironment executionEnvironment = this.dhconf.getExecutionEnvironment();
            final ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)executionEnvironment);
            assert (serverRecord != null);
            Frame frame = WindowManager.getDefault().getMainWindow();
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        serverRecord.validate(true);
                        CompilerSetManager compilerSetManager = CompilerSetManager.getDefault((ExecutionEnvironment)serverRecord.getExecutionEnvironment());
                        compilerSetManager.initialize(true, true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            String string = NbBundle.getMessage(this.getClass(), (String)"MSG_Configure_Host_Progress", (Object)serverRecord.getDisplayName());
            String string2 = NbBundle.getMessage(this.getClass(), (String)"DLG_TITLE_Configure_Host", (Object)serverRecord.getExecutionEnvironment().getHost());
            ModalMessageDlg.runLongTask((Frame)frame, (Runnable)runnable, null, null, (String)string2, (String)string);
            this.propertyEnv.removeVetoableChangeListener((VetoableChangeListener)this);
            this.propertyEnv.setState(PropertyEnv.STATE_VALID);
            if (!serverRecord.isOnline()) {
                System.err.println("");
            }
        }
    }
}

