/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.Image;
import java.util.Iterator;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotatedNode
extends AbstractNode
implements Runnable,
FileStatusListener {
    private Set<FileObject> files;
    private RequestProcessor.Task task;
    private volatile boolean iconChange;
    private volatile boolean nameChange;
    private boolean forceAnnotation;
    private FileStatusListener fsl = null;
    private FileSystem fs = null;

    protected AnnotatedNode(Children children) {
        super(children, null);
    }

    protected AnnotatedNode(Children children, Lookup lookup) {
        super(children, lookup);
    }

    protected final void setFiles(Set<FileObject> set) {
        if (this.fs != null && this.fsl != null) {
            this.fs.removeFileStatusListener(this.fsl);
        }
        this.files = set;
        if (set == null) {
            return;
        }
        if (set.size() == 0) {
            return;
        }
        FileObject fileObject = set.iterator().next();
        if (fileObject == null) {
            return;
        }
        try {
            this.fs = fileObject.getFileSystem();
            this.fsl = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)this.fs);
            this.fs.addFileStatusListener(this.fsl);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate((Throwable)fileStateInvalidException, "Cannot get " + fileObject + " filesystem, ignoring...");
            errorManager.notify(1, (Throwable)fileStateInvalidException);
        }
    }

    protected final Set<FileObject> getFiles() {
        return this.files;
    }

    protected void setForceAnnotation(boolean bl) {
        this.forceAnnotation = bl;
    }

    protected final Image annotateIcon(Image image, int n) {
        Image image2 = image;
        if (this.files != null && !this.files.isEmpty()) {
            Iterator<FileObject> iterator = this.files.iterator();
            try {
                FileObject fileObject = iterator.next();
                if (fileObject.isValid()) {
                    image2 = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
        }
        return image2;
    }

    protected final String annotateName(String string) {
        String string2 = string;
        if (this.files != null && !this.files.isEmpty()) {
            Iterator<FileObject> iterator = this.files.iterator();
            try {
                FileObject fileObject = iterator.next();
                if (fileObject.isValid()) {
                    string2 = fileObject.getFileSystem().getStatus().annotateName(string, this.files);
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
        }
        return string2;
    }

    public final void annotationChanged(FileStatusEvent fileStatusEvent) {
        if (this.files == null) {
            return;
        }
        if (this.task == null) {
            this.task = RequestProcessor.getDefault().create((Runnable)this);
        }
        boolean bl = false;
        if (this.forceAnnotation || !this.iconChange && fileStatusEvent.isIconChange() || !this.nameChange && fileStatusEvent.isNameChange()) {
            for (FileObject fileObject : this.files) {
                if (!fileStatusEvent.hasChanged(fileObject)) continue;
                this.iconChange |= fileStatusEvent.isIconChange();
                this.nameChange |= fileStatusEvent.isNameChange();
                bl = true;
            }
        }
        if (bl) {
            this.task.schedule(50);
        }
    }

    @Override
    public final void run() {
        if (this.forceAnnotation || this.iconChange) {
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.iconChange = false;
        }
        if (this.forceAnnotation || this.nameChange) {
            this.fireDisplayNameChange(null, null);
            this.nameChange = false;
        }
    }
}

