/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.packaging;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebianPackager
implements PackagerDescriptor {
    public static final String PACKAGER_NAME = "Debian";

    @Override
    public String getName() {
        return PACKAGER_NAME;
    }

    @Override
    public String getDisplayName() {
        return DebianPackager.getString(PACKAGER_NAME);
    }

    @Override
    public boolean hasInfoList() {
        return true;
    }

    @Override
    public List<PackagerInfoElement> getDefaultInfoList(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        String string = makeConfiguration.getDevelopmentHost().getBuildPlatform() == 1 ? "i386" : (makeConfiguration.getDevelopmentHost().getBuildPlatform() == 0 ? "sparc" : "i386");
        ArrayList<PackagerInfoElement> arrayList = new ArrayList<PackagerInfoElement>();
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "Package", packagingConfiguration.getOutputName(), true, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "Version", "1.0", true, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "Architecture", string, false, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "Maintainer", System.getProperty("user.name"), false, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "Description", "...", false, true));
        return arrayList;
    }

    @Override
    public List<String> getOptionalInfoList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Section");
        arrayList.add("Priority");
        arrayList.add("Architecture");
        arrayList.add("Depends");
        arrayList.add("Maintainer");
        arrayList.add("Description");
        return arrayList;
    }

    @Override
    public String getDefaultOptions() {
        return "";
    }

    @Override
    public String getDefaultTool() {
        return "dpkg-deb";
    }

    @Override
    public boolean isOutputAFolder() {
        return false;
    }

    @Override
    public String getOutputFileName(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return packagingConfiguration.getOutputName();
    }

    @Override
    public String getOutputFileSuffix() {
        return "deb";
    }

    @Override
    public String getTopDir(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return "/usr";
    }

    @Override
    public boolean supportsGroupAndOwner() {
        return true;
    }

    @Override
    public PackagerDescriptor.ShellSciptWriter getShellFileWriter() {
        return new ScriptWriter();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(DebianPackager.class, (String)string);
    }

    public static class ScriptWriter
    implements PackagerDescriptor.ShellSciptWriter {
        public void writeShellScript(BufferedWriter bufferedWriter, MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) throws IOException {
            this.writePackagingScriptBodyDebian(bufferedWriter, makeConfiguration);
        }

        private void writePackagingScriptBodyDebian(BufferedWriter bufferedWriter, MakeConfiguration makeConfiguration) throws IOException {
            String string;
            Object object;
            PackagingConfiguration packagingConfiguration = makeConfiguration.getPackagingConfiguration();
            List<PackagerFileElement> list = packagingConfiguration.getFiles().getValue();
            bufferedWriter.write("# Copy files and create directories and links\n");
            for (PackagerFileElement object22 : list) {
                bufferedWriter.write("cd \"${TOP}\"\n");
                if (object22.getType() == PackagerFileElement.FileType.FILE) {
                    object = IpeUtils.getDirName((String)makeConfiguration.getPackagingConfiguration().expandMacros(object22.getTo()));
                    if (object != null && ((String)object).length() >= 0) {
                        bufferedWriter.write("makeDirectory ${TMPDIR}/" + (String)object + "\n");
                    }
                    bufferedWriter.write("copyFileToTmpDir \"" + object22.getFrom() + "\" \"${TMPDIR}/" + object22.getTo() + "\" 0" + object22.getPermission() + "\n");
                } else if (object22.getType() == PackagerFileElement.FileType.DIRECTORY) {
                    bufferedWriter.write("makeDirectory  \"${TMPDIR}/" + object22.getTo() + "\"" + " 0" + object22.getPermission() + "\n");
                } else if (object22.getType() == PackagerFileElement.FileType.SOFTLINK) {
                    object = IpeUtils.getDirName((String)object22.getTo());
                    string = IpeUtils.getBaseName((String)object22.getTo());
                    if (object != null && ((String)object).length() >= 0) {
                        bufferedWriter.write("makeDirectory \"${TMPDIR}/" + (String)object + "\"" + "\n");
                    }
                    bufferedWriter.write("cd \"${TMPDIR}/" + (String)object + "\"" + "\n");
                    bufferedWriter.write("ln -s \"" + object22.getFrom() + "\"" + " " + "\"" + string + "\"" + "\n");
                } else if (object22.getType() != PackagerFileElement.FileType.UNKNOWN) assert (false);
                bufferedWriter.write("\n");
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("# Create control file\n");
            bufferedWriter.write("cd \"${TOP}\"\n");
            bufferedWriter.write("CONTROL_FILE=${TMPDIR}/DEBIAN/control\n");
            bufferedWriter.write("rm -f ${CONTROL_FILE}\n");
            bufferedWriter.write("mkdir -p ${TMPDIR}/DEBIAN\n");
            bufferedWriter.write("\n");
            bufferedWriter.write("cd \"${TOP}\"\n");
            List<PackagerInfoElement> list2 = packagingConfiguration.getHeaderSubList(DebianPackager.PACKAGER_NAME);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                object = (PackagerInfoElement)iterator.next();
                string = ((PackagerInfoElement)object).getValue();
                int n = 0;
                int n2 = string.indexOf("\\n");
                while (n2 >= 0) {
                    if (n == 0) {
                        bufferedWriter.write("echo '" + ((PackagerInfoElement)object).getName() + ": " + string.substring(n, n2) + "' >> ${CONTROL_FILE}\n");
                    } else {
                        bufferedWriter.write("echo '" + string.substring(n, n2) + "' >> ${CONTROL_FILE}\n");
                    }
                    n = n2 + 2;
                    n2 = string.indexOf("\\n", n);
                }
                if (n >= string.length()) continue;
                if (n == 0) {
                    bufferedWriter.write("echo '" + ((PackagerInfoElement)object).getName() + ": " + string.substring(n) + "' >> ${CONTROL_FILE}\n");
                    continue;
                }
                bufferedWriter.write("echo '" + string.substring(n) + "' >> ${CONTROL_FILE}\n");
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("# Create Debian Package\n");
            bufferedWriter.write("cd \"${TOP}\"\n");
            bufferedWriter.write("cd \"${TMPDIR}/..\"\n");
            bufferedWriter.write(packagingConfiguration.getToolValue() + " " + packagingConfiguration.getOptionsValue() + " --build ${TMPDIRNAME}\n");
            bufferedWriter.write("checkReturnCode\n");
            bufferedWriter.write("cd \"${TOP}\"\n");
            bufferedWriter.write("mkdir -p  " + IpeUtils.getDirName((String)packagingConfiguration.getOutputValue()) + "\n");
            bufferedWriter.write("mv ${TMPDIR}.deb " + packagingConfiguration.getOutputValue() + "\n");
            bufferedWriter.write("checkReturnCode\n");
            bufferedWriter.write("echo Debian: " + packagingConfiguration.getOutputValue() + "\n");
            bufferedWriter.write("\n");
        }
    }
}

