/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.api.utils.CppUtils;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.OptionsConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.makeproject.configurations.ui.LibrariesNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.VectorNodeProp;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkerConfiguration
implements AllOptionsProvider {
    private MakeConfiguration makeConfiguration;
    private StringConfiguration output;
    private VectorConfiguration<String> additionalLibs;
    private VectorConfiguration<String> dynamicSearch;
    private BooleanConfiguration stripOption;
    private BooleanConfiguration picOption;
    private BooleanConfiguration norunpathOption;
    private BooleanConfiguration nameassignOption;
    private OptionsConfiguration commandLineConfiguration;
    private OptionsConfiguration additionalDependencies;
    private LibrariesConfiguration librariesConfiguration;
    private StringConfiguration tool;

    public LinkerConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.output = new StringConfiguration(null, "");
        this.additionalLibs = new VectorConfiguration(null);
        this.dynamicSearch = new VectorConfiguration(null);
        this.stripOption = new LinkerStripConfiguration(null, false);
        this.picOption = new BooleanConfiguration(null, true, "", "-Kpic");
        this.norunpathOption = new BooleanConfiguration(null, true, "", "-norunpath");
        this.nameassignOption = new BooleanConfiguration(null, true);
        this.commandLineConfiguration = new OptionsConfiguration();
        this.additionalDependencies = new OptionsConfiguration();
        this.additionalDependencies.setPreDefined(this.getAdditionalDependenciesPredefined());
        this.librariesConfiguration = new LibrariesConfiguration();
        this.tool = new StringConfiguration(null, "");
    }

    private String getAdditionalDependenciesPredefined() {
        String string = "${BUILD_SUBPROJECTS} ${OBJECTFILES}";
        return string;
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public void setOutput(StringConfiguration stringConfiguration) {
        this.output = stringConfiguration;
    }

    public StringConfiguration getOutput() {
        return this.output;
    }

    public VectorConfiguration<String> getAdditionalLibs() {
        return this.additionalLibs;
    }

    public void setAdditionalLibs(VectorConfiguration<String> vectorConfiguration) {
        this.additionalLibs = vectorConfiguration;
    }

    public VectorConfiguration<String> getDynamicSearch() {
        return this.dynamicSearch;
    }

    public void setDynamicSearch(VectorConfiguration<String> vectorConfiguration) {
        this.dynamicSearch = vectorConfiguration;
    }

    public void setStripOption(BooleanConfiguration booleanConfiguration) {
        this.stripOption = booleanConfiguration;
    }

    public BooleanConfiguration getStripOption() {
        return this.stripOption;
    }

    public void setPICOption(BooleanConfiguration booleanConfiguration) {
        this.picOption = booleanConfiguration;
    }

    public BooleanConfiguration getPICOption() {
        return this.picOption;
    }

    public void setNorunpathOption(BooleanConfiguration booleanConfiguration) {
        this.norunpathOption = booleanConfiguration;
    }

    public BooleanConfiguration getNorunpathOption() {
        return this.norunpathOption;
    }

    public void setNameassignOption(BooleanConfiguration booleanConfiguration) {
        this.nameassignOption = booleanConfiguration;
    }

    public BooleanConfiguration getNameassignOption() {
        return this.nameassignOption;
    }

    public OptionsConfiguration getCommandLineConfiguration() {
        return this.commandLineConfiguration;
    }

    public void setCommandLineConfiguration(OptionsConfiguration optionsConfiguration) {
        this.commandLineConfiguration = optionsConfiguration;
    }

    public OptionsConfiguration getAdditionalDependencies() {
        return this.additionalDependencies;
    }

    public void setAdditionalDependencies(OptionsConfiguration optionsConfiguration) {
        this.additionalDependencies = optionsConfiguration;
    }

    public LibrariesConfiguration getLibrariesConfiguration() {
        return this.librariesConfiguration;
    }

    public void setLibrariesConfiguration(LibrariesConfiguration librariesConfiguration) {
        this.librariesConfiguration = librariesConfiguration;
    }

    public void setTool(StringConfiguration stringConfiguration) {
        this.tool = stringConfiguration;
    }

    public StringConfiguration getTool() {
        return this.tool;
    }

    public void assign(LinkerConfiguration linkerConfiguration) {
        this.getOutput().assign(linkerConfiguration.getOutput());
        this.getAdditionalLibs().assign(linkerConfiguration.getAdditionalLibs());
        this.getDynamicSearch().assign(linkerConfiguration.getDynamicSearch());
        this.getCommandLineConfiguration().assign(linkerConfiguration.getCommandLineConfiguration());
        this.getAdditionalDependencies().assign(linkerConfiguration.getAdditionalDependencies());
        this.getStripOption().assign(linkerConfiguration.getStripOption());
        this.getPICOption().assign(linkerConfiguration.getPICOption());
        this.getNorunpathOption().assign(linkerConfiguration.getNorunpathOption());
        this.getNameassignOption().assign(linkerConfiguration.getNameassignOption());
        this.getLibrariesConfiguration().assign(linkerConfiguration.getLibrariesConfiguration());
        this.getTool().assign(linkerConfiguration.getTool());
    }

    public LinkerConfiguration clone() {
        LinkerConfiguration linkerConfiguration = new LinkerConfiguration(this.getMakeConfiguration());
        linkerConfiguration.setOutput(this.getOutput().clone());
        linkerConfiguration.setAdditionalLibs((VectorConfiguration<String>)this.getAdditionalLibs().clone());
        linkerConfiguration.setDynamicSearch((VectorConfiguration<String>)this.getDynamicSearch().clone());
        linkerConfiguration.setCommandLineConfiguration(this.getCommandLineConfiguration().clone());
        linkerConfiguration.setAdditionalDependencies(this.getAdditionalDependencies().clone());
        linkerConfiguration.setStripOption(this.getStripOption().clone());
        linkerConfiguration.setPICOption(this.getPICOption().clone());
        linkerConfiguration.setNorunpathOption(this.getNorunpathOption().clone());
        linkerConfiguration.setNameassignOption(this.getNameassignOption().clone());
        linkerConfiguration.setLibrariesConfiguration(this.getLibrariesConfiguration().clone());
        linkerConfiguration.setTool(this.getTool().clone());
        return linkerConfiguration;
    }

    public String getOptions() {
        String string = this.getCommandLineConfiguration().getValue() + " ";
        string = string + this.getBasicOptions() + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getBasicOptions() {
        String string = "";
        CompilerSet compilerSet = this.getMakeConfiguration().getCompilerSet().getCompilerSet();
        if (this.getMakeConfiguration().getConfigurationType().getValue() == 2) {
            String string2 = this.getOutputValue();
            int n = string2.lastIndexOf(47);
            if (n >= 0 && string2.length() > 1) {
                string2 = string2.substring(n + 1);
            }
            if (compilerSet != null) {
                string = string + compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker().getDynamicLibraryBasicFlag();
                if (compilerSet.isGnuCompiler() && this.getMakeConfiguration().getDevelopmentHost().getBuildPlatform() == 4) {
                    string = string + string2 + " ";
                }
            }
        }
        string = compilerSet != null ? string + compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker().getOutputFileFlag() + this.getOutputValue() + " " : string + "-o " + this.getOutputValue() + " ";
        string = string + this.getStripOption().getOption() + " ";
        if (this.getMakeConfiguration().getConfigurationType().getValue() == 2 && compilerSet != null) {
            if (this.getPICOption().getValue()) {
                string = string + this.getPICOption(compilerSet);
            }
            if (compilerSet.isSunCompiler()) {
                string = string + this.getNorunpathOption().getOption() + " ";
                string = string + this.getNameassignOption(this.getNameassignOption().getValue()) + " ";
            }
        }
        return CppUtils.reformatWhitespaces((String)string);
    }

    public String getPICOption(CompilerSet compilerSet) {
        ToolchainManager.LinkerDescriptor linkerDescriptor = compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker();
        if (linkerDescriptor != null) {
            return linkerDescriptor.getPICFlag();
        }
        return null;
    }

    public String getLibraryItems() {
        ToolchainManager.LinkerDescriptor linkerDescriptor;
        CompilerSet compilerSet = this.getMakeConfiguration().getCompilerSet().getCompilerSet();
        ToolchainManager.LinkerDescriptor linkerDescriptor2 = linkerDescriptor = compilerSet == null ? null : compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker();
        if (linkerDescriptor == null) {
            return "";
        }
        String string = "";
        CCCCompilerConfiguration.OptionToString optionToString = new CCCCompilerConfiguration.OptionToString(compilerSet, linkerDescriptor.getLibrarySearchFlag());
        string = string + this.getAdditionalLibs().toString(optionToString) + " ";
        CCCCompilerConfiguration.OptionToString optionToString2 = new CCCCompilerConfiguration.OptionToString(compilerSet, linkerDescriptor.getDynamicLibrarySearchFlag());
        string = string + this.getDynamicSearch().toString(optionToString2) + " ";
        LibraryToString libraryToString = new LibraryToString(this.getMakeConfiguration());
        string = string + this.getLibrariesConfiguration().toString(libraryToString) + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    @Override
    public String getAllOptions(BasicCompiler basicCompiler) {
        String string = this.getBasicOptions() + " ";
        string = string + this.getLibraryItems() + " ";
        return CppUtils.reformatWhitespaces((String)string);
    }

    public Sheet getGeneralSheet(Project project, MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, boolean bl) {
        Sheet.Set set;
        Sheet.Set set2;
        Object object;
        Sheet sheet = new Sheet();
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        String string = null;
        String[] stringArray = null;
        if (compilerSet != null) {
            if (makeConfiguration.hasCPPFiles(makeConfigurationDescriptor)) {
                object = (BasicCompiler)compilerSet.getTool(1);
                string = object.getName();
            } else {
                object = (BasicCompiler)compilerSet.getTool(0);
                string = object.getName();
            }
        }
        object = new Sheet.Set();
        object.setName("General");
        object.setDisplayName(LinkerConfiguration.getString("GeneralTxt"));
        object.setShortDescription(LinkerConfiguration.getString("GeneralHint"));
        if (!bl) {
            object.put((Node.Property)new OutputNodeProp(this.getOutput(), this.getOutputDefault(), "Output", LinkerConfiguration.getString("OutputTxt"), LinkerConfiguration.getString("OutputHint")));
            object.put((Node.Property)new VectorNodeProp(this.getAdditionalLibs(), null, this.getMakeConfiguration().getBaseDir(), new String[]{"AdditionalLibraryDirectories", LinkerConfiguration.getString("AdditionalLibraryDirectoriesTxt"), LinkerConfiguration.getString("AdditionalLibraryDirectoriesHint")}, true, new HelpCtx("AddtlLibraryDirectories")));
        }
        object.put((Node.Property)new VectorNodeProp(this.getDynamicSearch(), null, this.getMakeConfiguration().getBaseDir(), new String[]{"RuntimeSearchDirectories", LinkerConfiguration.getString("RuntimeSearchDirectoriesTxt"), LinkerConfiguration.getString("RuntimeSearchDirectoriesHint")}, false, new HelpCtx("RuntimeSearchDirectories")));
        sheet.put(object);
        if (!bl) {
            set2 = new Sheet.Set();
            set2.setName("Options");
            set2.setDisplayName(LinkerConfiguration.getString("OptionsTxt"));
            set2.setShortDescription(LinkerConfiguration.getString("OptionsHint"));
            set2.put((Node.Property)new BooleanNodeProp(this.getStripOption(), true, "StripSymbols", LinkerConfiguration.getString("StripSymbolsTxt"), LinkerConfiguration.getString("StripSymbolsHint")));
            if (makeConfiguration.getConfigurationType().getValue() == 2) {
                set2.put((Node.Property)new BooleanNodeProp(this.getPICOption(), true, "PositionIndependantCode", LinkerConfiguration.getString("PositionIndependantCodeTxt"), LinkerConfiguration.getString("PositionIndependantCodeHint")));
                if (compilerSet != null && compilerSet.isSunCompiler()) {
                    set2.put((Node.Property)new BooleanNodeProp(this.getNorunpathOption(), true, "NoRunPath", LinkerConfiguration.getString("NoRunPathTxt"), LinkerConfiguration.getString("NoRunPathHint")));
                    set2.put((Node.Property)new BooleanNodeProp(this.getNameassignOption(), true, "AssignName", LinkerConfiguration.getString("AssignNameTxt"), LinkerConfiguration.getString("AssignNameHint")));
                }
            }
            sheet.put(set2);
            set = new Sheet.Set();
            stringArray = new String[]{LinkerConfiguration.getString("AdditionalDependenciesTxt1"), LinkerConfiguration.getString("AdditionalDependenciesHint"), LinkerConfiguration.getString("AdditionalDependenciesTxt2"), LinkerConfiguration.getString("InheritedValuesTxt")};
            set.setName("Input");
            set.setDisplayName(LinkerConfiguration.getString("InputTxt"));
            set.setShortDescription(LinkerConfiguration.getString("InputHint"));
            set.put((Node.Property)new OptionsNodeProp(this.getAdditionalDependencies(), null, new AdditionalDependenciesOptions(), null, ",", stringArray));
            sheet.put(set);
            Sheet.Set set3 = new Sheet.Set();
            set3.setName("Tool");
            set3.setDisplayName(LinkerConfiguration.getString("ToolTxt1"));
            set3.setShortDescription(LinkerConfiguration.getString("ToolHint1"));
            if (string != null) {
                set3.put((Node.Property)new StringNodeProp(this.getTool(), string, "Tool", LinkerConfiguration.getString("ToolTxt1"), LinkerConfiguration.getString("ToolHint1")));
            }
            sheet.put(set3);
        }
        stringArray = new String[]{LinkerConfiguration.getString("LibrariesTxt1"), LinkerConfiguration.getString("LibrariesHint"), LinkerConfiguration.getString("LibrariesTxt2"), LinkerConfiguration.getString("AllOptionsTxt2")};
        set2 = new Sheet.Set();
        set2.setName("Libraries");
        set2.setDisplayName(LinkerConfiguration.getString("LibrariesTxt1"));
        set2.setShortDescription(LinkerConfiguration.getString("LibrariesHint"));
        set2.put((Node.Property)new LibrariesNodeProp(this.getLibrariesConfiguration(), project, makeConfiguration, this.getMakeConfiguration().getBaseDir(), stringArray));
        sheet.put(set2);
        if (!bl) {
            stringArray = new String[]{LinkerConfiguration.getString("AdditionalOptionsTxt1"), LinkerConfiguration.getString("AdditionalOptionsHint"), LinkerConfiguration.getString("AdditionalOptionsTxt2"), LinkerConfiguration.getString("AllOptionsTxt")};
            set = new Sheet.Set();
            set.setName("CommandLine");
            set.setDisplayName(LinkerConfiguration.getString("CommandLineTxt"));
            set.setShortDescription(LinkerConfiguration.getString("CommandLineHint"));
            set.put((Node.Property)new OptionsNodeProp(this.getCommandLineConfiguration(), null, this, null, null, stringArray));
            sheet.put(set);
        }
        return sheet;
    }

    private String getNameassignOption(boolean bl) {
        if (bl) {
            return "-h " + IpeUtils.getBaseName((String)this.getOutputValue());
        }
        return "";
    }

    public String getOutputValue() {
        if (this.getOutput().getModified()) {
            return this.getOutput().getValue();
        }
        return this.getOutputDefault();
    }

    private String getOutputDefault() {
        String string = IpeUtils.getBaseName((String)this.getMakeConfiguration().getBaseDir());
        switch (this.getMakeConfiguration().getConfigurationType().getValue()) {
            case 1: {
                string = string.toLowerCase();
                break;
            }
            case 2: {
                string = Platforms.getPlatform(this.getMakeConfiguration().getDevelopmentHost().getBuildPlatform()).getLibraryName(string);
            }
        }
        string = ConfigurationSupport.makeNameLegal(string);
        return "${CND_DISTDIR}/${CND_CONF}/${CND_PLATFORM}/" + string;
    }

    public String getOutputDefault27() {
        String string = IpeUtils.getBaseName((String)this.getMakeConfiguration().getBaseDir());
        if (this.getMakeConfiguration().getConfigurationType().getValue() == 1) {
            string = string.toLowerCase();
        } else if (this.getMakeConfiguration().getConfigurationType().getValue() == 2) {
            string = "lib" + string + ".so";
        }
        return "dist/" + this.getMakeConfiguration().getName() + "/" + string;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(LinkerConfiguration.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LibraryToString
    implements VectorConfiguration.ToString<LibraryItem> {
        private final MakeConfiguration conf;

        public LibraryToString(MakeConfiguration makeConfiguration) {
            this.conf = makeConfiguration;
        }

        @Override
        public String toString(LibraryItem libraryItem) {
            return libraryItem.getOption(this.conf);
        }
    }

    private class LinkerStripConfiguration
    extends BooleanConfiguration {
        public LinkerStripConfiguration(BooleanConfiguration booleanConfiguration, boolean bl) {
            super(booleanConfiguration, bl);
        }

        public String getOption() {
            if (this.getValue()) {
                String string = LinkerConfiguration.this.getMakeConfiguration().getDevelopmentHost().getBuildPlatform() == 4 ? "-Wl,-S " : "-s ";
                return string;
            }
            return "";
        }

        public void assign(BooleanConfiguration booleanConfiguration) {
            this.setDirty(this.getDirty() || this.getValue() != booleanConfiguration.getValue());
            this.setValue(booleanConfiguration.getValue());
            this.setModified(booleanConfiguration.getValue());
        }

        public LinkerStripConfiguration clone() {
            LinkerStripConfiguration linkerStripConfiguration = new LinkerStripConfiguration(this.getMaster(), this.getDefault());
            linkerStripConfiguration.setValue(this.getValue());
            linkerStripConfiguration.setModified(this.getModified());
            return linkerStripConfiguration;
        }
    }

    private static class OutputNodeProp
    extends StringNodeProp {
        public OutputNodeProp(StringConfiguration stringConfiguration, String string, String string2, String string3, String string4) {
            super(stringConfiguration, string, string2, string3, string4);
        }

        public void setValue(String string) {
            if (IpeUtils.hasMakeSpecialCharacters((String)string)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)LinkerConfiguration.getString("SPECIAL_CHARATERS_ERROR"), 0));
                return;
            }
            super.setValue(string);
        }
    }

    class AdditionalDependenciesOptions
    implements AllOptionsProvider {
        AdditionalDependenciesOptions() {
        }

        public String getAllOptions(BasicCompiler basicCompiler) {
            String string = "";
            string = string + LinkerConfiguration.this.additionalDependencies.getPreDefined();
            return CppUtils.reformatWhitespaces((String)string);
        }
    }
}

