/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.compilers;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.makeproject.api.compilers.CCCCompiler;
import org.netbeans.modules.cnd.makeproject.api.compilers.PersistentList;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GNUCCCCompiler
extends CCCCompiler {
    protected PersistentList<String> systemIncludeDirectoriesList = null;
    protected PersistentList<String> systemPreprocessorSymbolsList = null;

    public GNUCCCCompiler(ExecutionEnvironment executionEnvironment, CompilerSet.CompilerFlavor compilerFlavor, int n, String string, String string2, String string3) {
        super(executionEnvironment, compilerFlavor, n, string, string2, string3);
    }

    @Override
    public boolean setSystemIncludeDirectories(List<String> list) {
        assert (list != null);
        if (((Object)list).equals(this.systemIncludeDirectoriesList)) {
            return false;
        }
        this.systemIncludeDirectoriesList = new PersistentList<String>(list);
        this.normalizePaths(this.systemIncludeDirectoriesList);
        this.saveSystemIncludesAndDefines();
        return true;
    }

    @Override
    public boolean setSystemPreprocessorSymbols(List<String> list) {
        assert (list != null);
        if (((Object)list).equals(this.systemPreprocessorSymbolsList)) {
            return false;
        }
        this.systemPreprocessorSymbolsList = new PersistentList<String>(list);
        this.saveSystemIncludesAndDefines();
        return true;
    }

    @Override
    public List<String> getSystemPreprocessorSymbols() {
        if (this.systemPreprocessorSymbolsList != null) {
            return this.systemPreprocessorSymbolsList;
        }
        this.getSystemIncludesAndDefines();
        return this.systemPreprocessorSymbolsList;
    }

    @Override
    public List<String> getSystemIncludeDirectories() {
        if (this.systemIncludeDirectoriesList != null) {
            return this.systemIncludeDirectoriesList;
        }
        this.getSystemIncludesAndDefines();
        return this.systemIncludeDirectoriesList;
    }

    @Override
    public void saveSystemIncludesAndDefines() {
        if (this.systemIncludeDirectoriesList != null) {
            this.systemIncludeDirectoriesList.saveList(this.getUniqueID() + "systemIncludeDirectoriesList");
        }
        if (this.systemPreprocessorSymbolsList != null) {
            this.systemPreprocessorSymbolsList.saveList(this.getUniqueID() + "systemPreprocessorSymbolsList");
        }
    }

    private void restoreSystemIncludesAndDefines() {
        this.systemIncludeDirectoriesList = PersistentList.restoreList(this.getUniqueID() + "systemIncludeDirectoriesList");
        this.systemPreprocessorSymbolsList = PersistentList.restoreList(this.getUniqueID() + "systemPreprocessorSymbolsList");
    }

    private void getSystemIncludesAndDefines() {
        this.restoreSystemIncludesAndDefines();
        if (this.systemIncludeDirectoriesList == null || this.systemPreprocessorSymbolsList == null) {
            this.getFreshSystemIncludesAndDefines();
        }
    }

    protected String getCompilerStderrCommand() {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null) {
            return " " + compilerDescriptor.getIncludeFlags();
        }
        return "";
    }

    protected String getCompilerStdoutCommand() {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null) {
            return " " + compilerDescriptor.getMacroFlags();
        }
        return "";
    }

    private void getFreshSystemIncludesAndDefines() {
        this.systemIncludeDirectoriesList = new PersistentList();
        this.systemPreprocessorSymbolsList = new PersistentList();
        try {
            this.getSystemIncludesAndDefines(this.getCompilerStderrCommand(), false);
            this.getSystemIncludesAndDefines(this.getCompilerStdoutCommand(), true);
            if (!this.containsMacro(this.systemPreprocessorSymbolsList, "__STDC__")) {
                this.systemPreprocessorSymbolsList.add("__STDC__=1");
            }
            this.saveSystemIncludesAndDefines();
        }
        catch (IOException iOException) {
            System.err.println("IOException " + iOException);
            String string = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CANTFINDCOMPILER", (Object)this.getPath());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
        }
    }

    @Override
    public void resetSystemIncludesAndDefines() {
        this.getFreshSystemIncludesAndDefines();
    }

    private boolean startsWithPath(String string) {
        if ((string = string.trim()).startsWith("/")) {
            return true;
        }
        return string.length() > 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':';
    }

    protected String cutIncludePrefix(String string) {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null && compilerDescriptor.getRemoveIncludeOutputPrefix() != null) {
            String string2 = compilerDescriptor.getRemoveIncludeOutputPrefix();
            if (string.toLowerCase().startsWith(this.getIncludeFilePathPrefix().toLowerCase())) {
                string = string.substring(this.getIncludeFilePathPrefix().length());
            } else if (string.toLowerCase().startsWith(string2)) {
                string = string.substring(string2.length());
            }
        }
        return string;
    }

    @Override
    protected void parseCompilerOutput(BufferedReader bufferedReader) {
        try {
            String string;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if ((string = string.trim()).contains("#include <...>")) {
                    bl = true;
                    continue;
                }
                if (bl) {
                    if (string.startsWith("End of search") || !this.startsWithPath(string)) {
                        bl = false;
                        continue;
                    }
                    if (string.length() > 2 && string.charAt(1) == ':') {
                        this.systemIncludeDirectoriesList.addUnique(this.normalizePath(string));
                        continue;
                    }
                    if ((string = this.cutIncludePrefix(string)).endsWith(" (framework directory)")) {
                        string = string.substring(0, string.lastIndexOf(40)).trim();
                    }
                    this.systemIncludeDirectoriesList.addUnique(this.applyPathPrefix(string));
                    if (this.getDescriptor().getRemoveIncludePathPrefix() == null || !string.startsWith("/usr/lib")) continue;
                    this.systemIncludeDirectoriesList.addUnique(this.applyPathPrefix(string.substring(4)));
                    continue;
                }
                this.parseUserMacros(string, this.systemPreprocessorSymbolsList);
                if (!string.startsWith("#define ") || (n = string.indexOf(32, 8)) <= 0) continue;
                String string2 = string.substring(8, n) + "=" + string.substring(n + 1);
                this.systemPreprocessorSymbolsList.add(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(16, (Throwable)iOException);
        }
    }

    private void dumpLists() {
        int n;
        System.out.println("==================================" + this.getDisplayName());
        for (n = 0; n < this.systemIncludeDirectoriesList.size(); ++n) {
            System.out.println("-I" + (String)this.systemIncludeDirectoriesList.get(n));
        }
        for (n = 0; n < this.systemPreprocessorSymbolsList.size(); ++n) {
            System.out.println("-D" + (String)this.systemPreprocessorSymbolsList.get(n));
        }
    }
}

