/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.actions.BuildToolsAction;
import org.netbeans.modules.cnd.actions.ShellRunAction;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.remote.CommandProvider;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.RunDialogPanel;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomToolConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platform;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.ui.utils.ConfSelectorPanel;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.ui.options.LocalToolsPanelModel;
import org.netbeans.modules.cnd.ui.options.ToolsPanel;
import org.netbeans.modules.cnd.ui.options.ToolsPanelModel;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeActionProvider
implements ActionProvider {
    public static final String COMMAND_BATCH_BUILD = "batch_build";
    public static final String COMMAND_BUILD_PACKAGE = "build_packages";
    public static final String COMMAND_DEBUG_LOAD_ONLY = "debug.load.only";
    public static final String COMMAND_CUSTOM_ACTION = "custom.action";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.stepinto", "debug.load.only", "debug.single", "batch_build", "build_packages", "delete", "copy", "move", "rename", "custom.action"};
    MakeProject project;
    MakeConfigurationDescriptor projectDescriptor = null;
    Map<String, String[]> commands = new HashMap<String, String[]>();
    Map<String, String[]> commandsNoBuild;
    private boolean lastValidation = false;
    public static final boolean useRsync = Boolean.getBoolean("cnd.remote.useRsync");
    public static final String REMOTE_BASE_PATH = "~/NetBeansProjects/remote";
    private static Map<String, Boolean> fileExistenceCache = new HashMap<String, Boolean>();
    private static Map<String, Boolean> validExecutablesCache = new HashMap<String, Boolean>();

    public MakeActionProvider(MakeProject makeProject) {
        this.commands.put("build", new String[]{"save", "build"});
        this.commands.put(COMMAND_BUILD_PACKAGE, new String[]{"save", "build", "build-package"});
        this.commands.put("clean", new String[]{"save", "clean"});
        this.commands.put("rebuild", new String[]{"save", "clean", "build"});
        this.commands.put("run", new String[]{"save", "build", "run"});
        this.commands.put("debug", new String[]{"save", "build", "debug"});
        this.commands.put("debug.stepinto", new String[]{"save", "build", "debug-stepinto"});
        this.commands.put(COMMAND_DEBUG_LOAD_ONLY, new String[]{"save", "build", "debug-load-only"});
        this.commands.put("run.single", new String[]{"run-single"});
        this.commands.put("debug.single", new String[]{"debug-single"});
        this.commands.put("compile.single", new String[]{"save", "compile-single"});
        this.commands.put(COMMAND_CUSTOM_ACTION, new String[]{"save", "build", "custom-action"});
        this.commandsNoBuild = new HashMap<String, String[]>();
        this.commandsNoBuild.put("build", new String[]{"save", "build-package"});
        this.commandsNoBuild.put(COMMAND_BUILD_PACKAGE, new String[]{"save", "build"});
        this.commandsNoBuild.put("clean", new String[]{"save", "clean"});
        this.commandsNoBuild.put("rebuild", new String[]{"save", "clean", "build"});
        this.commandsNoBuild.put("run", new String[]{"run"});
        this.commandsNoBuild.put("debug", new String[]{"debug"});
        this.commandsNoBuild.put("debug.stepinto", new String[]{"debug-stepinto"});
        this.commandsNoBuild.put(COMMAND_DEBUG_LOAD_ONLY, new String[]{"debug-load-only"});
        this.commandsNoBuild.put(COMMAND_CUSTOM_ACTION, new String[]{"save", "custom-action"});
        this.project = makeProject;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject("build.xml");
    }

    private boolean isProjectDescriptorLoaded() {
        if (this.projectDescriptor == null) {
            ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            return configurationDescriptorProvider.gotDescriptor();
        }
        return true;
    }

    private MakeConfigurationDescriptor getProjectDescriptor() {
        if (this.projectDescriptor == null) {
            ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            this.projectDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
        }
        return this.projectDescriptor;
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public void invokeAction(final String string, final Lookup lookup) throws IllegalArgumentException {
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(string)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(string)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        if ("run.single".equals(string)) {
            Node node = (Node)lookup.lookup(Node.class);
            if (node != null) {
                ShellRunAction.performAction((Node)node);
            }
            return;
        }
        ProjectInformation projectInformation = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        final String string2 = projectInformation.getDisplayName();
        final MakeConfigurationDescriptor makeConfigurationDescriptor = this.getProjectDescriptor();
        final MakeConfiguration makeConfiguration = makeConfigurationDescriptor.getActiveConfiguration();
        if (makeConfiguration == null) {
            return;
        }
        CancellableTask cancellableTask = new CancellableTask(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected void runImpl() {
                ArrayList<ProjectActionEvent> arrayList = new ArrayList<ProjectActionEvent>();
                if (string.equals(MakeActionProvider.COMMAND_BATCH_BUILD)) {
                    BatchConfigurationSelector batchConfigurationSelector = new BatchConfigurationSelector(makeConfigurationDescriptor.getConfs().getConfs());
                    String string3 = batchConfigurationSelector.getCommand();
                    Configuration[] configurationArray = batchConfigurationSelector.getSelectedConfs();
                    if (string3 == null || configurationArray == null) return;
                    for (int i = 0; i < configurationArray.length; ++i) {
                        MakeActionProvider.this.addAction(arrayList, string2, makeConfigurationDescriptor, (MakeConfiguration)configurationArray[i], string3, lookup, this.cancelled);
                    }
                } else {
                    MakeActionProvider.this.addAction(arrayList, string2, makeConfigurationDescriptor, makeConfiguration, string, lookup, this.cancelled);
                }
                if (arrayList.size() <= 0 || this.cancelled.get()) return;
                ProjectActionSupport.getInstance().fireActionPerformed(arrayList.toArray(new ProjectActionEvent[arrayList.size()]));
            }
        };
        MakeActionProvider.runActionWorker(makeConfiguration.getDevelopmentHost().getExecutionEnvironment(), cancellableTask);
    }

    private static void runActionWorker(ExecutionEnvironment executionEnvironment, CancellableTask cancellableTask) {
        if (executionEnvironment.isLocal()) {
            cancellableTask.run();
        } else {
            ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)executionEnvironment);
            assert (serverRecord != null);
            MakeActionProvider.invokeRemoteHostAction(serverRecord, cancellableTask);
        }
    }

    public void invokeCustomAction(final String string, final MakeConfigurationDescriptor makeConfigurationDescriptor, final MakeConfiguration makeConfiguration, final ProjectActionHandler projectActionHandler) {
        CancellableTask cancellableTask = new CancellableTask(){

            protected void runImpl() {
                ArrayList<ProjectActionEvent> arrayList = new ArrayList<ProjectActionEvent>();
                MakeActionProvider.this.addAction(arrayList, string, makeConfigurationDescriptor, makeConfiguration, MakeActionProvider.COMMAND_CUSTOM_ACTION, null, this.cancelled);
                ProjectActionSupport.getInstance().fireActionPerformed(arrayList.toArray(new ProjectActionEvent[arrayList.size()]), projectActionHandler);
            }
        };
        MakeActionProvider.runActionWorker(makeConfiguration.getDevelopmentHost().getExecutionEnvironment(), cancellableTask);
    }

    private static void invokeRemoteHostAction(final ServerRecord serverRecord, final CancellableTask cancellableTask) {
        Object object;
        CancellableTask cancellableTask2;
        if (!serverRecord.isDeleted() && serverRecord.isOnline()) {
            cancellableTask2 = cancellableTask;
        } else {
            int n = 1;
            if (serverRecord.isDeleted()) {
                object = MessageFormat.format(MakeActionProvider.getString("ERR_RequestingDeletedConnection"), serverRecord.getDisplayName());
                n = JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), object, MakeActionProvider.getString("DLG_TITLE_DeletedConnection"), 0);
                if (n == 0) {
                    ServerList.addServer((ExecutionEnvironment)serverRecord.getExecutionEnvironment(), (String)serverRecord.getDisplayName(), (RemoteSyncFactory)serverRecord.getSyncFactory(), (boolean)false, (boolean)true);
                }
            } else if (!serverRecord.isOnline()) {
                object = MessageFormat.format(MakeActionProvider.getString("ERR_NeedToConnectToRemoteHost"), serverRecord.getDisplayName());
                n = JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), object, MakeActionProvider.getString("DLG_TITLE_Connect"), 0);
            }
            if (n != 0) {
                return;
            }
            cancellableTask2 = new CancellableTask(){

                public boolean cancel() {
                    return cancellableTask.cancel();
                }

                public void runImpl() {
                    try {
                        if (!ConnectionManager.getInstance().isConnectedTo(serverRecord.getExecutionEnvironment())) {
                            ConnectionManager.getInstance().connectTo(serverRecord.getExecutionEnvironment());
                        }
                        serverRecord.validate(true);
                        CompilerSetManager compilerSetManager = CompilerSetManager.getDefault((ExecutionEnvironment)serverRecord.getExecutionEnvironment());
                        compilerSetManager.initialize(true, true);
                    }
                    catch (CancellationException cancellationException) {
                        this.cancel();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        final String string = MessageFormat.format(MakeActionProvider.getString("ERR_Cant_Connect"), serverRecord.getDisplayName());
                        final String string2 = MakeActionProvider.getString("DLG_TITLE_Cant_Connect");
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), string, string2, 0);
                            }
                        });
                    }
                    if (serverRecord.isOnline()) {
                        cancellableTask.run();
                    }
                }
            };
        }
        object = WindowManager.getDefault().getMainWindow();
        String string = NbBundle.getMessage(MakeActionProvider.class, (String)"MSG_Validate_Host", (Object)serverRecord.getDisplayName());
        String string2 = NbBundle.getMessage(MakeActionProvider.class, (String)"DLG_TITLE_Validate_Host");
        ModalMessageDlg.runLongTask((Frame)object, (Runnable)cancellableTask2, null, (Cancellable)cancellableTask2, (String)string2, (String)string);
    }

    public void addAction(ArrayList<ProjectActionEvent> arrayList, String string, MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, String string2, Lookup lookup, AtomicBoolean atomicBoolean) throws IllegalArgumentException {
        if (atomicBoolean.get()) {
            return;
        }
        boolean bl = false;
        this.lastValidation = false;
        String[] stringArray = this.getTargetNames(string2, lookup);
        if (stringArray == null) {
            return;
        }
        if (stringArray.length == 0) {
            stringArray = null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            ProjectActionEvent projectActionEvent;
            Object object2;
            String string3;
            Object object3;
            Object object4;
            Object object5;
            String string4 = stringArray[i];
            ProjectActionEvent.Type type = string4.equals("build") ? ProjectActionEvent.Type.BUILD : (string4.equals("build-package") ? ProjectActionEvent.Type.BUILD : (string4.equals("clean") ? ProjectActionEvent.Type.CLEAN : (string4.equals("compile-single") ? ProjectActionEvent.Type.BUILD : (string4.equals("run") ? ProjectActionEvent.Type.RUN : (string4.equals("run-single") ? ProjectActionEvent.Type.RUN : (string4.equals("debug") ? ProjectActionEvent.Type.DEBUG : (string4.equals("debug-stepinto") ? ProjectActionEvent.Type.DEBUG_STEPINTO : (string4.equals("debug-load-only") ? ProjectActionEvent.Type.DEBUG_LOAD_ONLY : (string4.equals("custom-action") ? ProjectActionEvent.Type.CUSTOM_ACTION : ProjectActionEvent.Type.RUN)))))))));
            if (atomicBoolean.get()) {
                return;
            }
            PlatformInfo platformInfo = makeConfiguration.getPlatformInfo();
            if (string4.equals("save")) {
                if (MakeOptions.getInstance().getSave()) {
                    LifecycleManager.getDefault().saveAll();
                }
                if (!ProjectSupport.saveAllProjects(MakeActionProvider.getString("NeedToSaveAllText"))) {
                    return;
                }
                if (!useRsync || makeConfiguration.getDevelopmentHost().isLocalhost()) continue;
                CommandProvider commandProvider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
                int n = commandProvider.run(makeConfiguration.getDevelopmentHost().getExecutionEnvironment(), "which rsync", null);
                String string5 = n != 0 || commandProvider.getOutput().indexOf(32) > -1 ? "/opt/csw/bin/rsync" : commandProvider.getOutput();
                object5 = makeConfiguration.getProfile().clone(makeConfiguration);
                object4 = this.project.getProjectDirectory().getNameExt();
                object3 = REMOTE_BASE_PATH + platformInfo.separator() + (String)object4;
                if (string5 == null || string5.length() == 0 || "rsync" == null || "rsync".length() == 0) {
                    System.err.println("Rsync not fould in Toolchain: sources can not be synchronized");
                    return;
                }
                string3 = " --rsh=ssh --recursive --verbose --perms --links --delete --rsync-path=" + string5 + " --exclude \"build*\" --exclude \"dist*\" --cvs-exclude . " + makeConfiguration.getDevelopmentHost().getHostKey() + ":" + (String)object3;
                ((RunProfile)object5).setArgs(string3);
                ((RunProfile)object5).getConsoleType().setValue(2);
                object2 = (MakeConfiguration)makeConfiguration.clone();
                ((MakeConfiguration)object2).setDevelopmentHost(new DevelopmentHostConfiguration(ExecutionEnvironmentFactory.getLocal()));
                projectActionEvent = new ProjectActionEvent(this.project, type, string + " (Sync)", "rsync", (MakeConfiguration)object2, (RunProfile)object5, false);
                arrayList.add(projectActionEvent);
                continue;
            }
            if (string4.equals("run") || string4.equals("debug") || string4.equals("debug-stepinto") || string4.equals("debug-load-only")) {
                if (!this.validateBuildSystem(makeConfigurationDescriptor, makeConfiguration, bl, atomicBoolean)) {
                    return;
                }
                bl = true;
                if (makeConfiguration.isMakefileConfiguration()) {
                    if (string4.equals("run")) {
                        object = makeConfiguration.getMakefileConfiguration().getOutput().getValue();
                        if (((String)object).length() > 0 && !IpeUtils.isPathAbsolute((String)object)) {
                            object = makeConfiguration.getMakefileConfiguration().getAbsOutput();
                            object = IpeUtils.toRelativePath((String)makeConfiguration.getProfile().getRunDirectory(), (String)object);
                        }
                    } else {
                        object = makeConfiguration.getMakefileConfiguration().getAbsOutput();
                        object = FilePathAdaptor.normalize((String)object);
                    }
                    ProjectActionEvent projectActionEvent2 = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string, string4, makeConfiguration), (String)object, makeConfiguration, null, false);
                    arrayList.add(projectActionEvent2);
                    RunDialogPanel.addElementToExecutablePicklist((String)object);
                    continue;
                }
                if (makeConfiguration.isLibraryConfiguration()) {
                    assert (false);
                    return;
                }
                if (makeConfiguration.isApplicationConfiguration()) {
                    String string6;
                    object = null;
                    int n = makeConfiguration.getDevelopmentHost().getBuildPlatform();
                    if (n == 3) {
                        object = makeConfiguration.getProfile().clone(makeConfiguration);
                        Set<String> set = makeConfiguration.getSubProjectOutputLocations();
                        String string7 = "";
                        object5 = set.iterator();
                        while (object5.hasNext()) {
                            object4 = FilePathAdaptor.naturalize(object5.next());
                            string7 = object4 + ";" + string7;
                        }
                        object4 = makeConfiguration.getLinkerConfiguration().getAdditionalLibs().getValue();
                        object5 = object4.iterator();
                        while (object5.hasNext()) {
                            object3 = FilePathAdaptor.naturalize(object5.next());
                            string7 = (String)object3 + ";" + string7;
                        }
                        object3 = ((RunProfile)object).getEnvironment().getenv(platformInfo.getPathName());
                        if (object3 == null) {
                            if (atomicBoolean.get()) {
                                return;
                            }
                            object3 = (String)HostInfoProvider.getEnv((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).get(platformInfo.getPathName());
                        }
                        string7 = string7 + ";" + (String)object3;
                        ((RunProfile)object).getEnvironment().putenv(platformInfo.getPathName(), string7);
                    } else if (n == 4) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Set<String> set = makeConfiguration.getSubProjectOutputLocations();
                        object5 = set.iterator();
                        while (object5.hasNext()) {
                            object4 = FilePathAdaptor.naturalize(object5.next());
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(":");
                            }
                            stringBuilder.append((String)object4);
                        }
                        object4 = makeConfiguration.getLinkerConfiguration().getAdditionalLibs().getValue();
                        object5 = object4.iterator();
                        while (object5.hasNext()) {
                            object3 = FilePathAdaptor.naturalize(object5.next());
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(":");
                            }
                            stringBuilder.append((String)object3);
                        }
                        if (stringBuilder.length() > 0) {
                            object = makeConfiguration.getProfile().clone(makeConfiguration);
                            object3 = ((RunProfile)object).getEnvironment().getenv("DYLD_LIBRARY_PATH");
                            if (object3 == null) {
                                if (atomicBoolean.get()) {
                                    return;
                                }
                                object3 = (String)HostInfoProvider.getEnv((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).get("DYLD_LIBRARY_PATH");
                            }
                            if (object3 != null) {
                                stringBuilder.append(":" + (String)object3);
                            }
                            ((RunProfile)object).getEnvironment().putenv("DYLD_LIBRARY_PATH", stringBuilder.toString());
                        }
                    } else if (n == 1 || n == 0 || n == 2) {
                        StringBuilder stringBuilder = new StringBuilder();
                        List<String> list = makeConfiguration.getLinkerConfiguration().getAdditionalLibs().getValue();
                        object5 = list.iterator();
                        while (object5.hasNext()) {
                            object4 = FilePathAdaptor.naturalize(object5.next());
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(":");
                            }
                            stringBuilder.append((String)object4);
                        }
                        if (stringBuilder.length() > 0) {
                            object = makeConfiguration.getProfile().clone(makeConfiguration);
                            object4 = ((RunProfile)object).getEnvironment().getenv("LD_LIBRARY_PATH");
                            if (object4 == null) {
                                if (atomicBoolean.get()) {
                                    return;
                                }
                                object4 = (String)HostInfoProvider.getEnv((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).get("LD_LIBRARY_PATH");
                            }
                            if (object4 != null) {
                                stringBuilder.append(":" + (String)object4);
                            }
                            ((RunProfile)object).getEnvironment().putenv("LD_LIBRARY_PATH", stringBuilder.toString());
                        }
                    }
                    if (n == 4 || n == 1 || n == 0 || n == 2) {
                        if (atomicBoolean.get()) {
                            return;
                        }
                        if (makeConfiguration.getDevelopmentHost().getExecutionEnvironment().isLocal() && HostInfoProvider.getEnv((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).get("DISPLAY") == null && makeConfiguration.getProfile().getEnvironment().getenv("DISPLAY") == null) {
                            if (object == null) {
                                object = makeConfiguration.getProfile().clone(makeConfiguration);
                            }
                            ((RunProfile)object).getEnvironment().putenv("DISPLAY", ":0.0");
                        }
                    }
                    MakeArtifact makeArtifact = new MakeArtifact(makeConfigurationDescriptor, makeConfiguration);
                    if (string4.equals("run")) {
                        string6 = makeArtifact.getOutput();
                        if (!IpeUtils.isPathAbsolute((String)string6)) {
                            string6 = makeArtifact.getWorkingDirectory() + "/" + string6;
                            string6 = FilePathAdaptor.naturalize(string6);
                            string6 = IpeUtils.toRelativePath((String)makeConfiguration.getProfile().getRunDirectory(), (String)string6);
                            string6 = FilePathAdaptor.naturalize(string6);
                        }
                    } else {
                        string6 = IpeUtils.toAbsolutePath((String)makeConfiguration.getBaseDir(), (String)makeArtifact.getOutput());
                    }
                    object5 = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string, string4, makeConfiguration), string6, makeConfiguration, (RunProfile)object, false);
                    arrayList.add((ProjectActionEvent)object5);
                    RunDialogPanel.addElementToExecutablePicklist(string6);
                    continue;
                }
                assert (false);
                continue;
            }
            if (string4.equals("run-single") || string4.equals("debug-single")) {
                if (makeConfiguration.isMakefileConfiguration()) {
                    object = (DataObject)lookup.lookup(DataObject.class);
                    String string8 = FileUtil.toFile((FileObject)object.getPrimaryFile()).getPath();
                    ProjectActionEvent projectActionEvent3 = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string, "run", makeConfiguration), string8, makeConfiguration, null, false);
                    arrayList.add(projectActionEvent3);
                    RunDialogPanel.addElementToExecutablePicklist(string8);
                    continue;
                }
                assert (false);
                continue;
            }
            if (string4.equals("build")) {
                String string9;
                String string10;
                if (makeConfiguration.isCompileConfiguration() && !this.validateProject(makeConfiguration)) break;
                if (this.validateBuildSystem(makeConfigurationDescriptor, makeConfiguration, bl, atomicBoolean)) {
                    object = new MakeArtifact(makeConfigurationDescriptor, makeConfiguration);
                    string10 = ((MakeArtifact)object).getBuildCommand(MakeActionProvider.getMakeCommand(makeConfigurationDescriptor, makeConfiguration), "");
                    string9 = "";
                    int n = string10.indexOf(32);
                    if (n > 0) {
                        string9 = string10.substring(n + 1);
                        string10 = string10.substring(0, n);
                    }
                } else {
                    return;
                }
                object5 = new RunProfile(((MakeArtifact)object).getWorkingDirectory(), makeConfiguration.getDevelopmentHost().getBuildPlatform());
                ((RunProfile)object5).setArgs(string9);
                object4 = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string, string4, makeConfiguration), string10, makeConfiguration, (RunProfile)object5, true);
                arrayList.add((ProjectActionEvent)object4);
                bl = true;
                continue;
            }
            if (string4.equals("build-package")) {
                String string11;
                if (!this.validatePackaging(makeConfiguration)) {
                    arrayList.clear();
                    break;
                }
                if (makeConfiguration.getDevelopmentHost().getBuildPlatform() == 3) {
                    object = "cmd.exe";
                    string11 = "/c sh ";
                } else {
                    object = "bash";
                    string11 = "";
                }
                if (makeConfiguration.getPackagingConfiguration().getVerbose().getValue()) {
                    string11 = string11 + " -x ";
                }
                string11 = string11 + "nbproject/Package-" + makeConfiguration.getName() + ".bash";
                RunProfile runProfile = new RunProfile(makeConfiguration.getBaseDir(), makeConfiguration.getDevelopmentHost().getBuildPlatform());
                runProfile.setArgs(string11);
                ProjectActionEvent projectActionEvent4 = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string, string4, makeConfiguration), (String)object, makeConfiguration, runProfile, true);
                arrayList.add(projectActionEvent4);
                continue;
            }
            if (string4.equals("clean")) {
                String string12;
                String string13;
                if (this.validateBuildSystem(makeConfigurationDescriptor, makeConfiguration, bl, atomicBoolean)) {
                    object = new MakeArtifact(makeConfigurationDescriptor, makeConfiguration);
                    string13 = ((MakeArtifact)object).getCleanCommand(MakeActionProvider.getMakeCommand(makeConfigurationDescriptor, makeConfiguration), "");
                    string12 = "";
                    int n = string13.indexOf(32);
                    if (n > 0) {
                        string12 = string13.substring(n + 1);
                        string13 = string13.substring(0, n);
                    }
                } else {
                    return;
                }
                object5 = new RunProfile(((MakeArtifact)object).getWorkingDirectory(), makeConfiguration.getDevelopmentHost().getBuildPlatform());
                ((RunProfile)object5).setArgs(string12);
                object4 = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string, string4, makeConfiguration), string13, makeConfiguration, (RunProfile)object5, true);
                arrayList.add((ProjectActionEvent)object4);
                bl = true;
                continue;
            }
            if (string4.equals("compile-single")) {
                if (this.validateBuildSystem(makeConfigurationDescriptor, makeConfiguration, bl, atomicBoolean)) {
                    for (Node node : lookup.lookupAll(Node.class)) {
                        Item item = this.getNoteItem(node);
                        if (item == null) {
                            return;
                        }
                        ItemConfiguration itemConfiguration = item.getItemConfiguration(makeConfiguration);
                        if (itemConfiguration == null) {
                            return;
                        }
                        if (itemConfiguration.getExcluded().getValue()) {
                            return;
                        }
                        if (itemConfiguration.getTool() == 3 && !itemConfiguration.getCustomToolConfiguration().getModified()) {
                            return;
                        }
                        object5 = new MakeArtifact(makeConfigurationDescriptor, makeConfiguration);
                        object4 = null;
                        if (itemConfiguration.getTool() == 0) {
                            object3 = itemConfiguration.getCCompilerConfiguration();
                            object4 = ((BasicCompilerConfiguration)object3).getOutputFile(item, makeConfiguration, true);
                        } else if (itemConfiguration.getTool() == 1) {
                            object3 = itemConfiguration.getCCCompilerConfiguration();
                            object4 = ((BasicCompilerConfiguration)object3).getOutputFile(item, makeConfiguration, true);
                        } else if (itemConfiguration.getTool() == 2) {
                            object3 = itemConfiguration.getFortranCompilerConfiguration();
                            object4 = ((BasicCompilerConfiguration)object3).getOutputFile(item, makeConfiguration, true);
                        } else if (itemConfiguration.getTool() == 4) {
                            object3 = itemConfiguration.getAssemblerConfiguration();
                            object4 = ((BasicCompilerConfiguration)object3).getOutputFile(item, makeConfiguration, true);
                        } else if (itemConfiguration.getTool() == 3) {
                            object3 = itemConfiguration.getCustomToolConfiguration();
                            object4 = ((CustomToolConfiguration)object3).getOutputs().getValue();
                        }
                        object4 = makeConfiguration.expandMacros((String)object4);
                        if (makeConfiguration.getDevelopmentHost().getBuildPlatform() == 3) {
                            object3 = "cmd.exe";
                            string3 = "/c rm -rf " + (String)object4;
                        } else {
                            object3 = "rm";
                            string3 = "-rf " + (String)object4;
                        }
                        object2 = new RunProfile(((MakeArtifact)object5).getWorkingDirectory(), makeConfiguration.getDevelopmentHost().getBuildPlatform());
                        ((RunProfile)object2).setArgs(string3);
                        projectActionEvent = new ProjectActionEvent(this.project, ProjectActionEvent.Type.CLEAN, MakeActionProvider.getActionName(string, "clean", makeConfiguration), (String)object3, makeConfiguration, (RunProfile)object2, true);
                        arrayList.add(projectActionEvent);
                        object3 = MakeActionProvider.getMakeCommand(makeConfigurationDescriptor, makeConfiguration) + " -f nbproject" + '/' + "Makefile-" + makeConfiguration.getName() + ".mk " + (String)object4;
                        string3 = "";
                        int n = ((String)object3).indexOf(32);
                        if (n > 0) {
                            string3 = ((String)object3).substring(n + 1);
                            object3 = ((String)object3).substring(0, n);
                        }
                        object2 = new RunProfile(((MakeArtifact)object5).getWorkingDirectory(), makeConfiguration.getDevelopmentHost().getBuildPlatform());
                        ((RunProfile)object2).setArgs(string3);
                        projectActionEvent = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string, string4, makeConfiguration), (String)object3, makeConfiguration, (RunProfile)object2, true);
                        arrayList.add(projectActionEvent);
                    }
                } else {
                    return;
                }
                bl = true;
                continue;
            }
            if (!string4.equals("custom-action")) continue;
            object = makeConfiguration.getAbsoluteOutputValue();
            ProjectActionEvent projectActionEvent5 = new ProjectActionEvent(this.project, type, MakeActionProvider.getActionName(string, string4, makeConfiguration), (String)object, makeConfiguration, null, true);
            arrayList.add(projectActionEvent5);
        }
    }

    private static String getActionName(String string, String string2, MakeConfiguration makeConfiguration) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" (").append(string2);
        if (!makeConfiguration.getDevelopmentHost().isLocalhost()) {
            stringBuilder.append(" - ").append(makeConfiguration.getDevelopmentHost().getHostKey());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private boolean validateProject(MakeConfiguration makeConfiguration) {
        boolean bl = false;
        if (this.getProjectDescriptor().getProjectItems().length == 0) {
            bl = false;
        } else {
            for (int i = 0; i < this.getProjectDescriptor().getProjectItems().length; ++i) {
                Item item = this.getProjectDescriptor().getProjectItems()[i];
                ItemConfiguration itemConfiguration = item.getItemConfiguration(makeConfiguration);
                if (itemConfiguration.getExcluded().getValue() || itemConfiguration.getTool() == 3 && itemConfiguration.getCustomToolConfiguration().getCommandLine().getValue().length() <= 0) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MakeActionProvider.getString("ERR_EMPTY_PROJECT"), 0));
        }
        return bl;
    }

    String[] getTargetNames(String string, Lookup lookup) throws IllegalArgumentException {
        String[] stringArray = new String[]{};
        if (string.equals("compile.single")) {
            stringArray = this.commands.get(string);
        } else if (string.equals("run") || string.equals("debug") || string.equals("debug.stepinto") || string.equals(COMMAND_DEBUG_LOAD_ONLY) || string.equals(COMMAND_CUSTOM_ACTION)) {
            MakeConfigurationDescriptor makeConfigurationDescriptor = this.getProjectDescriptor();
            MakeConfiguration makeConfiguration = makeConfigurationDescriptor.getActiveConfiguration();
            if (makeConfiguration == null) {
                return null;
            }
            RunProfile runProfile = (RunProfile)makeConfiguration.getAuxObject("runprofile");
            if (runProfile == null) {
                return null;
            }
            stringArray = runProfile.getBuildFirst() ? this.commands.get(string) : this.commandsNoBuild.get(string);
            if (stringArray == null) {
                throw new IllegalArgumentException(string);
            }
        } else if (string.equals("run.single") || string.equals("debug.single") ? (stringArray = this.commands.get(string)) == null : (stringArray = this.commands.get(string)) == null) {
            throw new IllegalArgumentException(string);
        }
        return stringArray;
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        if (!this.isProjectDescriptorLoaded()) {
            return false;
        }
        MakeConfiguration makeConfiguration = this.getProjectDescriptor().getActiveConfiguration();
        if (makeConfiguration == null) {
            return false;
        }
        if (string.equals("clean")) {
            return true;
        }
        if (string.equals("build")) {
            return true;
        }
        if (string.equals(COMMAND_BUILD_PACKAGE)) {
            return true;
        }
        if (string.equals(COMMAND_BATCH_BUILD)) {
            return true;
        }
        if (string.equals("rebuild")) {
            return true;
        }
        if (string.equals("run")) {
            return !makeConfiguration.isLibraryConfiguration();
        }
        if (string.equals("debug")) {
            return makeConfiguration.hasDebugger() && !makeConfiguration.isLibraryConfiguration();
        }
        if (string.equals("debug.stepinto")) {
            return makeConfiguration.hasDebugger() && !makeConfiguration.isLibraryConfiguration();
        }
        if (string.equals(COMMAND_DEBUG_LOAD_ONLY)) {
            return makeConfiguration.hasDebugger() && !makeConfiguration.isLibraryConfiguration();
        }
        if (string.equals("compile.single")) {
            boolean bl = true;
            for (Node node : lookup.lookupAll(Node.class)) {
                Item item = this.getNoteItem(node);
                if (item == null) {
                    return false;
                }
                ItemConfiguration itemConfiguration = item.getItemConfiguration(makeConfiguration);
                if (itemConfiguration == null) {
                    return false;
                }
                if (itemConfiguration.getExcluded().getValue()) {
                    return false;
                }
                if (itemConfiguration.getTool() == 3 && !itemConfiguration.getCustomToolConfiguration().getModified()) {
                    return false;
                }
                if (!makeConfiguration.isMakefileConfiguration()) continue;
                return false;
            }
            return bl;
        }
        if (string.equals("delete") || string.equals("copy") || string.equals("move") || string.equals("rename")) {
            return true;
        }
        if (string.equals("run.single")) {
            Node node = (Node)lookup.lookup(Node.class);
            return node != null && node.getCookie(ShellExecSupport.class) != null;
        }
        return false;
    }

    private Item getNoteItem(Node node) {
        Item item = (Item)node.getValue("Item");
        if (item == null) {
            try {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject != null) {
                    File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
                    item = this.getProjectDescriptor().findItemByFile(file);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return item;
    }

    private static String getMakeCommand(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration) {
        String string = null;
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet != null) {
            string = compilerSet.getTool(5).getPath();
        } else {
            assert (false);
            string = "make";
        }
        return string;
    }

    private boolean validateBuildSystem(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, boolean bl, AtomicBoolean atomicBoolean) {
        CompilerSet compilerSet;
        String string;
        String string2;
        Platform platform;
        ExecutionEnvironment executionEnvironment;
        int n;
        int n2;
        CompilerSet2Configuration compilerSet2Configuration = makeConfiguration.getCompilerSet();
        ExecutionEnvironment executionEnvironment2 = ExecutionEnvironmentFactory.fromUniqueID((String)makeConfiguration.getDevelopmentHost().getHostKey());
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = makeConfiguration.hasCFiles(makeConfigurationDescriptor);
        boolean bl3 = makeConfiguration.hasCPPFiles(makeConfigurationDescriptor);
        boolean bl4 = makeConfiguration.hasFortranFiles(makeConfigurationDescriptor);
        boolean bl5 = makeConfiguration.hasAssemblerFiles(makeConfigurationDescriptor);
        boolean bl6 = false;
        if (bl) {
            return this.lastValidation;
        }
        if (!makeConfiguration.getDevelopmentHost().isLocalhost()) {
            ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)executionEnvironment2);
            assert (serverRecord != null);
            serverRecord.validate(false);
            if (atomicBoolean.get()) {
                return false;
            }
            if (!serverRecord.isOnline()) {
                this.lastValidation = false;
                bl6 = true;
            }
        }
        if ((n2 = makeConfiguration.getDevelopmentHost().getBuildPlatform()) != (n = CompilerSetManager.getDefault((ExecutionEnvironment)(executionEnvironment = makeConfiguration.getDevelopmentHost().getExecutionEnvironment())).getPlatform())) {
            if (!makeConfiguration.isMakefileConfiguration()) {
                Platform platform2 = Platforms.getPlatform(n2);
                platform = Platforms.getPlatform(n);
                string2 = MakeActionProvider.getString("WRONG_PLATFORM", platform.getDisplayName(), platform2.getDisplayName());
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string2, 2)) != NotifyDescriptor.OK_OPTION) {
                    return false;
                }
            }
            makeConfiguration.getDevelopmentHost().setBuildPlatform(n);
        }
        boolean bl7 = false;
        if (compilerSet2Configuration.getFlavor() != null && compilerSet2Configuration.getFlavor().equals("Unknown")) {
            bl7 = true;
            string = compilerSet2Configuration.getOption();
            compilerSet = CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment2).getCompilerSet(string);
            if (compilerSet == null) {
                compilerSet = CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment2).getDefaultCompilerSet();
            }
            bl6 = true;
        } else if (compilerSet2Configuration.isValid()) {
            string = compilerSet2Configuration.getOption();
            compilerSet = CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment2).getCompilerSet(string);
        } else {
            string = compilerSet2Configuration.getOldName();
            platform = null;
            if (compilerSet2Configuration.getFlavor() != null) {
                platform = CompilerSet.CompilerFlavor.toFlavor((String)compilerSet2Configuration.getFlavor(), (int)makeConfiguration.getPlatformInfo().getPlatform());
            }
            if (platform == null) {
                platform = CompilerSet.CompilerFlavor.getUnknown((int)makeConfiguration.getPlatformInfo().getPlatform());
            }
            compilerSet = CompilerSet.getCustomCompilerSet((String)"", (CompilerSet.CompilerFlavor)platform, (String)compilerSet2Configuration.getOldName());
            CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment2).add(compilerSet);
            compilerSet2Configuration.setValid();
        }
        platform = compilerSet.getTool(0);
        string2 = compilerSet.getTool(1);
        Tool tool = compilerSet.getTool(2);
        Tool tool2 = compilerSet.getTool(4);
        Tool tool3 = compilerSet.getTool(5);
        if (atomicBoolean.get()) {
            return false;
        }
        PlatformInfo platformInfo = makeConfiguration.getPlatformInfo();
        if (makeConfiguration.getDevelopmentHost().isLocalhost()) {
            File file = new File(tool3.getPath());
            if (!MakeActionProvider.exists(tool3.getPath(), platformInfo) && Path.findCommand((String)tool3.getPath()) == null || !ToolsPanel.supportedMake((String)file.getPath())) {
                bl6 = true;
            }
        } else if (!MakeActionProvider.isValidExecutable(tool3.getPath(), platformInfo)) {
            bl6 = true;
        }
        if (atomicBoolean.get()) {
            return false;
        }
        if (bl2 && !MakeActionProvider.exists(platform.getPath(), platformInfo)) {
            arrayList.add(NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MissingCCompiler", (Object)string, (Object)platform.getDisplayName()));
            bl6 = true;
        }
        if (atomicBoolean.get()) {
            return false;
        }
        if (bl3 && !MakeActionProvider.exists(string2.getPath(), platformInfo)) {
            arrayList.add(NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MissingCppCompiler", (Object)string, (Object)string2.getDisplayName()));
            bl6 = true;
        }
        if (atomicBoolean.get()) {
            return false;
        }
        if (bl4 && !MakeActionProvider.exists(tool.getPath(), platformInfo)) {
            arrayList.add(NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MissingFortranCompiler", (Object)string, (Object)tool.getDisplayName()));
            bl6 = true;
        }
        if (atomicBoolean.get()) {
            return false;
        }
        if (bl5 && !MakeActionProvider.exists(tool2.getPath(), platformInfo)) {
            bl6 = true;
        }
        if (makeConfiguration.getDevelopmentHost().isLocalhost() && Boolean.getBoolean("netbeans.cnd.always_show_bta")) {
            bl6 = true;
        }
        if (atomicBoolean.get()) {
            return false;
        }
        if (bl6) {
            if (makeConfiguration.getDevelopmentHost().isLocalhost()) {
                BuildToolsAction buildToolsAction = (BuildToolsAction)SystemAction.get(BuildToolsAction.class);
                buildToolsAction.setTitle(NbBundle.getMessage(BuildToolsAction.class, (String)"LBL_ResolveMissingTools_Title"));
                LocalToolsPanelModel localToolsPanelModel = new LocalToolsPanelModel();
                localToolsPanelModel.setSelectedDevelopmentHost(executionEnvironment2);
                localToolsPanelModel.setEnableDevelopmentHostChange(false);
                localToolsPanelModel.setCompilerSetName(null);
                localToolsPanelModel.setSelectedCompilerSetName(string);
                localToolsPanelModel.setMakeRequired(true);
                localToolsPanelModel.setGdbRequired(false);
                localToolsPanelModel.setCRequired(bl2);
                localToolsPanelModel.setCppRequired(bl3);
                localToolsPanelModel.setFortranRequired(bl4);
                localToolsPanelModel.setAsRequired(bl5);
                localToolsPanelModel.setShowRequiredBuildTools(true);
                localToolsPanelModel.setShowRequiredDebugTools(false);
                localToolsPanelModel.SetEnableRequiredCompilerCB(makeConfiguration.isMakefileConfiguration());
                if (buildToolsAction.initBuildTools((ToolsPanelModel)localToolsPanelModel, arrayList) && makeConfigurationDescriptor.okToChange()) {
                    String string3 = localToolsPanelModel.getSelectedCompilerSetName();
                    CppSettings.getDefault().setCompilerSetName(string3);
                    makeConfiguration.getCRequired().setValue(localToolsPanelModel.isCRequired());
                    makeConfiguration.getCppRequired().setValue(localToolsPanelModel.isCppRequired());
                    makeConfiguration.getFortranRequired().setValue(localToolsPanelModel.isFortranRequired());
                    makeConfiguration.getAssemblerRequired().setValue(localToolsPanelModel.isAsRequired());
                    makeConfiguration.getCompilerSet().setValue(string3);
                    makeConfigurationDescriptor.setModified();
                    makeConfigurationDescriptor.save();
                    this.lastValidation = true;
                } else {
                    this.lastValidation = false;
                }
            } else {
                if (atomicBoolean.get()) {
                    return false;
                }
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_INVALID_COMPILER_SET", (Object)string, (Object)makeConfiguration.getDevelopmentHost().getDisplayName(false)));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                this.lastValidation = false;
            }
        } else {
            this.lastValidation = true;
        }
        return this.lastValidation;
    }

    private boolean validatePackaging(MakeConfiguration makeConfiguration) {
        String string = null;
        if (makeConfiguration.getPackagingConfiguration().getFiles().getValue().size() == 0) {
            string = MakeActionProvider.getString("ERR_EMPTY_PACKAGE");
        }
        if (PackagerManager.getDefault().getPackager(makeConfiguration.getPackagingConfiguration().getType().getValue()) == null) {
            string = NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MISSING_TOOL4", (Object)makeConfiguration.getPackagingConfiguration().getType().getValue());
        }
        if (string != null) {
            MakeCustomizerProvider makeCustomizerProvider;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
            if (makeConfiguration.getPackagingConfiguration().getFiles().getValue().size() == 0 && (makeCustomizerProvider = (MakeCustomizerProvider)this.project.getLookup().lookup(MakeCustomizerProvider.class)) != null) {
                makeCustomizerProvider.showCustomizer("Packaging");
            }
            return false;
        }
        return true;
    }

    private static final boolean isValidExecutable(String string, PlatformInfo platformInfo) {
        return MakeActionProvider.existsImpl(string, platformInfo, true);
    }

    private static boolean exists(String string, PlatformInfo platformInfo) {
        return MakeActionProvider.existsImpl(string, platformInfo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean existsImpl(String string, PlatformInfo platformInfo, boolean bl) {
        boolean bl2;
        Object object;
        Map<String, Boolean> map;
        ExecutionEnvironment executionEnvironment = platformInfo.getExecutionEnvironment();
        String string2 = string + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)executionEnvironment);
        Map<String, Boolean> map2 = map = bl ? validExecutablesCache : fileExistenceCache;
        synchronized (map2) {
            object = map.get(string2);
            if (object != null && ((Boolean)object).booleanValue()) {
                return true;
            }
        }
        if (bl) {
            bl2 = ServerList.isValidExecutable((ExecutionEnvironment)executionEnvironment, (String)string);
        } else {
            boolean bl3 = bl2 = platformInfo.fileExists(string) || platformInfo.isWindows() && platformInfo.fileExists(string + ".lnk") || platformInfo.findCommand(string) != null;
        }
        if (bl2) {
            object = map;
            synchronized (object) {
                map.put(string2, Boolean.TRUE);
            }
        }
        return bl2;
    }

    private static boolean isAbsolutePath(MakeConfiguration makeConfiguration, String string) {
        if (makeConfiguration.getDevelopmentHost().getBuildPlatform() == 3) {
            return string.length() > 3 && string.charAt(1) == ':' && string.charAt(2) == '/';
        }
        return string.length() > 0 && string.charAt(0) == '/';
    }

    private static String getString(String string) {
        return NbBundle.getMessage(MakeActionProvider.class, (String)string);
    }

    private static String getString(String string, String string2, String string3) {
        return NbBundle.getMessage(MakeActionProvider.class, (String)string, (Object)string2, (Object)string3);
    }

    private static abstract class CancellableTask
    implements Runnable,
    Cancellable {
        private volatile Thread thread;
        protected final AtomicBoolean cancelled = new AtomicBoolean(false);

        private CancellableTask() {
        }

        protected abstract void runImpl();

        public final void run() {
            this.thread = Thread.currentThread();
            if (!this.cancelled.get()) {
                this.runImpl();
            }
        }

        public boolean cancel() {
            this.cancelled.set(true);
            if (this.thread != null) {
                this.thread.interrupt();
            }
            return true;
        }
    }

    class BatchConfigurationSelector
    implements ActionListener {
        private JButton buildButton = new JButton(MakeActionProvider.access$100("BuildButton"));
        private JButton rebuildButton = new JButton(MakeActionProvider.access$100("CleanBuildButton"));
        private JButton cleanButton = new JButton(MakeActionProvider.access$100("CleanButton"));
        private JButton closeButton = new JButton(MakeActionProvider.access$100("CloseButton"));
        private ConfSelectorPanel confSelectorPanel;
        private String command = null;
        private Dialog dialog = null;

        BatchConfigurationSelector(Configuration[] configurationArray) {
            this.confSelectorPanel = new ConfSelectorPanel(MakeActionProvider.getString("CheckLabel"), MakeActionProvider.getString("CheckLabelMn").charAt(0), configurationArray, new JButton[]{this.buildButton, this.rebuildButton, this.cleanButton});
            String string = MessageFormat.format(MakeActionProvider.getString("BatchBuildTitle"), ProjectUtils.getInformation((Project)MakeActionProvider.this.project).getDisplayName());
            this.buildButton.setMnemonic(MakeActionProvider.getString("BuildButtonMn").charAt(0));
            this.buildButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("BuildButtonAD"));
            this.buildButton.addActionListener(this);
            this.rebuildButton.setMnemonic(MakeActionProvider.getString("CleanBuildButtonMn").charAt(0));
            this.rebuildButton.addActionListener(this);
            this.rebuildButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("CleanBuildButtonAD"));
            this.cleanButton.setMnemonic(MakeActionProvider.getString("CleanButtonMn").charAt(0));
            this.cleanButton.addActionListener(this);
            this.cleanButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("CleanButtonAD"));
            this.closeButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("CloseButtonAD"));
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.confSelectorPanel, string, true, new Object[]{this.closeButton}, (Object)this.closeButton, 0, null, null);
            this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            this.dialog.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("BatchBuildDialogAD"));
            this.dialog.setVisible(true);
        }

        public Configuration[] getSelectedConfs() {
            return this.confSelectorPanel.getSelectedConfs();
        }

        public String getCommand() {
            return this.command;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.buildButton) {
                this.command = "build";
            } else if (actionEvent.getSource() == this.rebuildButton) {
                this.command = "rebuild";
            } else if (actionEvent.getSource() == this.cleanButton) {
                this.command = "clean";
            } else assert (false);
            this.dialog.dispose();
        }
    }
}

