/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.actions;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.maven.jaxws._RetoucheUtil;
import org.netbeans.modules.maven.jaxws.actions.AddWsOperationHelper;
import org.netbeans.modules.websvc.api.support.AddOperationCookie;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JaxWsAddOperation
implements AddOperationCookie {
    private FileObject implClassFo;

    public JaxWsAddOperation(FileObject fileObject) {
        this.implClassFo = fileObject;
    }

    public void addOperation() {
        final AddWsOperationHelper addWsOperationHelper = new AddWsOperationHelper(NbBundle.getMessage(JaxWsAddOperation.class, (String)"TITLE_OperationAction"));
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    String string = _RetoucheUtil.getMainClassName(JaxWsAddOperation.this.implClassFo);
                    if (string != null) {
                        addWsOperationHelper.addMethod(JaxWsAddOperation.this.implClassFo, string);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        });
    }

    public boolean isEnabledInEditor(Lookup lookup) {
        TypeElement typeElement;
        CompilationController compilationController = (CompilationController)lookup.lookup(CompilationController.class);
        if (compilationController != null && (typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController)) != null) {
            return this.isJaxWsImplementationClass(typeElement, compilationController);
        }
        return false;
    }

    private boolean isJaxWsImplementationClass(TypeElement typeElement, CompilationController compilationController) {
        TypeElement typeElement2 = compilationController.getElements().getTypeElement("javax.jws.WebService");
        if (typeElement2 != null) {
            List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : list) {
                if (!compilationController.getTypes().isSameType(typeElement2.asType(), annotationMirror.getAnnotationType())) continue;
                Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                    if (!entry.getKey().getSimpleName().contentEquals("wsdlLocation")) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

