/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.spi.RubyDebuggerImplementation;
import org.openide.filesystems.FileObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyProcessCreator
implements Callable<Process> {
    private static final Logger LOGGER = Logger.getLogger(RubyProcessCreator.class.getName());
    private static final boolean SYNC_RUBY_STDIO = System.getProperty("ruby.no.sync-stdio") == null;
    private static final boolean SKIP_KCODE = Boolean.getBoolean("ruby.no.kcode");
    private static final boolean LAUNCH_JRUBY_SCRIPT = System.getProperty("ruby.use.jruby.script") != null;
    private final RubyExecutionDescriptor descriptor;
    private final String charsetName;

    public RubyProcessCreator(RubyExecutionDescriptor rubyExecutionDescriptor) {
        this(rubyExecutionDescriptor, rubyExecutionDescriptor.getEncoding());
    }

    public RubyProcessCreator(RubyExecutionDescriptor rubyExecutionDescriptor, String string) {
        if (rubyExecutionDescriptor.getCmd() == null) {
            rubyExecutionDescriptor.cmd(rubyExecutionDescriptor.getPlatform().getInterpreterFile());
        }
        rubyExecutionDescriptor.addBinPath(true);
        this.descriptor = rubyExecutionDescriptor;
        this.charsetName = string;
    }

    public boolean isAbleToCreateProcess() {
        if (this.descriptor.debug) {
            RubyDebuggerImplementation rubyDebuggerImplementation = (RubyDebuggerImplementation)Lookup.getDefault().lookup(RubyDebuggerImplementation.class);
            if (rubyDebuggerImplementation == null) {
                LOGGER.severe("RubyDebuggerImplementation implementation is not available");
                return false;
            }
            rubyDebuggerImplementation.describeProcess(this.descriptor);
            return rubyDebuggerImplementation.prepare();
        }
        return true;
    }

    @Override
    public Process call() throws Exception {
        if (this.descriptor.debug) {
            RubyDebuggerImplementation rubyDebuggerImplementation = (RubyDebuggerImplementation)Lookup.getDefault().lookup(RubyDebuggerImplementation.class);
            if (rubyDebuggerImplementation == null) {
                throw new IllegalStateException("RubyDebuggerImplementation implementation is not available.");
            }
            rubyDebuggerImplementation.describeProcess(this.descriptor);
            if (!rubyDebuggerImplementation.prepare()) {
                throw new IllegalStateException("Cannot prepare application to debug. Should be checked before.");
            }
            return rubyDebuggerImplementation.debug();
        }
        ExternalProcessBuilder externalProcessBuilder = null;
        List<? extends String> list = this.buildArgs();
        if (!this.descriptor.cmd.getName().startsWith("jruby") || LAUNCH_JRUBY_SCRIPT) {
            externalProcessBuilder = new ExternalProcessBuilder(this.descriptor.cmd.getPath());
        } else {
            externalProcessBuilder = new ExternalProcessBuilder(list.get(0));
            list.remove(0);
        }
        for (String object : list) {
            externalProcessBuilder = externalProcessBuilder.addArgument(object);
        }
        if (this.descriptor.getPwd() != null) {
            externalProcessBuilder = externalProcessBuilder.workingDirectory(this.descriptor.getPwd());
        }
        for (Map.Entry entry : this.descriptor.getAdditionalEnvironment().entrySet()) {
            externalProcessBuilder = externalProcessBuilder.addEnvironmentVariable((String)entry.getKey(), (String)entry.getValue());
        }
        return externalProcessBuilder.call();
    }

    private List<? extends String> getRubyArgs(String string, String string2, RubyExecutionDescriptor rubyExecutionDescriptor) {
        int n;
        Object object;
        Object object2;
        String string3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!LAUNCH_JRUBY_SCRIPT && string2.startsWith("jruby")) {
            String[] stringArray;
            string3 = RubyProcessCreator.getJavaHome();
            arrayList.add(string3 + File.separator + "bin" + File.separator + "java");
            arrayList.add("-Xverify:none");
            arrayList.add("-da");
            object2 = "-Xmx512m";
            object = "-Xss1024k";
            String[] stringArray2 = stringArray = rubyExecutionDescriptor == null ? null : rubyExecutionDescriptor.getJVMArguments();
            if (stringArray != null) {
                for (String string4 : stringArray) {
                    if (string4.contains("-Xmx")) {
                        object2 = null;
                    }
                    if (string4.contains("-Xss")) {
                        object = null;
                    }
                    arrayList.add(string4);
                }
            }
            if (object2 != null) {
                arrayList.add(object2);
            }
            if (object != null) {
                arrayList.add(object);
            }
            arrayList.add("-classpath");
            Object object3 = null;
            try {
                object3 = new File(string);
                object3 = ((File)object3).getCanonicalFile();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            if (!((File)object3).isDirectory()) {
                throw new IllegalArgumentException(((File)object3).getAbsolutePath() + " does not exist.");
            }
            File file = new File((File)object3, "lib");
            if (!file.isDirectory()) {
                throw new AssertionError((Object)('\"' + file.getAbsolutePath() + "\" exists (\"" + rubyExecutionDescriptor.getCmd() + "\" is not valid JRuby executable?)"));
            }
            arrayList.add(RubyProcessCreator.computeJRubyClassPath(rubyExecutionDescriptor == null ? null : rubyExecutionDescriptor.getClassPath(), file));
            arrayList.add("-Djruby.base=" + object3);
            arrayList.add("-Djruby.home=" + object3);
            arrayList.add("-Djruby.lib=" + file);
            if (Utilities.isWindows()) {
                arrayList.add("-Djruby.shell=\"cmd.exe\"");
                arrayList.add("-Djruby.script=jruby.bat");
            } else {
                arrayList.add("-Djruby.shell=/bin/sh");
                arrayList.add("-Djruby.script=jruby");
            }
            arrayList.add("org.jruby.Main");
        }
        if (!SKIP_KCODE && string2.startsWith("ruby")) {
            string3 = this.charsetName;
            if (string3 == null && (object2 = rubyExecutionDescriptor.getFileObject()) != null && (object = FileEncodingQuery.getEncoding((FileObject)object2)) != null) {
                string3 = ((Charset)object).name();
            }
            if (string3 != null && string3.equals("UTF-8")) {
                arrayList.add("-Ku");
            }
        }
        if (SYNC_RUBY_STDIO && string2.startsWith("ruby") && ((n = string2.indexOf(46)) == -1 || n == 4 || n == 5)) {
            object2 = InstalledFileLocator.getDefault();
            object = object2.locate("modules/org-netbeans-modules-ruby-project.jar", null, false);
            if (object == null) {
                throw new RuntimeException("Can't find cluster");
            }
            object = new File(((File)object).getParentFile().getParentFile().getAbsolutePath() + File.separator + "sync-stdio.rb");
            try {
                object = ((File)object).getCanonicalFile();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            arrayList.add("-r" + ((File)object).getAbsolutePath());
        }
        return arrayList;
    }

    private List<? extends String> getCommonArgs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = this.descriptor.cmd;
        assert (file != null);
        if (this.descriptor.getInitialArgs() != null) {
            arrayList.addAll(Arrays.asList(this.descriptor.getInitialArgs()));
        }
        if (this.descriptor.getScriptPrefix() != null) {
            arrayList.add(this.descriptor.getScriptPrefix());
        }
        if (this.descriptor.script != null) {
            arrayList.add(this.descriptor.script);
        }
        if (this.descriptor.getAdditionalArgs() != null) {
            arrayList.addAll(Arrays.asList(this.descriptor.getAdditionalArgs()));
        }
        return arrayList;
    }

    protected List<? extends String> buildArgs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.descriptor.getCmd().getParentFile().getParent();
        String string2 = this.descriptor.getCmd().getName();
        if (this.descriptor.isRunThroughRuby()) {
            arrayList.addAll(this.getRubyArgs(string, string2, this.descriptor));
        }
        arrayList.addAll(this.getCommonArgs());
        return arrayList;
    }

    public static String getJavaHome() {
        String string = System.getProperty("jruby.java.home");
        if (string == null) {
            string = System.getProperty("java.home");
        }
        return string;
    }

    static String computeJRubyClassPath(String string, File file) {
        StringBuilder stringBuilder = new StringBuilder();
        File[] fileArray = file.listFiles();
        for (File file2 : fileArray) {
            if (!file2.getName().endsWith(".jar")) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            stringBuilder.append(file2.getAbsolutePath());
        }
        if (string != null && File.pathSeparatorChar != ':') {
            StringBuilder stringBuilder2 = new StringBuilder();
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == ':' && n != 1) {
                    stringBuilder2.append(File.pathSeparatorChar);
                    n = 0;
                    continue;
                }
                ++n;
                stringBuilder2.append(c);
            }
            string = stringBuilder2.toString();
        }
        if (string == null) {
            string = System.getenv("JRUBY_EXTRA_CLASSPATH");
        }
        if (string != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            stringBuilder.append(string);
        }
        return Utilities.isWindows() ? "\"" + stringBuilder.toString() + "\"" : stringBuilder.toString();
    }
}

