/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.ruby.platform;

import java.awt.EventQueue;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.ruby.platform.RubyInstallation;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.spi.project.support.rake.EditableProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyProvider;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.io.ReaderInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyPlatformManager {
    public static final boolean PREINDEXING = Boolean.getBoolean("gsf.preindexing");
    private static final String[] RUBY_EXECUTABLE_NAMES = new String[]{"ruby", "jruby", "rubinius"};
    static Properties TEST_RUBY_PROPS;
    private static final String PLATFORM_PREFIX = "rubyplatform.";
    private static final String PLATFORM_INTEPRETER = ".interpreter";
    private static final String PLATFORM_ID_DEFAULT = "default";
    private static final Logger LOGGER;
    private static final Comparator<RubyPlatform> ALPHABETICAL_COMPARATOR;
    private static Set<RubyPlatform> platforms;
    private static final VetoableChangeSupport VETOABLE_CHANGE_SUPPORT;

    private RubyPlatformManager() {
    }

    static void resetPlatforms() {
        platforms = null;
        RubyPlatformManager.firePlatformsChanged();
    }

    public static synchronized Set<RubyPlatform> getPlatforms() {
        return new HashSet<RubyPlatform>(RubyPlatformManager.getPlatformsInternal());
    }

    public static synchronized SortedSet<? extends RubyPlatform> getSortedPlatforms() {
        TreeSet<RubyPlatform> treeSet = new TreeSet<RubyPlatform>(ALPHABETICAL_COMPARATOR);
        treeSet.addAll(RubyPlatformManager.getPlatformsInternal());
        return treeSet;
    }

    public static synchronized void performPlatformDetection() {
        if (PREINDEXING) {
            return;
        }
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        for (String object : Util.dirsOnPath()) {
            for (String string : RUBY_EXECUTABLE_NAMES) {
                File file = RubyPlatformManager.findPlatform(object, string);
                if (file == null) continue;
                linkedHashSet.add(file);
            }
        }
        RubyPlatform rubyPlatform = RubyPlatformManager.findDefaultPlatform();
        if (rubyPlatform != null) {
            RubyPlatformManager.getPlatformsInternal().add(rubyPlatform);
        }
        for (File file : linkedHashSet) {
            try {
                if (RubyPlatformManager.getPlatformByFile(file) != null) continue;
                RubyPlatformManager.addPlatform(file);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
            }
        }
        RubyPreferences.setFirstPlatformTouch(false);
    }

    private static RubyPlatform findDefaultPlatform() {
        String string = RubyInstallation.getInstance().getJRuby();
        return string == null ? null : new RubyPlatform(PLATFORM_ID_DEFAULT, string, RubyPlatform.Info.forDefaultPlatform());
    }

    private static void firePlatformsChanged() {
        try {
            VETOABLE_CHANGE_SUPPORT.fireVetoableChange("platforms", null, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private static File findPlatform(String string, String string2) {
        File file = null;
        if (Utilities.isWindows()) {
            file = new File(string, string2 + ".exe");
        } else {
            String string3;
            file = new File(string, string2);
            if (string2.equals("ruby") && Utilities.isMac() && "/usr/bin/ruby".equals(file.getPath()) && ((string3 = System.getProperty("os.version")) == null || string3.startsWith("10.4"))) {
                return null;
            }
        }
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    private static synchronized Set<RubyPlatform> getPlatformsInternal() {
        if (platforms == null) {
            platforms = new HashSet<RubyPlatform>();
            String string = System.getProperty("ruby.interpreter");
            if (string != null) {
                RubyPlatform.Info info = new RubyPlatform.Info("User-specified Ruby", "0.1");
                FileObject fileObject = FileUtil.toFileObject((File)new File(string)).getParent().getParent().getFileObject("lib/ruby/gems/1.8");
                if (fileObject != null) {
                    Properties properties = new Properties();
                    properties.setProperty("ruby_kind", "User-specified Ruby");
                    properties.setProperty("ruby_version", "0.1");
                    String string2 = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
                    properties.setProperty("gem_home", string2);
                    properties.setProperty("gem_path", string2);
                    properties.setProperty("gem_version", "1.0.1 (1.0.1)");
                    properties.setProperty("ruby_lib_dir", new File(new File(string).getParentFile().getParentFile(), "lib" + File.separator + "ruby" + File.separator + "1.8").getPath());
                    info = new RubyPlatform.Info(properties);
                }
                platforms.add(new RubyPlatform(PLATFORM_ID_DEFAULT, string, info));
                return platforms;
            }
            Map map = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{PropertyUtils.globalPropertyProvider()}).getProperties();
            if (map == null) {
                map = Collections.emptyMap();
            }
            boolean bl = false;
            final ArrayList<String> arrayList = new ArrayList<String>();
            Object object = map.entrySet().iterator();
            while (object.hasNext()) {
                String string3;
                Map.Entry entry = object.next();
                String string4 = (String)entry.getKey();
                if (!string4.startsWith(PLATFORM_PREFIX) || !string4.endsWith(PLATFORM_INTEPRETER)) continue;
                String string5 = string4.substring(PLATFORM_PREFIX.length(), string4.length() - PLATFORM_INTEPRETER.length());
                String string6 = string5 + '.';
                Properties properties = new Properties();
                String string7 = (String)map.get(PLATFORM_PREFIX + string6 + "ruby_lib_dir");
                String string8 = (String)map.get(PLATFORM_PREFIX + string6 + "ruby_kind");
                String string9 = (String)entry.getValue();
                if (string8 == null) {
                    arrayList.add(string9);
                    continue;
                }
                if (string7 != null) {
                    properties.put("ruby_lib_dir", string7);
                } else if (!"Rubinius".equals(string8)) {
                    LOGGER.warning("no libDir for platform: " + string9);
                    arrayList.add(string9);
                    continue;
                }
                properties.put("ruby_kind", string8);
                properties.put("ruby_version", map.get(PLATFORM_PREFIX + string6 + "ruby_version"));
                String string10 = (String)map.get(PLATFORM_PREFIX + string6 + "jruby_version");
                if (string10 != null) {
                    properties.put("jruby_version", string10);
                }
                if ((string3 = (String)map.get(PLATFORM_PREFIX + string6 + "ruby_patchlevel")) != null) {
                    properties.put("ruby_patchlevel", string3);
                }
                properties.put("ruby_release_date", map.get(PLATFORM_PREFIX + string6 + "ruby_release_date"));
                properties.put("ruby_platform", map.get(PLATFORM_PREFIX + string6 + "ruby_platform"));
                String string11 = (String)map.get(PLATFORM_PREFIX + string6 + "gem_home");
                if (string11 != null) {
                    properties.put("gem_home", string11);
                    properties.put("gem_path", map.get(PLATFORM_PREFIX + string6 + "gem_path"));
                    properties.put("gem_version", map.get(PLATFORM_PREFIX + string6 + "gem_version"));
                }
                RubyPlatform.Info info = new RubyPlatform.Info(properties);
                platforms.add(new RubyPlatform(string5, string9, info));
                bl |= string5.equals(PLATFORM_ID_DEFAULT);
            }
            if (!bl && (object = RubyPlatformManager.findDefaultPlatform()) != null) {
                platforms.add((RubyPlatform)object);
            }
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    for (String string : arrayList) {
                        try {
                            RubyPlatformManager.addPlatform(new File(string));
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                }
            });
            LOGGER.fine("RubyPlatform initial list: " + platforms);
        }
        return platforms;
    }

    public static RubyPlatform getDefaultPlatform() {
        RubyPlatform rubyPlatform = RubyPlatformManager.getPlatformByID(PLATFORM_ID_DEFAULT);
        if (rubyPlatform == null) {
            LOGGER.fine("Default platform is not installed");
        }
        return rubyPlatform;
    }

    public static synchronized RubyPlatform getPlatformByID(String string) {
        for (RubyPlatform rubyPlatform : RubyPlatformManager.getPlatformsInternal()) {
            if (!rubyPlatform.getID().equals(string)) continue;
            return rubyPlatform;
        }
        return null;
    }

    public static synchronized RubyPlatform getPlatformByFile(File file) {
        for (RubyPlatform rubyPlatform : RubyPlatformManager.getPlatformsInternal()) {
            try {
                File file2;
                File file3 = new File(rubyPlatform.getInterpreter()).getCanonicalFile();
                if (!file3.equals(file2 = file.getCanonicalFile())) continue;
                return rubyPlatform;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
            }
        }
        return null;
    }

    static synchronized RubyPlatform getPlatformByPath(String string) {
        return RubyPlatformManager.getPlatformByFile(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyPlatform addPlatform(final File file) throws IOException {
        if (!file.isFile()) {
            return null;
        }
        RubyPlatform rubyPlatform = RubyPlatformManager.getPlatformByFile(file);
        if (rubyPlatform != null) {
            return rubyPlatform;
        }
        final RubyPlatform.Info info = RubyPlatformManager.computeInfo(file);
        if (info == null) {
            return null;
        }
        if (info.getKind() == null) {
            LOGGER.warning("Getting platform information for " + file + " failed.");
            return null;
        }
        final String string = RubyPlatformManager.computeID(info.getKind());
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    if (RubyPlatformManager.getPlatformByID(string) != null) {
                        throw new IOException("ID " + string + " already taken");
                    }
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    RubyPlatformManager.putPlatformProperties(string, file, info, editableProperties);
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
        rubyPlatform = new RubyPlatform(string, file.getAbsolutePath(), info);
        Class<RubyPlatform> clazz = RubyPlatform.class;
        synchronized (RubyPlatform.class) {
            RubyPlatformManager.getPlatformsInternal().add(rubyPlatform);
            // ** MonitorExit[var4_5] (shouldn't be in output)
            RubyPlatformManager.firePlatformsChanged();
            LOGGER.fine("RubyPlatform added: " + rubyPlatform);
            return rubyPlatform;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePlatform(final RubyPlatform rubyPlatform) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    RubyPlatformManager.clearProperties(rubyPlatform, editableProperties);
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
        Class<RubyPlatform> clazz = RubyPlatform.class;
        synchronized (RubyPlatform.class) {
            RubyPlatformManager.getPlatformsInternal().remove(rubyPlatform);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            RubyPlatformManager.firePlatformsChanged();
            LOGGER.fine("RubyPlatform removed: " + rubyPlatform);
            return;
        }
    }

    public static void storePlatform(final RubyPlatform rubyPlatform) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    RubyPlatformManager.clearProperties(rubyPlatform, editableProperties);
                    RubyPlatformManager.putPlatformProperties(rubyPlatform.getID(), rubyPlatform.getInterpreterFile(), rubyPlatform.getInfo(), editableProperties);
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
        LOGGER.fine("RubyPlatform stored: " + rubyPlatform);
    }

    private static void clearProperties(RubyPlatform rubyPlatform, EditableProperties editableProperties) {
        String string = PLATFORM_PREFIX + rubyPlatform.getID();
        editableProperties.remove((Object)(string + PLATFORM_INTEPRETER));
        String string2 = string + '.';
        editableProperties.remove((Object)(PLATFORM_PREFIX + string2 + "ruby_kind"));
        editableProperties.remove((Object)(PLATFORM_PREFIX + string2 + "ruby_version"));
        editableProperties.remove((Object)(PLATFORM_PREFIX + string2 + "jruby_version"));
        editableProperties.remove((Object)(PLATFORM_PREFIX + string2 + "ruby_patchlevel"));
        editableProperties.remove((Object)(PLATFORM_PREFIX + string2 + "ruby_release_date"));
        editableProperties.remove((Object)(PLATFORM_PREFIX + string2 + "ruby_platform"));
        editableProperties.remove((Object)(PLATFORM_PREFIX + string2 + "ruby_lib_dir"));
        editableProperties.remove((Object)(PLATFORM_PREFIX + string2 + "gem_home"));
        editableProperties.remove((Object)(PLATFORM_PREFIX + string2 + "gem_path"));
        editableProperties.remove((Object)(PLATFORM_PREFIX + string2 + "gem_version"));
    }

    private static void putPlatformProperties(String string, File file, RubyPlatform.Info info, EditableProperties editableProperties) throws FileNotFoundException {
        String string2 = PLATFORM_PREFIX + string + PLATFORM_INTEPRETER;
        editableProperties.setProperty(string2, file.getAbsolutePath());
        if (!file.isFile()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        String string3 = string + '.';
        editableProperties.setProperty(PLATFORM_PREFIX + string3 + "ruby_kind", info.getKind());
        editableProperties.setProperty(PLATFORM_PREFIX + string3 + "ruby_version", info.getVersion());
        if (info.getJVersion() != null) {
            editableProperties.setProperty(PLATFORM_PREFIX + string3 + "jruby_version", info.getJVersion());
        }
        if (info.getPatchlevel() != null) {
            editableProperties.setProperty(PLATFORM_PREFIX + string3 + "ruby_patchlevel", info.getPatchlevel());
        }
        editableProperties.setProperty(PLATFORM_PREFIX + string3 + "ruby_release_date", info.getReleaseDate());
        editableProperties.setProperty(PLATFORM_PREFIX + string3 + "ruby_platform", info.getPlatform());
        if (!info.isRubinius()) {
            editableProperties.setProperty(PLATFORM_PREFIX + string3 + "ruby_lib_dir", info.getLibDir());
        }
        if (info.getGemHome() != null) {
            editableProperties.setProperty(PLATFORM_PREFIX + string3 + "gem_home", info.getGemHome());
            editableProperties.setProperty(PLATFORM_PREFIX + string3 + "gem_path", info.getGemPath());
            editableProperties.setProperty(PLATFORM_PREFIX + string3 + "gem_version", info.getGemVersion());
        }
    }

    private static String computeID(String string) {
        String string2 = string;
        int n = 0;
        while (RubyPlatformManager.getPlatformByID(string2) != null) {
            string2 = string + '_' + n;
            ++n;
        }
        return string2;
    }

    public static Iterator<RubyPlatform> platformIterator() {
        return RubyPlatformManager.getPlatformsInternal().iterator();
    }

    static RubyPlatform.Info computeInfo(File file) {
        assert (!EventQueue.isDispatchThread()) : "computeInfo should not be run from EDT";
        if (TEST_RUBY_PROPS != null && !RubyPlatformManager.getDefaultPlatform().getInterpreterFile().equals(file)) {
            return new RubyPlatform.Info(TEST_RUBY_PROPS);
        }
        RubyPlatform.Info info = null;
        try {
            int n;
            File file2 = InstalledFileLocator.getDefault().locate("platform_info.rb", "org.netbeans.modules.ruby.platform", false);
            if (file2 == null) {
                throw new IllegalStateException("Cannot locate platform_info.rb script");
            }
            ProcessBuilder processBuilder = new ProcessBuilder(file.getAbsolutePath(), file2.getAbsolutePath());
            processBuilder.environment().remove("JRUBY_HOME");
            processBuilder.environment().put("JAVA_HOME", ExecutionUtils.getJavaHome());
            ExecutionUtils.logProcess(processBuilder);
            final Process process = processBuilder.start();
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.log(Level.SEVERE, interruptedException.getLocalizedMessage(), interruptedException);
                    }
                }
            }, "Ruby Platform Gatherer");
            thread.start();
            try {
                thread.join(30000L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.SEVERE, interruptedException.getLocalizedMessage(), interruptedException);
                return null;
            }
            try {
                n = process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                LOGGER.warning("Detection of platform timeouted");
                process.destroy();
                return null;
            }
            if (n == 0) {
                Properties properties = new Properties();
                if (LOGGER.isLoggable(Level.FINER)) {
                    String string = Util.readAsString(process.getInputStream());
                    String string2 = Util.readAsString(process.getErrorStream());
                    LOGGER.finer("stdout:\n" + string);
                    LOGGER.finer("stderr:\n " + string2);
                    properties.load((InputStream)new ReaderInputStream((Reader)new StringReader(string)));
                } else {
                    properties.load(process.getInputStream());
                }
                info = new RubyPlatform.Info(properties);
            } else {
                String string;
                LOGGER.severe(file.getAbsolutePath() + " does not seems to be a valid interpreter");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((string = bufferedReader.readLine()) != null) {
                    LOGGER.severe(string);
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, "Not a ruby platform: " + file.getAbsolutePath());
        }
        return info;
    }

    public static void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        VETOABLE_CHANGE_SUPPORT.addVetoableChangeListener(vetoableChangeListener);
    }

    public static void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        VETOABLE_CHANGE_SUPPORT.removeVetoableChangeListener(vetoableChangeListener);
    }

    static {
        LOGGER = Logger.getLogger(RubyPlatformManager.class.getName());
        ALPHABETICAL_COMPARATOR = new Comparator<RubyPlatform>(){

            @Override
            public int compare(RubyPlatform rubyPlatform, RubyPlatform rubyPlatform2) {
                int n = Collator.getInstance().compare(rubyPlatform.getInfo().getLongDescription(), rubyPlatform2.getInfo().getLongDescription());
                if (n == 0) {
                    n = rubyPlatform.getInterpreter().compareTo(rubyPlatform2.getInterpreter());
                }
                return n;
            }
        };
        VETOABLE_CHANGE_SUPPORT = new VetoableChangeSupport(RubyPlatformManager.class);
    }
}

