/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterInfo;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClusterUtils {
    private ClusterUtils() {
    }

    public static boolean isValidCluster(File file) {
        return new File(file, "config/Modules").isDirectory();
    }

    public static File getClusterDirectory(Project project) {
        NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        if (nbModuleProvider != null) {
            return nbModuleProvider.getModuleJarLocation().getParentFile().getParentFile();
        }
        SuiteProvider suiteProvider = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
        if (suiteProvider != null) {
            return suiteProvider.getClusterDirectory();
        }
        return null;
    }

    public static File evaluateClusterPathEntry(String string, File file, PropertyEvaluator propertyEvaluator, File file2) {
        File file3;
        Matcher matcher;
        File file4;
        final Pattern pattern = Pattern.compile("(?:.*[\\\\/])?([^/\\\\]*?)([0-9.]+)?[/\\\\]?$");
        if (string.startsWith("${nbplatform.active.dir}")) {
            string = file2.getAbsolutePath() + string.substring("${nbplatform.active.dir}".length());
        }
        if (!(file4 = PropertyUtils.resolveFile((File)file, (String)propertyEvaluator.evaluate(string))).exists() && (matcher = pattern.matcher(file4.getAbsolutePath())).matches() && (file3 = file4.getParentFile()) != null) {
            File[] fileArray = file3.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    Matcher matcher2 = pattern.matcher(string);
                    return matcher2.matches() && matcher.group(1).equalsIgnoreCase(matcher2.group(1));
                }
            });
            if (fileArray == null) {
                return file4;
            }
            if (fileArray.length > 0 && fileArray[0].isDirectory()) {
                return fileArray[0];
            }
        }
        return file4;
    }

    public static Set<ClusterInfo> evaluateClusterPath(File file, PropertyEvaluator propertyEvaluator, File file2) {
        LinkedHashSet<ClusterInfo> linkedHashSet = new LinkedHashSet<ClusterInfo>();
        String string = propertyEvaluator.getProperty("cluster.path");
        String[] stringArray = PropertyUtils.tokenizePath((String)(string != null ? string : ""));
        String string2 = propertyEvaluator.getProperty("cluster.path.with.disabled.clusters");
        String[] stringArray2 = string2 != null ? PropertyUtils.tokenizePath((String)string2) : null;
        String[] stringArray3 = stringArray2 != null ? stringArray2 : stringArray;
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray2 != null) {
            hashSet.addAll(Arrays.asList(stringArray));
        }
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        Map map = propertyEvaluator.getProperties();
        for (Map.Entry entry : map.entrySet()) {
            File file3;
            String string3;
            String string4 = (String)entry.getKey();
            if (!string4.startsWith("extcluster.")) continue;
            if (string4.endsWith(".sources")) {
                string3 = string4.substring("extcluster.".length(), string4.length() - ".sources".length());
                file3 = PropertyUtils.resolveFile((File)file, (String)string3);
                hashMap.put(file3, entry.getValue());
                continue;
            }
            if (!string4.endsWith(".javadoc")) continue;
            string3 = string4.substring("extcluster.".length(), string4.length() - ".javadoc".length());
            file3 = PropertyUtils.resolveFile((File)file, (String)string3);
            hashMap2.put(file3, entry.getValue());
        }
        for (String string3 : stringArray3) {
            String string5;
            boolean bl;
            boolean bl2 = string3.contains("${nbplatform.active.dir}");
            File file4 = ClusterUtils.evaluateClusterPathEntry(string3, file, propertyEvaluator, file2);
            Project project = null;
            if (!file4.exists() && (bl = (string5 = file4.getAbsolutePath()).length() - "build/cluster".length()) >= false && "build/cluster".equals(string5.substring(bl ? 1 : 0).replace(File.separatorChar, '/'))) {
                file4 = new File(string5.substring(0, bl ? 1 : 0));
            }
            if ((string5 = FileUtil.toFileObject((File)file4)) != null && (project = FileOwnerQuery.getOwner((FileObject)string5)) != null && project.getLookup().lookup(NbModuleProvider.class) == null && project.getLookup().lookup(SuiteProvider.class) == null) {
                project = null;
            }
            bl = stringArray2 == null || hashSet.contains(string3);
            URL[] uRLArray = null;
            if (hashMap.containsKey(file4)) {
                uRLArray = Util.findURLs((String)hashMap.get(file4));
            }
            URL[] uRLArray2 = null;
            if (hashMap2.containsKey(file4)) {
                uRLArray2 = Util.findURLs((String)hashMap2.get(file4));
            }
            linkedHashSet.add(ClusterInfo.createFromCP(file4, project, bl2, uRLArray, uRLArray2, bl));
        }
        return linkedHashSet;
    }
}

