/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.AbstractEntry;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractEntryWithSources
extends AbstractEntry {
    private LocalizedBundleInfo bundleInfo;
    private Set<String> allPackageNames;
    private final String src;

    protected AbstractEntryWithSources(String string) {
        this.src = string;
    }

    @Override
    protected LocalizedBundleInfo getBundleInfo() {
        if (this.bundleInfo == null) {
            this.bundleInfo = ModuleList.loadBundleInfo(this.getSourceLocation());
        }
        return this.bundleInfo;
    }

    @Override
    protected Set<String> computePublicClassNamesInMainModule() throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        File file = new File(this.getSourceLocation(), this.src);
        for (ManifestManager.PackageExport packageExport : this.getPublicPackages()) {
            String string = packageExport.getPackage();
            this.scanForClasses(hashSet, string, new File(file, string.replace('.', File.separatorChar)), packageExport.isRecursive());
        }
        return hashSet;
    }

    @Override
    public synchronized Set<String> getAllPackageNames() {
        if (this.allPackageNames == null) {
            this.allPackageNames = Util.scanProjectForPackageNames(this.getSourceLocation());
        }
        return this.allPackageNames;
    }

    private void scanForClasses(Set<String> set, String string, File file, boolean bl) throws IOException {
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException(file.getAbsolutePath());
        }
        for (File file2 : fileArray) {
            String string2 = file2.getName();
            if (string2.endsWith(".java")) {
                String string3 = string2.substring(0, string2.length() - 5);
                set.add(string + '.' + string3);
            }
            if (!bl || !file2.isDirectory()) continue;
            this.scanForClasses(set, string + '.' + string2, file2, true);
        }
    }

    @Override
    public String[] getRunDependencies() {
        NbModuleProject nbModuleProject;
        Object object;
        TreeSet<String> treeSet = new TreeSet<String>();
        FileObject fileObject = FileUtil.toFileObject((File)this.getSourceLocation());
        if (fileObject == null) {
            return new String[0];
        }
        try {
            object = ProjectManager.getDefault().findProject(fileObject);
            nbModuleProject = object == null ? null : (NbModuleProject)object.getLookup().lookup(NbModuleProject.class);
        }
        catch (IOException iOException) {
            Util.err.notify(1, (Throwable)iOException);
            return new String[0];
        }
        if (nbModuleProject == null) {
            return new String[0];
        }
        object = nbModuleProject.getPrimaryConfigurationData();
        Element element = Util.findElement((Element)object, "module-dependencies", "http://www.netbeans.org/ns/nb-module-project/3");
        assert (element != null) : "Malformed metadata in " + nbModuleProject;
        for (Element element2 : Util.findSubElements(element)) {
            if (Util.findElement(element2, "run-dependency", "http://www.netbeans.org/ns/nb-module-project/3") == null) continue;
            Element element3 = Util.findElement(element2, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/3");
            String string = Util.findText(element3);
            treeSet.add(string);
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    @Override
    public String getSpecificationVersion() {
        FileObject fileObject = FileUtil.toFileObject((File)this.getSourceLocation());
        if (fileObject != null) {
            try {
                NbModuleProject nbModuleProject = (NbModuleProject)ProjectManager.getDefault().findProject(fileObject);
                if (nbModuleProject != null) {
                    return nbModuleProject.getSpecVersion();
                }
            }
            catch (IOException iOException) {
                Util.err.notify(1, (Throwable)iOException);
            }
        }
        return null;
    }
}

