/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SingleModuleProperties
extends ModuleProperties {
    private static final String[] IDE_TOKENS = new String[]{"org.openide.modules.os.Windows", "org.openide.modules.os.Unix", "org.openide.modules.os.MacOSX", "org.openide.modules.os.PlainUnix", "org.openide.modules.os.OS2"};
    public static final String BUILD_COMPILER_DEBUG = "build.compiler.debug";
    public static final String BUILD_COMPILER_DEPRECATION = "build.compiler.deprecation";
    public static final String IS_AUTOLOAD = "is.autoload";
    public static final String IS_EAGER = "is.eager";
    public static final String JAVAC_SOURCE = "javac.source";
    public static final String JAVADOC_TITLE = "javadoc.title";
    public static final String LICENSE_FILE = "license.file";
    public static final String NBM_HOMEPAGE = "nbm.homepage";
    public static final String NBM_MODULE_AUTHOR = "nbm.module.author";
    public static final String NBM_NEEDS_RESTART = "nbm.needs.restart";
    public static final String SPEC_VERSION_BASE = "spec.version.base";
    public static final String JAVAC_COMPILERARGS = "javac.compilerargs";
    static final String[] SOURCE_LEVELS = new String[]{"1.4", "1.5", "1.6"};
    private static final Map<String, String> DEFAULTS;
    private boolean majorReleaseVersionChanged;
    private boolean specificationVersionChanged;
    private boolean implementationVersionChange;
    private boolean providedTokensChanged;
    private boolean autoUpdateShowInClientChanged;
    private NbModuleProvider.NbModuleType moduleType;
    private SuiteProvider suiteProvider;
    private ProjectXMLManager projectXMLManager;
    private final LocalizedBundleInfo.Provider bundleInfoProvider;
    private LocalizedBundleInfo bundleInfo;
    private String majorReleaseVersion;
    private String specificationVersion;
    private String implementationVersion;
    private String provTokensString;
    private SortedSet<String> requiredTokens;
    private Boolean autoUpdateShowInClient;
    private NbPlatform activePlatform;
    private NbPlatform originalPlatform;
    private JavaPlatform activeJavaPlatform;
    private boolean javaPlatformChanged;
    private SortedSet<String> availablePublicPackages;
    private String[] allTokens;
    private SortedSet<String> modCategories;
    private Set<ModuleDependency> universeDependencies;
    private CustomizerComponentFactory.PublicPackagesTableModel publicPackagesModel;
    private CustomizerComponentFactory.DependencyListModel dependencyListModel;
    private CustomizerComponentFactory.FriendListModel friendListModel;
    private CustomizerComponentFactory.RequiredTokenListModel requiredTokensListModel;
    public static final String NB_PLATFORM_PROPERTY = "nbPlatform";
    public static final String JAVA_PLATFORM_PROPERTY = "nbjdk.active";
    public static final String DEPENDENCIES_PROPERTY = "moduleDependencies";
    static final Logger UI_LOG;

    public static SingleModuleProperties getInstance(NbModuleProject nbModuleProject) {
        SuiteProvider suiteProvider = (SuiteProvider)nbModuleProject.getLookup().lookup(SuiteProvider.class);
        return new SingleModuleProperties(nbModuleProject.getHelper(), nbModuleProject.evaluator(), suiteProvider, Util.getModuleType(nbModuleProject), (LocalizedBundleInfo.Provider)nbModuleProject.getLookup().lookup(LocalizedBundleInfo.Provider.class));
    }

    SingleModuleProperties(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SuiteProvider suiteProvider, NbModuleProvider.NbModuleType nbModuleType, LocalizedBundleInfo.Provider provider) {
        super(antProjectHelper, propertyEvaluator);
        this.bundleInfoProvider = provider;
        this.refresh(nbModuleType, suiteProvider);
    }

    protected void refresh(NbModuleProvider.NbModuleType nbModuleType, SuiteProvider suiteProvider) {
        Object object;
        Object object2;
        this.reloadProperties();
        this.suiteProvider = suiteProvider;
        this.moduleType = nbModuleType;
        this.universeDependencies = null;
        this.modCategories = null;
        this.availablePublicPackages = null;
        this.dependencyListModel = null;
        this.friendListModel = null;
        this.requiredTokensListModel = null;
        this.projectXMLManager = null;
        if (this.isSuiteComponent()) {
            assert (this.getSuiteDirectory() != null);
            ModuleList.refreshModuleListForRoot(this.getSuiteDirectory());
        } else if (this.isStandalone()) {
            ModuleList.refreshModuleListForRoot(this.getProjectDirectoryFile());
        }
        ManifestManager manifestManager = ManifestManager.getInstance(this.getManifestFile(), false);
        this.majorReleaseVersion = manifestManager.getReleaseVersion();
        this.specificationVersion = manifestManager.getSpecificationVersion();
        this.implementationVersion = manifestManager.getImplementationVersion();
        this.provTokensString = manifestManager.getProvidedTokensString();
        this.autoUpdateShowInClient = manifestManager.getAutoUpdateShowInClient();
        String string = this.getEvaluator().getProperty("netbeans.dest.dir");
        if (string != null) {
            object2 = NbPlatform.getPlatformByDestDir(this.getHelper().resolveFile(string));
            if (!((NbPlatform)object2).isValid() && (object = NbPlatform.getDefaultPlatform()) != null) {
                object2 = object;
            }
            this.originalPlatform = this.activePlatform = object2;
        }
        if ((object2 = this.getEvaluator().getProperty(JAVA_PLATFORM_PROPERTY)) != null) {
            this.activeJavaPlatform = ModuleProperties.findJavaPlatformByID((String)object2);
        } else {
            object = this.getEvaluator().getProperty("nbjdk.home");
            this.activeJavaPlatform = ModuleProperties.findJavaPlatformByLocation((String)object);
        }
        this.javaPlatformChanged = false;
        this.getPublicPackagesModel().reloadData(this.loadPublicPackages());
        this.requiredTokens = Collections.unmodifiableSortedSet(new TreeSet<String>(Arrays.asList(manifestManager.getRequiredTokens())));
        this.bundleInfo = this.bundleInfoProvider.getLocalizedBundleInfo();
        if (this.bundleInfo != null) {
            try {
                this.bundleInfo.reload();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        this.firePropertiesRefreshed();
    }

    void resetUniverseDependencies() {
        this.universeDependencies = null;
    }

    @Override
    Map<String, String> getDefaultValues() {
        return DEFAULTS;
    }

    LocalizedBundleInfo getBundleInfo() {
        return this.bundleInfo;
    }

    String getCodeNameBase() {
        return this.getProjectXMLManager().getCodeNameBase();
    }

    String getJarFile() {
        return this.getHelper().resolveFile(this.getEvaluator().evaluate("${cluster}/${module.jar}")).getAbsolutePath();
    }

    String getSuiteDirectoryPath() {
        return this.getSuiteDirectory() != null ? this.getSuiteDirectory().getPath() : null;
    }

    File getSuiteDirectory() {
        return this.suiteProvider != null ? this.suiteProvider.getSuiteDirectory() : null;
    }

    SuiteProject getSuite() {
        assert (this.isSuiteComponent());
        SuiteProject suiteProject = null;
        try {
            FileObject fileObject = FileUtil.toFileObject((File)this.getSuiteDirectory());
            if (fileObject != null) {
                suiteProject = (SuiteProject)ProjectManager.getDefault().findProject(fileObject);
            }
        }
        catch (IOException iOException) {
            Util.err.notify(1, (Throwable)iOException);
        }
        return suiteProject;
    }

    boolean isActivePlatformValid() {
        NbPlatform nbPlatform = this.getActivePlatform();
        return nbPlatform == null || nbPlatform.isValid();
    }

    NbPlatform getActivePlatform() {
        if (this.moduleType != NbModuleProvider.NETBEANS_ORG && this.activePlatform == null) {
            ModuleProperties.reportLostPlatform(this.activePlatform);
            this.activePlatform = NbPlatform.getDefaultPlatform();
        }
        return this.activePlatform;
    }

    void setActivePlatform(NbPlatform nbPlatform) {
        if (this.activePlatform != nbPlatform) {
            NbPlatform nbPlatform2 = this.activePlatform;
            this.activePlatform = nbPlatform;
            this.dependencyListModel = null;
            this.universeDependencies = null;
            this.modCategories = null;
            this.firePropertyChange(NB_PLATFORM_PROPERTY, nbPlatform2, nbPlatform);
        }
    }

    JavaPlatform getActiveJavaPlatform() {
        return this.activeJavaPlatform;
    }

    void setActiveJavaPlatform(JavaPlatform javaPlatform) {
        JavaPlatform javaPlatform2 = this.activeJavaPlatform;
        if (javaPlatform != javaPlatform2) {
            this.activeJavaPlatform = javaPlatform;
            this.firePropertyChange(JAVA_PLATFORM_PROPERTY, javaPlatform2, javaPlatform);
            this.javaPlatformChanged = true;
        }
    }

    String getMajorReleaseVersion() {
        return this.majorReleaseVersion;
    }

    void setMajorReleaseVersion(String string) {
        if (!Utilities.compareObjects((Object)this.majorReleaseVersion, (Object)string)) {
            this.majorReleaseVersion = string;
            this.majorReleaseVersionChanged = true;
        }
    }

    String getSpecificationVersion() {
        return this.specificationVersion;
    }

    void setSpecificationVersion(String string) {
        if (!Utilities.compareObjects((Object)this.specificationVersion, (Object)string)) {
            this.specificationVersion = string;
            this.specificationVersionChanged = true;
        }
    }

    String getImplementationVersion() {
        return this.implementationVersion;
    }

    void setImplementationVersion(String string) {
        if (!Utilities.compareObjects((Object)this.implementationVersion, (Object)string)) {
            this.implementationVersion = string;
            this.implementationVersionChange = true;
        }
    }

    String getProvidedTokens() {
        return this.provTokensString;
    }

    void setProvidedTokens(String string) {
        if (!Utilities.compareObjects((Object)this.provTokensString, (Object)string)) {
            this.provTokensString = string;
            this.providedTokensChanged = true;
        }
    }

    public Boolean getAutoUpdateShowInClient() {
        return this.autoUpdateShowInClient;
    }

    public void setAutoUpdateShowInClient(Boolean bl) {
        if (!Utilities.compareObjects((Object)this.autoUpdateShowInClient, (Object)bl)) {
            this.autoUpdateShowInClient = bl;
            this.autoUpdateShowInClientChanged = true;
        }
    }

    boolean isStandalone() {
        return this.moduleType == NbModuleProvider.STANDALONE;
    }

    boolean isNetBeansOrg() {
        return this.moduleType == NbModuleProvider.NETBEANS_ORG;
    }

    boolean isSuiteComponent() {
        return this.moduleType == NbModuleProvider.SUITE_COMPONENT;
    }

    boolean dependingOnImplDependency() {
        CustomizerComponentFactory.DependencyListModel dependencyListModel = this.getDependenciesListModel();
        if (dependencyListModel == CustomizerComponentFactory.INVALID_DEP_LIST_MODEL) {
            return false;
        }
        Set<ModuleDependency> set = dependencyListModel.getDependencies();
        for (ModuleDependency moduleDependency : set) {
            if (!moduleDependency.hasImplementationDepedendency()) continue;
            return true;
        }
        return false;
    }

    private ProjectXMLManager getProjectXMLManager() {
        block3: {
            if (this.projectXMLManager == null) {
                try {
                    this.projectXMLManager = ProjectXMLManager.getInstance(this.getProjectDirectoryFile());
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)iOException);
                }
            }
        }
        return this.projectXMLManager;
    }

    CustomizerComponentFactory.DependencyListModel getDependenciesListModel() {
        if (this.dependencyListModel == null) {
            if (this.isActivePlatformValid()) {
                try {
                    this.dependencyListModel = new CustomizerComponentFactory.DependencyListModel(this.getProjectXMLManager().getDirectDependencies(this.getActivePlatform()), true);
                    this.dependencyListModel.addListDataListener(new ListDataListener(){

                        public void contentsChanged(ListDataEvent listDataEvent) {
                            SingleModuleProperties.this.firePropertyChange(SingleModuleProperties.DEPENDENCIES_PROPERTY, null, SingleModuleProperties.this.getDependenciesListModel());
                        }

                        public void intervalAdded(ListDataEvent listDataEvent) {
                            this.contentsChanged(null);
                        }

                        public void intervalRemoved(ListDataEvent listDataEvent) {
                            this.contentsChanged(null);
                        }
                    });
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    this.dependencyListModel = CustomizerComponentFactory.getInvalidDependencyListModel();
                }
            } else {
                this.dependencyListModel = CustomizerComponentFactory.getInvalidDependencyListModel();
            }
        }
        return this.dependencyListModel;
    }

    Set<ModuleDependency> getUniverseDependencies(boolean bl, boolean bl2) {
        String[] stringArray;
        String[] stringArray2;
        Object object;
        assert (!SwingUtilities.isEventDispatchThread()) : "SingleModuleProperties.getUniverseDependencies() cannot be called from EDT";
        if (this.universeDependencies == null) {
            this.reloadModuleListInfo();
        }
        if (this.universeDependencies == null) {
            return Collections.emptySet();
        }
        HashSet<ModuleDependency> hashSet = new HashSet<ModuleDependency>(this.universeDependencies);
        if (bl && this.isSuiteComponent()) {
            object = this.getSuite();
            if (object == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SingleModuleProperties.class, (String)"SingleModuleProperties.incorrectSuite", (Object)this.getSuiteDirectoryPath(), (Object)this.getProjectDisplayName()), 2));
                return Collections.emptySet();
            }
            stringArray2 = SuiteProperties.getArrayProperty(((SuiteProject)object).getEvaluator(), "disabled.modules");
            stringArray = SuiteProperties.getArrayProperty(((SuiteProject)object).getEvaluator(), "enabled.clusters");
            String[] stringArray3 = SuiteProperties.getArrayProperty(((SuiteProject)object).getEvaluator(), "disabled.clusters");
            String string = this.getEvaluator().getProperty("cluster");
            File file = string != null ? this.getHelper().resolveFile(string) : null;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ModuleDependency moduleDependency = (ModuleDependency)iterator.next();
                ModuleEntry moduleEntry = moduleDependency.getModuleEntry();
                if (moduleEntry.getClusterDirectory().equals(file) || !SingleModuleProperties.isExcluded(moduleEntry, Arrays.asList(stringArray2), Arrays.asList(stringArray), Arrays.asList(stringArray3))) continue;
                iterator.remove();
            }
        }
        if (bl2) {
            object = hashSet.iterator();
            while (object.hasNext()) {
                stringArray2 = (String[])object.next();
                stringArray = stringArray2.getModuleEntry();
                if (stringArray.getPublicPackages().length != 0 && stringArray.isDeclaredAsFriend(this.getCodeNameBase())) continue;
                object.remove();
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    Set<ModuleDependency> getUniverseDependencies(boolean bl) {
        return this.getUniverseDependencies(bl, false);
    }

    public static boolean isExcluded(ModuleEntry moduleEntry, Collection<String> collection, Collection<String> collection2, Collection<String> collection3) {
        if (collection.contains(moduleEntry.getCodeNameBase())) {
            return true;
        }
        String string = moduleEntry.getClusterDirectory().getName();
        if (!collection2.isEmpty() && !SingleModuleProperties.clusterMatch(collection2, string)) {
            return true;
        }
        return collection2.isEmpty() && collection3.contains(string);
    }

    static boolean clusterMatch(Collection<String> collection, String string) {
        String string2 = SingleModuleProperties.clusterBaseName(string);
        for (String string3 : collection) {
            if (!SingleModuleProperties.clusterBaseName(string3).equals(string2)) continue;
            return true;
        }
        return false;
    }

    static String clusterBaseName(String string) {
        return string.replaceFirst("[0-9.]+$", "");
    }

    String[] getAvailableFriends() {
        TreeSet<String> treeSet;
        block3: {
            block2: {
                treeSet = new TreeSet<String>();
                if (!this.isSuiteComponent()) break block2;
                for (Project project : SuiteUtils.getSubProjects(this.getSuite())) {
                    String string = ProjectUtils.getInformation((Project)project).getName();
                    if (this.getCodeNameBase().equals(string)) continue;
                    treeSet.add(string);
                }
                break block3;
            }
            if (!this.isNetBeansOrg()) break block3;
            Set<ModuleDependency> set = this.getUniverseDependencies(false);
            for (ModuleDependency moduleDependency : set) {
                treeSet.add(moduleDependency.getModuleEntry().getCodeNameBase());
            }
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    CustomizerComponentFactory.FriendListModel getFriendListModel() {
        if (this.friendListModel == null) {
            this.friendListModel = new CustomizerComponentFactory.FriendListModel(this.getProjectXMLManager().getFriends());
        }
        return this.friendListModel;
    }

    CustomizerComponentFactory.RequiredTokenListModel getRequiredTokenListModel() {
        if (this.requiredTokensListModel == null) {
            this.requiredTokensListModel = new CustomizerComponentFactory.RequiredTokenListModel(this.requiredTokens);
        }
        return this.requiredTokensListModel;
    }

    String[] getAllTokens() {
        if (this.allTokens == null) {
            try {
                TreeSet<String> treeSet = new TreeSet<String>();
                treeSet.addAll(Arrays.asList(IDE_TOKENS));
                for (ModuleEntry moduleEntry : this.getModuleList().getAllEntriesSoft()) {
                    treeSet.addAll(Arrays.asList(moduleEntry.getProvidedTokens()));
                }
                String[] stringArray = new String[treeSet.size()];
                return treeSet.toArray(stringArray);
            }
            catch (IOException iOException) {
                this.allTokens = new String[0];
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        return this.allTokens;
    }

    CustomizerComponentFactory.PublicPackagesTableModel getPublicPackagesModel() {
        if (this.publicPackagesModel == null) {
            this.publicPackagesModel = new CustomizerComponentFactory.PublicPackagesTableModel(this.loadPublicPackages());
        }
        return this.publicPackagesModel;
    }

    private Map<String, Boolean> loadPublicPackages() {
        Collection<String> collection = this.getSelectedPackages();
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        for (String string : this.getAvailablePublicPackages()) {
            treeMap.put(string, collection.contains(string));
        }
        return treeMap;
    }

    private Collection<String> getSelectedPackages() {
        HashSet<String> hashSet = new HashSet<String>();
        ManifestManager.PackageExport[] packageExportArray = this.getProjectXMLManager().getPublicPackages();
        for (int i = 0; i < packageExportArray.length; ++i) {
            ManifestManager.PackageExport packageExport = packageExportArray[i];
            if (packageExport.isRecursive()) {
                for (String string : this.getAvailablePublicPackages()) {
                    if (!string.startsWith(packageExport.getPackage())) continue;
                    hashSet.add(string);
                }
                continue;
            }
            hashSet.add(packageExport.getPackage());
        }
        return hashSet;
    }

    Set<String> getAvailablePublicPackages() {
        if (this.availablePublicPackages == null) {
            this.availablePublicPackages = Util.scanProjectForPackageNames(this.getProjectDirectoryFile());
        }
        return this.availablePublicPackages;
    }

    @Override
    void storeProperties() throws IOException {
        String[] stringArray;
        CustomizerComponentFactory.DependencyListModel dependencyListModel;
        super.storeProperties();
        this.storeManifestChanges();
        if (this.bundleInfo != null && this.bundleInfo.isModified()) {
            this.bundleInfo.store();
        }
        if ((dependencyListModel = this.getDependenciesListModel()).isChanged()) {
            stringArray = new TreeSet<ModuleDependency>(dependencyListModel.getDependencies());
            SingleModuleProperties.logNetBeansAPIUsage("DEPENDENCIES", dependencyListModel.getDependencies());
            this.getProjectXMLManager().replaceDependencies((Set<ModuleDependency>)stringArray);
        }
        stringArray = this.getFriendListModel().getFriends();
        String[] stringArray2 = this.getPublicPackagesModel().getSelectedPackages();
        boolean bl = false;
        if (this.getPublicPackagesModel().isChanged() || this.getFriendListModel().isChanged()) {
            if (stringArray.length > 0) {
                this.getProjectXMLManager().replaceFriends(stringArray, stringArray2);
            } else {
                this.getProjectXMLManager().replacePublicPackages(stringArray2);
            }
            bl = true;
        }
        if (this.isStandalone()) {
            ModuleProperties.storePlatform(this.getHelper(), this.getActivePlatform());
            if (this.javaPlatformChanged) {
                ModuleProperties.storeJavaPlatform(this.getHelper(), this.getEvaluator(), this.getActiveJavaPlatform(), false);
            }
            if (bl) {
                ModuleList.refreshModuleListForRoot(this.getProjectDirectoryFile());
            }
        } else if (this.isSuiteComponent() && bl) {
            ModuleList.refreshModuleListForRoot(this.getSuiteDirectory());
        } else if (this.isNetBeansOrg()) {
            if (this.javaPlatformChanged) {
                ModuleProperties.storeJavaPlatform(this.getHelper(), this.getEvaluator(), this.getActiveJavaPlatform(), true);
            }
            if (bl) {
                ModuleList.refreshModuleListForRoot(ModuleList.findNetBeansOrg(this.getProjectDirectoryFile()));
            }
        }
    }

    private static void logNetBeansAPIUsage(String string, Collection<ModuleDependency> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ModuleDependency moduleDependency : collection) {
            String string2 = moduleDependency.getModuleEntry().getCodeNameBase();
            if (!string2.startsWith("org.openide") && !string2.startsWith("org.netbeans")) continue;
            arrayList.add(string2);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        LogRecord logRecord = new LogRecord(Level.CONFIG, string);
        logRecord.setParameters(arrayList.toArray(new String[0]));
        logRecord.setResourceBundleName(SingleModuleProperties.class.getPackage().getName() + ".Bundle");
        logRecord.setResourceBundle(NbBundle.getBundle(SingleModuleProperties.class));
        logRecord.setLoggerName(UI_LOG.getName());
        UI_LOG.log(logRecord);
    }

    private void storeManifestChanges() throws IOException {
        String[] stringArray;
        EditableManifest editableManifest;
        FileObject fileObject = FileUtil.toFileObject((File)this.getManifestFile());
        if (fileObject != null) {
            editableManifest = Util.loadManifest(fileObject);
        } else {
            editableManifest = new EditableManifest();
            fileObject = FileUtil.createData((FileObject)this.getHelper().getProjectDirectory(), (String)"manifest.mf");
        }
        boolean bl = false;
        if (this.majorReleaseVersionChanged) {
            stringArray = "".equals(this.getMajorReleaseVersion()) ? this.getCodeNameBase() : this.getCodeNameBase() + '/' + this.getMajorReleaseVersion();
            this.setManifestAttribute(editableManifest, "OpenIDE-Module", (String)stringArray);
            bl = true;
        }
        if (this.specificationVersionChanged) {
            this.setManifestAttribute(editableManifest, "OpenIDE-Module-Specification-Version", this.getSpecificationVersion());
            bl = true;
        }
        if (this.implementationVersionChange) {
            this.setManifestAttribute(editableManifest, "OpenIDE-Module-Implementation-Version", this.getImplementationVersion());
            bl = true;
        }
        if (this.providedTokensChanged) {
            this.setManifestAttribute(editableManifest, "OpenIDE-Module-Provides", this.getProvidedTokens());
            bl = true;
        }
        if (this.getRequiredTokenListModel().isChanged()) {
            stringArray = this.getRequiredTokenListModel().getTokens();
            StringBuffer stringBuffer = new StringBuffer(stringArray.length > 1 ? "\n  " : "");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(",\n  ");
                }
                stringBuffer.append(stringArray[i]);
            }
            this.setManifestAttribute(editableManifest, "OpenIDE-Module-Requires", stringBuffer.toString());
            bl = true;
        }
        if (this.autoUpdateShowInClientChanged) {
            this.setManifestAttribute(editableManifest, "AutoUpdate-Show-In-Client", this.autoUpdateShowInClient != null ? this.autoUpdateShowInClient.toString() : "");
            bl = true;
        }
        if (bl) {
            Util.storeManifest(fileObject, editableManifest);
        }
    }

    private void setManifestAttribute(EditableManifest editableManifest, String string, String string2) {
        assert (string2 != null);
        if ("".equals(string2)) {
            if (editableManifest.getAttribute(string, null) != null) {
                editableManifest.removeAttribute(string, null);
            }
        } else {
            editableManifest.setAttribute(string, string2, null);
        }
    }

    File getManifestFile() {
        return this.getHelper().resolveFile(this.getEvaluator().getProperty("manifest.mf"));
    }

    SortedSet<String> getModuleCategories() {
        assert (!SwingUtilities.isEventDispatchThread()) : "SingleModuleProperties.getModuleCategories() cannot be called from EDT";
        if (this.modCategories == null && !this.reloadModuleListInfo()) {
            return new TreeSet<String>();
        }
        return this.modCategories;
    }

    boolean reloadModuleListInfo() {
        assert (!SwingUtilities.isEventDispatchThread()) : "SingleModuleProperties.reloadModuleListInfo() cannot be called from EDT";
        if (this.isActivePlatformValid()) {
            try {
                TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
                HashSet<ModuleDependency> hashSet = new HashSet<ModuleDependency>();
                for (ModuleEntry moduleEntry : this.getModuleList().getAllEntriesSoft()) {
                    String string;
                    if (!moduleEntry.getCodeNameBase().equals(this.getCodeNameBase())) {
                        hashSet.add(new ModuleDependency(moduleEntry));
                    }
                    if ((string = moduleEntry.getCategory()) == null) continue;
                    treeSet.add(string);
                }
                this.modCategories = Collections.unmodifiableSortedSet(treeSet);
                this.universeDependencies = Collections.unmodifiableSet(hashSet);
                return true;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return false;
    }

    ModuleList getModuleList() throws IOException {
        if (this.getActivePlatform() != this.originalPlatform) {
            try {
                return ModuleList.getModuleList(this.getProjectDirectoryFile(), this.getActivePlatform().getDestDir());
            }
            catch (IOException iOException) {
                Logger.getLogger(SingleModuleProperties.class.getName()).log(Level.FINE, null, iOException);
                NbPlatform nbPlatform = NbPlatform.getDefaultPlatform();
                return ModuleList.getModuleList(this.getProjectDirectoryFile(), nbPlatform != null ? nbPlatform.getDestDir() : null);
            }
        }
        return ModuleList.getModuleList(this.getProjectDirectoryFile());
    }

    File evaluateFile(String string) {
        String string2 = this.getEvaluator().evaluate(string);
        return string2 == null ? null : this.getHelper().resolveFile(string2);
    }

    Project getProject() {
        Project project;
        block2: {
            project = null;
            try {
                project = ProjectManager.getDefault().findProject(this.getHelper().getProjectDirectory());
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)iOException);
            }
        }
        return project;
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(BUILD_COMPILER_DEBUG, "true");
        hashMap.put(BUILD_COMPILER_DEPRECATION, "true");
        hashMap.put(IS_AUTOLOAD, "false");
        hashMap.put(IS_EAGER, "false");
        hashMap.put(JAVAC_SOURCE, "1.4");
        hashMap.put(NBM_NEEDS_RESTART, "false");
        DEFAULTS = Collections.unmodifiableMap(hashMap);
        UI_LOG = Logger.getLogger("org.netbeans.ui.apisupport");
    }
}

