/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JDialog;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

abstract class BasicCustomizer
implements CustomizerProvider {
    static final String LAST_SELECTED_PANEL = "lastSelectedPanel";
    private final Project project;
    private Dialog dialog;
    private String lastSelectedCategory;
    private String layerPath;

    protected BasicCustomizer(Project project, String string) {
        this.project = project;
        this.layerPath = string;
    }

    abstract void storeProperties() throws IOException;

    abstract Lookup prepareData();

    abstract void dialogCleanup();

    protected Project getProject() {
        return this.project;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String string) {
        this.showCustomizer(string, null);
    }

    public void showCustomizer(String string, String string2) {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
            return;
        }
        Lookup lookup = this.prepareData();
        if (string == null) {
            string = this.lastSelectedCategory;
        }
        lookup = new ProxyLookup(new Lookup[]{lookup, Lookups.fixed((Object[])new Object[]{new SubCategoryProvider(string, string2)})});
        OptionListener optionListener = new OptionListener();
        this.dialog = ProjectCustomizer.createCustomizerDialog((String)this.layerPath, (Lookup)lookup, (String)string, (ActionListener)optionListener, null);
        this.dialog.addWindowListener(optionListener);
        this.dialog.setTitle(NbBundle.getMessage(this.getClass(), (String)"LBL_CustomizerTitle", (Object)ProjectUtils.getInformation((Project)this.getProject()).getDisplayName()));
        this.dialog.setVisible(true);
    }

    public final void save() {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    BasicCustomizer.this.storeProperties();
                    ProjectManager.getDefault().saveProject(BasicCustomizer.this.project);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)((IOException)mutexException.getException()));
        }
    }

    private String findLastSelectedCategory() {
        if (this.dialog != null && this.dialog instanceof JDialog) {
            return (String)((JDialog)this.dialog).getRootPane().getClientProperty(LAST_SELECTED_PANEL);
        }
        return null;
    }

    static final class SubCategoryProvider {
        private String subcategory;
        private String category;

        SubCategoryProvider(String string, String string2) {
            this.category = string;
            this.subcategory = string2;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSubcategory() {
            return this.subcategory;
        }
    }

    protected class OptionListener
    extends WindowAdapter
    implements ActionListener {
        protected OptionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicCustomizer.this.save();
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.doClose();
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.doClose();
        }

        public void doClose() {
            if (BasicCustomizer.this.dialog != null) {
                BasicCustomizer.this.lastSelectedCategory = BasicCustomizer.this.findLastSelectedCategory();
                BasicCustomizer.this.dialog.removeWindowListener(this);
                BasicCustomizer.this.dialog.setVisible(false);
                BasicCustomizer.this.dialog.dispose();
                BasicCustomizer.this.dialogCleanup();
            }
            BasicCustomizer.this.dialog = null;
        }
    }
}

