/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.apisupport.project.universe.SourceRootsProvider;
import org.netbeans.modules.apisupport.project.universe.SourceRootsSupport;
import org.netbeans.modules.apisupport.project.universe.TestEntry;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class GlobalSourceForBinaryImpl
implements SourceForBinaryQueryImplementation {
    static boolean quiet = false;

    public SourceForBinaryQuery.Result findSourceRoots(URL uRL) {
        try {
            Object object2 = uRL.toExternalForm();
            Object object3 = null;
            if (((String)object2).startsWith("jar:file:")) {
                FileObject fileObject;
                if (((String)object2).endsWith("/xtest/lib/nbjunit.jar!/")) {
                    object3 = new URL(((String)object2).substring("jar:".length(), ((String)object2).length() - "/xtest/lib/nbjunit.jar!/".length()) + "/xtest/nbjunit/src/");
                } else if (((String)object2).endsWith("/xtest/lib/nbjunit-ide.jar!/")) {
                    object3 = new URL(((String)object2).substring("jar:".length(), ((String)object2).length() - "/xtest/lib/nbjunit-ide.jar!/".length()) + "/xtest/nbjunit/ide/src/");
                } else if (((String)object2).endsWith("/xtest/lib/insanelib.jar!/")) {
                    object3 = new URL(((String)object2).substring("jar:".length(), ((String)object2).length() - "/xtest/lib/insanelib.jar!/".length()) + "/performance/insanelib/src/");
                } else {
                    TestEntry object5 = TestEntry.get(GlobalSourceForBinaryImpl.archiveURLToFile(uRL));
                    if (object5 != null) {
                        object3 = object5.getSrcDir();
                    }
                }
                FileObject fileObject2 = fileObject = object3 != null ? URLMapper.findFileObject((URL)object3) : null;
                if (fileObject != null) {
                    return new SourceForBinaryQuery.Result(){

                        public FileObject[] getRoots() {
                            return new FileObject[]{fileObject};
                        }

                        public void addChangeListener(ChangeListener changeListener) {
                        }

                        public void removeChangeListener(ChangeListener changeListener) {
                        }
                    };
                }
            }
            object2 = null;
            for (NbPlatform nbPlatform : NbPlatform.getPlatforms()) {
                if (uRL.toExternalForm().indexOf(nbPlatform.getDestDir().toURI().toURL().toExternalForm()) == -1) continue;
                object2 = nbPlatform;
                break;
            }
            if (!uRL.getProtocol().equals("jar")) {
                Util.err.log(uRL + " is not an archive file.");
                return null;
            }
            object3 = GlobalSourceForBinaryImpl.archiveURLToFile(uRL);
            FileObject fileObject = FileUtil.toFileObject((File)object3);
            if (fileObject == null) {
                Util.err.log("Cannot found FileObject for " + object3 + "(" + uRL + ")");
                return null;
            }
            if (object2 == null) {
                URL[] uRLArray = ModuleList.getSourceRootsForExternalModule((File)object3);
                if (uRLArray.length > 0) {
                    return new ExtClusterResult(new SourceRootsSupport(uRLArray, null), uRL, fileObject.getName().replace('-', '.'));
                }
                return null;
            }
            return new NbPlatformResult((NbPlatform)object2, uRL, fileObject.getName().replace('-', '.'));
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    private static String resolveSpecialNBSrcPath(URL uRL) throws MalformedURLException {
        String string = uRL.toExternalForm();
        String string2 = null;
        if (string.startsWith("jar:file:")) {
            string2 = string.endsWith("/modules/org-netbeans-modules-nbjunit.jar!/") ? "xtest/nbjunit/src/" : (string.endsWith("/modules/org-netbeans-modules-nbjunit-ide.jar!/") ? "xtest/nbjunit/ide/src/" : (string.endsWith("/modules/ext/insanelib.jar!/") ? "performance/insanelib/src/" : null));
        }
        return string2;
    }

    private static File archiveURLToFile(URL uRL) {
        return new File(URI.create(FileUtil.getArchiveFile((URL)uRL).toExternalForm()));
    }

    public static final class NetBeansSourcesParser {
        private static final Map<File, NetBeansSourcesParser> instances = new HashMap<File, NetBeansSourcesParser>();
        private static final String NBBUILD_ENTRY = "nbbuild/";
        private Map<String, String> cnbToPrjDir;
        private final ZipFile nbSrcZip;
        private final String zipNBRoot;

        public static NetBeansSourcesParser getInstance(File file) throws ZipException, IOException {
            ZipFile zipFile;
            String string;
            NetBeansSourcesParser netBeansSourcesParser = instances.get(file);
            if (netBeansSourcesParser == null && (string = NetBeansSourcesParser.findNBRoot(zipFile = new ZipFile(file))) != null) {
                netBeansSourcesParser = new NetBeansSourcesParser(zipFile, string);
                instances.put(file, netBeansSourcesParser);
            }
            return netBeansSourcesParser;
        }

        NetBeansSourcesParser(ZipFile zipFile, String string) {
            this.nbSrcZip = zipFile;
            this.zipNBRoot = string;
        }

        String findSourceRoot(String string) {
            if (this.cnbToPrjDir == null) {
                try {
                    this.doScanZippedNetBeansOrgSources();
                }
                catch (IOException iOException) {
                    Util.err.notify(16, (Throwable)iOException);
                }
            }
            return this.cnbToPrjDir.get(string);
        }

        private static String findNBRoot(ZipFile zipFile) {
            String string = null;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry;
                String string2;
                ZipEntry zipEntry2 = enumeration.nextElement();
                if (!zipEntry2.isDirectory() || !(string2 = zipEntry2.getName()).equals(NBBUILD_ENTRY) && (!string2.endsWith(NBBUILD_ENTRY) || !string2.substring(string2.indexOf(47) + 1).equals(NBBUILD_ENTRY)) || (zipEntry = zipFile.getEntry(string2 + "nbproject/project.xml")) == null) continue;
                string = string2.substring(0, string2.length() - NBBUILD_ENTRY.length());
                break;
            }
            return string;
        }

        private void doScanZippedNetBeansOrgSources() throws IOException {
            this.cnbToPrjDir = new HashMap<String, String>();
            Enumeration<? extends ZipEntry> enumeration = this.nbSrcZip.entries();
            while (enumeration.hasMoreElements()) {
                String string;
                ZipEntry zipEntry;
                ZipEntry zipEntry2;
                String string2;
                StringTokenizer stringTokenizer;
                ZipEntry zipEntry3 = enumeration.nextElement();
                if (!zipEntry3.isDirectory()) continue;
                String string3 = zipEntry3.getName().substring(0, zipEntry3.getName().length() - 1);
                if (this.zipNBRoot != null && (!string3.startsWith(this.zipNBRoot) || string3.equals(this.zipNBRoot)) || (stringTokenizer = new StringTokenizer(string3, "/")).countTokens() > 3 || ModuleList.EXCLUDED_DIR_NAMES.contains(string2 = string3.substring(string3.lastIndexOf(47) + 1, string3.length())) || (zipEntry2 = this.nbSrcZip.getEntry(zipEntry3.getName() + "src/")) == null || !zipEntry2.isDirectory() || (zipEntry = this.nbSrcZip.getEntry(zipEntry3.getName() + "nbproject/project.xml")) == null || (string = this.parseCNB(zipEntry)) == null) continue;
                this.cnbToPrjDir.put(string, zipEntry3.getName() + "src/");
            }
        }

        private String parseCNB(ZipEntry zipEntry) throws IOException {
            Element element;
            Element element2;
            Document document;
            InputStream inputStream = this.nbSrcZip.getInputStream(zipEntry);
            try {
                document = XMLUtil.parse((InputSource)new InputSource(inputStream), (boolean)false, (boolean)true, null, null);
            }
            catch (SAXException sAXException) {
                throw (IOException)new IOException(zipEntry + ": " + sAXException.toString()).initCause(sAXException);
            }
            finally {
                inputStream.close();
            }
            Element element3 = document.getDocumentElement();
            Element element4 = Util.findElement(element3, "type", "http://www.netbeans.org/ns/project/1");
            String string = null;
            if (Util.findText(element4).equals("org.netbeans.modules.apisupport.project") && (element2 = Util.findElement(element = Util.findElement(element3, "configuration", "http://www.netbeans.org/ns/project/1"), "data", null)) != null) {
                string = Util.findText(Util.findElement(element2, "code-name-base", null));
            }
            return string;
        }
    }

    private static final class NbPlatformResult
    extends SourceRootsProviderResult
    implements PropertyChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final NbPlatform platform;
        private boolean alreadyListening;

        NbPlatformResult(NbPlatform nbPlatform, URL uRL, String string) {
            super(nbPlatform, uRL, string);
            this.platform = nbPlatform;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
            if (!this.alreadyListening) {
                this.platform.addPropertyChangeListener(this);
                this.alreadyListening = true;
            }
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
            if (!this.changeSupport.hasListeners()) {
                this.platform.removePropertyChangeListener(this);
                this.alreadyListening = false;
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("sourceRoots".equals(propertyChangeEvent.getPropertyName())) {
                this.changeSupport.fireChange();
            }
        }

        protected String resolveRelativePath(URL uRL) throws IOException {
            return GlobalSourceForBinaryImpl.resolveSpecialNBSrcPath(this.binaryRoot);
        }
    }

    private static final class ExtClusterResult
    extends SourceRootsProviderResult {
        private ExtClusterResult(SourceRootsSupport sourceRootsSupport, URL uRL, String string) {
            super(sourceRootsSupport, uRL, string);
        }

        protected String resolveRelativePath(URL uRL) throws IOException {
            EditableProperties editableProperties;
            String string;
            File file = new File(URI.create(uRL.toExternalForm()));
            File file2 = new File(file, "src");
            if (file2.exists()) {
                return "src/";
            }
            File file3 = new File(file, "nbproject/project.properties");
            if (file3.exists() && (string = (String)(editableProperties = Util.loadProperties(FileUtil.toFileObject((File)file3))).get((Object)("project." + this.cnb))) != null) {
                return string + "/src/";
            }
            return null;
        }
    }

    private static abstract class SourceRootsProviderResult
    implements SourceForBinaryQuery.Result {
        private SourceRootsProvider srp;
        final String cnb;
        final URL binaryRoot;

        SourceRootsProviderResult(SourceRootsProvider sourceRootsProvider, URL uRL, String string) {
            this.srp = sourceRootsProvider;
            this.cnb = string;
            this.binaryRoot = uRL;
        }

        public FileObject[] getRoots() {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            try {
                for (URL uRL : this.srp.getSourceRoots()) {
                    Object object;
                    Object object2;
                    Object object3;
                    if (uRL.getProtocol().equals("jar")) {
                        URL uRL2;
                        FileObject fileObject;
                        object3 = GlobalSourceForBinaryImpl.archiveURLToFile(uRL);
                        if (!((File)object3).exists()) continue;
                        try {
                            object2 = NetBeansSourcesParser.getInstance((File)object3);
                        }
                        catch (ZipException zipException) {
                            if (quiet) continue;
                            Util.err.annotate((Throwable)zipException, 0, object3 + " does not seem to be a valid ZIP file.", null, null, null);
                            Util.err.notify(1, (Throwable)zipException);
                            continue;
                        }
                        if (object2 == null || (object = ((NetBeansSourcesParser)object2).findSourceRoot(this.cnb)) == null || (fileObject = URLMapper.findFileObject((URL)(uRL2 = new URL(uRL, (String)object)))) == null) continue;
                        arrayList.add(fileObject);
                        continue;
                    }
                    object3 = this.resolveRelativePath(uRL);
                    if (object3 == null || (object = URLMapper.findFileObject((URL)(object2 = new URL(uRL, (String)object3)))) == null) continue;
                    arrayList.add((FileObject)object);
                }
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
            return arrayList.toArray(new FileObject[arrayList.size()]);
        }

        protected abstract String resolveRelativePath(URL var1) throws IOException;

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }
}

