/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.cpu.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.netbeans.modules.dlight.indicators.graph.GraphConfig;
import org.netbeans.modules.dlight.indicators.graph.GraphDescriptor;
import org.netbeans.modules.dlight.indicators.graph.GraphPanel;
import org.netbeans.modules.dlight.indicators.graph.Legend;
import org.netbeans.modules.dlight.indicators.graph.PercentageGraph;
import org.openide.util.NbBundle;

public class CpuIndicatorPanel {
    private static final Color COLOR_SYS = GraphConfig.COLOR_3;
    private static final Color COLOR_USR = GraphConfig.COLOR_1;
    private static final GraphDescriptor SYS_DESCRIPTOR = new GraphDescriptor(COLOR_SYS, NbBundle.getMessage(CpuIndicatorPanel.class, (String)"graph.description.system"), GraphDescriptor.Kind.REL_SURFACE);
    private static final GraphDescriptor USR_DESCRIPTOR = new GraphDescriptor(COLOR_USR, NbBundle.getMessage(CpuIndicatorPanel.class, (String)"graph.description.user"), GraphDescriptor.Kind.REL_SURFACE);
    private static final String TIME_DETAIL_ID = "elapsed-time";
    private static final int SECONDS_PER_MINUTE = 60;
    private final PercentageGraph graph = CpuIndicatorPanel.createGraph();
    private final Legend legend = CpuIndicatorPanel.createLegend();
    private final GraphPanel<PercentageGraph, Legend> panel = new GraphPanel(CpuIndicatorPanel.getTitle(), (JComponent)this.graph, (JComponent)this.legend, null, this.graph.getVerticalAxis());

    CpuIndicatorPanel() {
    }

    public GraphPanel getPanel() {
        return this.panel;
    }

    private static String getTitle() {
        return NbBundle.getMessage(CpuIndicatorPanel.class, (String)"indicator.title");
    }

    private static PercentageGraph createGraph() {
        PercentageGraph percentageGraph = new PercentageGraph(new GraphDescriptor[]{SYS_DESCRIPTOR, USR_DESCRIPTOR});
        percentageGraph.setBorder(BorderFactory.createLineBorder(GraphConfig.BORDER_COLOR));
        Dimension dimension = new Dimension(80, 60);
        percentageGraph.setMinimumSize(dimension);
        percentageGraph.setPreferredSize(dimension);
        Dimension dimension2 = new Dimension(30, 80);
        percentageGraph.getVerticalAxis().setMinimumSize(dimension2);
        percentageGraph.getVerticalAxis().setPreferredSize(dimension2);
        return percentageGraph;
    }

    private static Legend createLegend() {
        Legend legend = new Legend(Arrays.asList(USR_DESCRIPTOR, SYS_DESCRIPTOR), Collections.singletonMap(TIME_DETAIL_ID, NbBundle.getMessage(CpuIndicatorPanel.class, (String)"label.time")));
        legend.updateDetail(TIME_DETAIL_ID, CpuIndicatorPanel.formatTime(0));
        return legend;
    }

    void addData(int n, int n2) {
        this.graph.addData(new int[]{n, n2});
    }

    void setSysValue(int n) {
    }

    void setUsrValue(int n) {
    }

    void setTime(int n) {
        this.legend.updateDetail(TIME_DETAIL_ID, CpuIndicatorPanel.formatTime(n));
    }

    private static String formatTime(int n) {
        return String.format("%d:%02d", n / 60, n % 60);
    }
}

