/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.spi.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.modules.profiler.selector.spi.nodes.ClassNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.IconResource;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackageNode
extends ContainerNode {
    public static final String DEFAULT_NAME = "<default>";
    public static final Comparator COMPARATOR = new Comparator<PackageNode>(){

        @Override
        public int compare(PackageNode packageNode, PackageNode packageNode2) {
            if (packageNode.getNodeName().equals(PackageNode.DEFAULT_NAME)) {
                return -1;
            }
            return packageNode.toString().compareTo(packageNode2.toString());
        }
    };
    protected static final Logger LOGGER = Logger.getLogger(PackageNode.class.getName());

    public PackageNode(String string, ContainerNode containerNode) {
        super(string, PackageNode.stripName(PackageNode.defaultizeName(string)), (Icon)IconResource.PACKAGE_ICON, containerNode);
    }

    @Override
    protected final SelectorChildren getChildren() {
        return new PackageChildren();
    }

    protected abstract List<ClassNode> getContainedClasses();

    protected abstract List<PackageNode> getContainedPackages();

    private static String defaultizeName(String string) {
        return string == null || string.length() == 0 ? DEFAULT_NAME : string;
    }

    private static String stripName(String string) {
        int n = string.lastIndexOf(46);
        if (n > -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PackageChildren
    extends SelectorChildren<PackageNode> {
        private PackageChildren() {
        }

        @Override
        protected List<SelectorNode> prepareChildren(PackageNode packageNode) {
            ArrayList<SelectorNode> arrayList = new ArrayList<SelectorNode>();
            List<PackageNode> list = this.getSubpackages(packageNode);
            List<ClassNode> list2 = this.getClasses(packageNode);
            arrayList.addAll(list);
            arrayList.addAll(list2);
            return arrayList;
        }

        private List<ClassNode> getClasses(PackageNode packageNode) {
            List<ClassNode> list = packageNode.getContainedClasses();
            Collections.sort(list, ClassNode.COMPARATOR);
            return list;
        }

        private List<PackageNode> getSubpackages(PackageNode packageNode) {
            List<PackageNode> list = packageNode.getContainedPackages();
            Collections.sort(list, COMPARATOR);
            return list;
        }
    }
}

