/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.autoupdate.updateprovider.NetworkAccess;

public class DownloadListener
implements NetworkAccess.NetworkListener {
    private Exception storedException;
    private File cache;
    private File temp;
    private URL sourceUrl;
    private boolean allowZeroLength;
    private Logger err = Logger.getLogger(this.getClass().getName());

    public DownloadListener(URL uRL, File file, File file2, boolean bl) {
        this.sourceUrl = uRL;
        this.cache = file;
        this.temp = file2;
        this.allowZeroLength = bl;
    }

    public void streamOpened(InputStream inputStream, int n) {
        this.err.log(Level.FINE, "Successfully started reading URI " + this.sourceUrl);
        try {
            this.doCopy(this.sourceUrl, inputStream, this.cache, this.temp, n);
        }
        catch (IOException iOException) {
            this.storeException(iOException);
        }
    }

    public void accessCanceled() {
        this.err.log(Level.FINE, "Processing " + this.sourceUrl + " was cancelled.");
        this.storeException(new IOException("Processing " + this.sourceUrl + " was cancelled."));
    }

    public void accessTimeOut() {
        this.err.log(Level.FINE, "Timeout when processing " + this.sourceUrl);
        this.storeException(new IOException("Timeout when processing " + this.sourceUrl));
    }

    public void notifyException(Exception exception) {
        this.err.log(Level.INFO, "Reading URL " + this.sourceUrl + " failed (" + exception + ")");
        this.storeException(exception);
    }

    public void notifyException() throws IOException {
        if (this.isExceptionStored()) {
            throw new IOException(this.getStoredException().getLocalizedMessage());
        }
    }

    private boolean isExceptionStored() {
        return this.storedException != null;
    }

    private void storeException(Exception exception) {
        this.storedException = exception;
    }

    private Exception getStoredException() {
        return this.storedException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopy(URL uRL, InputStream inputStream, File file, File file2, int n) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        int n2 = 0;
        int n3 = 0;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray)) != -1) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
                n3 += n2;
            }
            inputStream.close();
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
            bufferedOutputStream = null;
            if (n != -1 && n != n3) {
                this.err.log(Level.INFO, "Content length was reported as " + n + " bytes, but read " + n3 + " bytes from " + uRL);
                throw new IOException("unexpected closed connection to " + uRL);
            }
            if (n3 == 0 && !this.allowZeroLength) {
                this.err.log(Level.INFO, "Connection content length was " + n + " bytes (read " + n3 + "bytes), expected file size can`t be that size - likely server with file at " + uRL + " is temporary down");
                throw new IOException("zero sized file reported at " + uRL);
            }
            DownloadListener downloadListener = this;
            synchronized (downloadListener) {
                if (file.exists() && !file.delete()) {
                    block23: {
                        this.err.log(Level.INFO, "Cannot delete cache " + file);
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            if ($assertionsDisabled) break block23;
                            throw new AssertionError((Object)interruptedException);
                        }
                    }
                    file.delete();
                }
            }
            this.err.log(Level.INFO, "Read " + n3 + " bytes from file at " + uRL);
            if (file2.length() == 0L) {
                this.err.log(Level.INFO, "Temp cache size is zero bytes");
            }
            if (!file2.renameTo(file)) {
                this.err.log(Level.INFO, "Cannot rename temp " + file2 + " to cache " + file);
            }
            if (file.exists() && file.length() == 0L) {
                this.err.log(Level.INFO, "Final cache size is zero bytes");
            }
        }
        catch (IOException iOException) {
            this.err.log(Level.INFO, "Writing content of URL " + uRL + " failed.", iOException);
            throw iOException;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (bufferedOutputStream != null) {
                    ((OutputStream)bufferedOutputStream).flush();
                    ((OutputStream)bufferedOutputStream).close();
                }
            }
            catch (IOException iOException) {
                this.err.log(Level.INFO, "Closing streams failed.", iOException);
            }
        }
    }
}

