/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.hints.pom.ParentVersionErrorCustomizer;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Parent;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentVersionError
implements POMErrorFixProvider {
    private Configuration configuration = new Configuration("ParentVersionError", NbBundle.getMessage(ParentVersionError.class, (String)"TIT_ParentVersionError"), NbBundle.getMessage(ParentVersionError.class, (String)"DESC_ParentVersionError"), true, Configuration.HintSeverity.WARNING);
    static final String PROP_SOURCES = "sources";
    static final String PROP_SNAPSHOT = "snapshot";

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel pOMModel, Project project) {
        Object object;
        DefaultArtifactVersion defaultArtifactVersion;
        Object object2;
        assert (pOMModel != null);
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        if (project == null) {
            return null;
        }
        Parent parent = pOMModel.getProject().getPomParent();
        if (parent == null) {
            return arrayList;
        }
        boolean bl = this.getConfiguration().getPreferences().getBoolean(PROP_SOURCES, true);
        boolean bl2 = this.getConfiguration().getPreferences().getBoolean(PROP_SNAPSHOT, false);
        String string = parent.getVersion();
        String string2 = parent.getRelativePath();
        if (string2 == null) {
            string2 = ".." + File.separator;
        }
        if (string2.endsWith("pom.xml")) {
            string2 = string2.substring(0, string2.length() - "pom.xml".length());
        }
        File file = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)string2);
        String string3 = null;
        boolean bl3 = false;
        if (bl && file.exists()) {
            try {
                object2 = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
                if (object2 != null && (defaultArtifactVersion = (NbMavenProject)object2.getLookup().lookup(NbMavenProject.class)) != null) {
                    string3 = defaultArtifactVersion.getMavenProject().getVersion();
                    bl = true;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
        }
        if (!bl || string3 == null) {
            object2 = RepositoryQueries.getVersions((String)parent.getGroupId(), (String)parent.getArtifactId(), (RepositoryInfo[])new RepositoryInfo[0]);
            defaultArtifactVersion = new DefaultArtifactVersion(string);
            object = object2.iterator();
            while (object.hasNext()) {
                NBVersionInfo nBVersionInfo = (NBVersionInfo)object.next();
                DefaultArtifactVersion defaultArtifactVersion2 = new DefaultArtifactVersion(nBVersionInfo.getVersion());
                if (!bl2 && nBVersionInfo.getVersion().contains("SNAPSHOT") || defaultArtifactVersion.compareTo((Object)defaultArtifactVersion2) >= 0) continue;
                defaultArtifactVersion = defaultArtifactVersion2;
            }
            string3 = defaultArtifactVersion.toString();
        }
        if (string3 != null && !string3.equals(string)) {
            int n = parent.findChildElementPosition(pOMModel.getPOMQNames().VERSION.getQName());
            defaultArtifactVersion = NbEditorUtilities.getLine((Document)pOMModel.getBaseDocument(), (int)n, (boolean)false);
            object = bl3 ? NbBundle.getMessage(ParentVersionError.class, (String)"TXT_ParentVersionError", (Object)string3) : NbBundle.getMessage(ParentVersionError.class, (String)"TXT_ParentVersionError2", (Object)string3);
            arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.configuration.getSeverity(this.configuration.getPreferences()).toEditorSeverity(), (String)object, Collections.singletonList(new SynchronizeFix(parent, string3, bl3)), (Document)pOMModel.getBaseDocument(), (int)(defaultArtifactVersion.getLineNumber() + 1)));
        }
        return arrayList;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return new ParentVersionErrorCustomizer(preferences);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    private static class SynchronizeFix
    implements Fix {
        private Parent parent;
        private String version;
        private String message;

        SynchronizeFix(Parent parent, String string, boolean bl) {
            this.parent = parent;
            this.version = string;
            this.message = bl ? NbBundle.getMessage(ParentVersionError.class, (String)"TEXT_ParentVersionFix", (Object)string) : NbBundle.getMessage(ParentVersionError.class, (String)"TEXT_ParentVersionFix2", (Object)string);
        }

        public String getText() {
            return this.message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChangeInfo implement() throws Exception {
            ChangeInfo changeInfo = new ChangeInfo();
            POMModel pOMModel = this.parent.getModel();
            if (!pOMModel.getState().equals((Object)Model.State.VALID)) {
                return changeInfo;
            }
            pOMModel.startTransaction();
            try {
                this.parent.setVersion(this.version);
            }
            finally {
                pOMModel.endTransaction();
            }
            return changeInfo;
        }
    }
}

