/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.apache.maven.model.DependencyManagement;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.text.Line;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverrideDependencyManagementError
implements POMErrorFixProvider {
    private Configuration configuration = new Configuration("OverrideDependencyManagementError", NbBundle.getMessage(OverrideDependencyManagementError.class, (String)"TIT_OverrideDependencyManagementError"), NbBundle.getMessage(OverrideDependencyManagementError.class, (String)"DESC_OverrideDependencyManagementError"), true, Configuration.HintSeverity.WARNING);

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel pOMModel, Project project) {
        assert (pOMModel != null);
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        if (project == null) {
            return arrayList;
        }
        Map<String, String> map = this.collectManaged(project);
        if (map.size() == 0) {
            return arrayList;
        }
        this.checkDependencyList(pOMModel.getProject().getDependencies(), pOMModel, arrayList, map);
        List list = pOMModel.getProject().getProfiles();
        if (list != null) {
            for (Profile profile : list) {
                this.checkDependencyList(profile.getDependencies(), pOMModel, arrayList, map);
            }
        }
        return arrayList;
    }

    private void checkDependencyList(List<Dependency> list, POMModel pOMModel, List<ErrorDescription> list2, Map<String, String> map) {
        if (list != null) {
            for (Dependency dependency : list) {
                String string = dependency.getVersion();
                if (string == null) continue;
                String string2 = dependency.getArtifactId();
                String string3 = dependency.getGroupId();
                String string4 = string3 + ":" + string2;
                if (!map.keySet().contains(string4)) continue;
                int n = dependency.findChildElementPosition(pOMModel.getPOMQNames().VERSION.getQName());
                Line line = NbEditorUtilities.getLine((Document)pOMModel.getBaseDocument(), (int)n, (boolean)false);
                String string5 = map.get(string4);
                list2.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.configuration.getSeverity(this.configuration.getPreferences()).toEditorSeverity(), (String)NbBundle.getMessage(OverrideDependencyManagementError.class, (String)"TXT_OverrideDependencyManagementError", (Object)string5), Collections.singletonList(new OverrideFix(dependency)), (Document)pOMModel.getBaseDocument(), (int)(line.getLineNumber() + 1)));
            }
        }
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    private Map<String, String> collectManaged(Project project) {
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (nbMavenProject == null) {
            return hashMap;
        }
        DependencyManagement dependencyManagement = nbMavenProject.getMavenProject().getDependencyManagement();
        if (dependencyManagement != null) {
            List list = dependencyManagement.getDependencies();
            for (org.apache.maven.model.Dependency dependency : list) {
                hashMap.put(dependency.getGroupId() + ":" + dependency.getArtifactId(), dependency.getVersion());
            }
        }
        return hashMap;
    }

    private static class OverrideFix
    implements Fix {
        private Dependency dependency;

        OverrideFix(Dependency dependency) {
            this.dependency = dependency;
        }

        public String getText() {
            return NbBundle.getMessage(OverrideDependencyManagementError.class, (String)"TEXT_OverrideDependencyFix");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChangeInfo implement() throws Exception {
            ChangeInfo changeInfo = new ChangeInfo();
            POMModel pOMModel = this.dependency.getModel();
            if (!pOMModel.getState().equals((Object)Model.State.VALID)) {
                return changeInfo;
            }
            pOMModel.startTransaction();
            try {
                this.dependency.setVersion(null);
            }
            finally {
                pOMModel.endTransaction();
            }
            return changeInfo;
        }
    }
}

