/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.logging.Logger;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.ErrWriter;
import org.netbeans.core.output2.FileMapStorage;
import org.netbeans.core.output2.HeapStorage;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.Storage;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

class OutWriter
extends PrintWriter {
    private boolean trouble = false;
    private NbIO owner;
    private boolean disposed = false;
    private static final boolean USE_HEAP_STORAGE = Boolean.getBoolean("nb.output.heap") || Utilities.getOperatingSystem() == 4 || Utilities.getOperatingSystem() == 2;
    static String lineSeparator = System.getProperty("line.separator");
    private Storage storage;
    private AbstractLines lines = new LinesImpl();
    static boolean lowDiskSpace = false;
    private int lineStart = -1;
    private int lineLength = 0;
    private int errorCount = 0;
    private boolean closed = false;
    private static final int writeBuffSize = 16384;
    private final String tabReplacement = "        ";

    OutWriter(NbIO nbIO) {
        this();
        this.owner = nbIO;
    }

    OutWriter() {
        super(new DummyWriter());
    }

    Storage getStorage() {
        if (this.disposed) {
            throw new IllegalStateException("Output file has been disposed!");
        }
        if (this.storage == null) {
            this.storage = USE_HEAP_STORAGE || lowDiskSpace ? new HeapStorage() : new FileMapStorage();
        }
        return this.storage;
    }

    boolean hasStorage() {
        return this.storage != null;
    }

    boolean isDisposed() {
        return this.disposed;
    }

    boolean isEmpty() {
        return this.storage == null ? true : this.storage.size() == 0;
    }

    public String toString() {
        return "OutWriter@" + System.identityHashCode(this) + " for " + this.owner + " closed ";
    }

    private void handleException(Exception exception) {
        this.setError();
        if (Controller.LOG) {
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            Controller.log("EXCEPTION: " + exception.getClass() + exception.getMessage());
            for (int i = 1; i < stackTraceElementArray.length; ++i) {
                Controller.log(stackTraceElementArray[i].toString());
            }
        }
        if (this.errorCount++ < 3) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public synchronized void write(ByteBuffer byteBuffer, boolean bl) {
        if (this.checkError()) {
            return;
        }
        this.closed = false;
        int n = -1;
        try {
            n = this.getStorage().write(byteBuffer);
        }
        catch (AsynchronousCloseException asynchronousCloseException) {
            this.onWriteException();
        }
        catch (IOException iOException) {
            if (iOException.getMessage().indexOf("There is not enough space on the disk") != -1) {
                lowDiskSpace = true;
                String string = NbBundle.getMessage(OutWriter.class, (String)"MSG_DiskSpace", (Object)this.storage);
                Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string);
                Exceptions.printStackTrace((Throwable)iOException);
                this.setError();
                this.storage.dispose();
            }
            Exceptions.printStackTrace((Throwable)iOException);
            this.onWriteException();
        }
        if (this.checkError()) {
            return;
        }
        int n2 = byteBuffer.limit();
        this.lineLength += n2;
        if (n >= 0 && this.lineStart == -1) {
            this.lineStart = n;
        }
        this.lines.lineUpdated(this.lineStart, this.lineLength, bl);
        if (bl) {
            this.lineStart = -1;
            this.lineLength = 0;
        }
        if (this.owner != null && this.owner.isStreamClosed()) {
            this.owner.setStreamClosed(false);
            this.lines.fire();
        }
    }

    void onWriteException() {
        ErrWriter errWriter;
        this.trouble = true;
        if (Controller.LOG) {
            Controller.log(this + " Close due to termination");
        }
        if ((errWriter = this.owner.writer().err()) != null) {
            errWriter.closed = true;
        }
        this.owner.setStreamClosed(true);
        this.close();
    }

    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        if (Controller.LOG) {
            Controller.log(this + ": OutWriter.dispose - owner is " + (this.owner == null ? "null" : this.owner.getName()));
        }
        this.clearListeners();
        if (this.storage != null) {
            this.lines.onDispose(this.storage.size());
            this.storage.dispose();
            this.storage = null;
        }
        if (Controller.LOG) {
            Controller.log(this + ": Setting owner to null, trouble to true, dirty to false.  This OutWriter is officially dead.");
        }
        this.owner = null;
        this.disposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearListeners() {
        if (Controller.LOG) {
            Controller.log(this + ": Sending outputLineCleared to all listeners");
        }
        if (this.owner == null) {
            return;
        }
        OutWriter outWriter = this;
        synchronized (outWriter) {
            if (this.lines.hasHyperlinks()) {
                int[] nArray = this.lines.allListenerLines();
                Controller.ControllerOutputEvent controllerOutputEvent = new Controller.ControllerOutputEvent(this.owner, 0);
                for (int i = 0; i < nArray.length; ++i) {
                    OutputListener outputListener = this.lines.getListenerForLine(nArray[i]);
                    if (Controller.LOG) {
                        Controller.log("Clearing listener " + outputListener);
                    }
                    controllerOutputEvent.setLine(nArray[i]);
                    if (outputListener != null) {
                        outputListener.outputLineCleared((OutputEvent)controllerOutputEvent);
                        continue;
                    }
                    Logger.getAnonymousLogger().warning("issue #56826 - There was a null OutputListener on line:" + nArray[i]);
                }
            } else if (Controller.LOG) {
                Controller.log(this + ": No listeners to clear");
            }
        }
    }

    public synchronized boolean isClosed() {
        if (this.checkError() || this.storage == null || this.storage.isClosed()) {
            return true;
        }
        return this.closed;
    }

    public Lines getLines() {
        return this.lines;
    }

    public synchronized void close() {
        this.closed = true;
        try {
            if (this.storage != null) {
                this.storage.close();
            }
            this.lines.fire();
        }
        catch (IOException iOException) {
            this.onWriteException();
        }
    }

    public synchronized void println(String string) {
        this.doWrite(string, 0, string.length());
        this.println();
    }

    public synchronized void flush() {
        if (this.checkError()) {
            return;
        }
        try {
            this.getStorage().flush();
            this.lines.fire();
        }
        catch (IOException iOException) {
            this.onWriteException();
        }
    }

    public boolean checkError() {
        return this.disposed || this.trouble;
    }

    public synchronized void write(int n) {
        this.doWrite(new String(new char[]{(char)n}), 0, 1);
    }

    public synchronized void write(char[] cArray, int n, int n2) {
        this.doWrite(new CharArrayWrapper(cArray), n, n2);
    }

    public synchronized int doWrite(CharSequence charSequence, int n, int n2) {
        if (this.checkError() || n2 == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            boolean bl = false;
            ByteBuffer byteBuffer = this.getStorage().getWriteBuffer(32768);
            CharBuffer charBuffer = byteBuffer.asCharBuffer();
            for (int i = n; i < n + n2; ++i) {
                char c;
                if (charBuffer.position() + "        ".length() >= 16384) {
                    this.write((ByteBuffer)byteBuffer.position(charBuffer.position() * 2), false);
                    bl = true;
                }
                if (bl) {
                    byteBuffer = this.getStorage().getWriteBuffer(32768);
                    charBuffer = byteBuffer.asCharBuffer();
                    bl = false;
                }
                if ((c = charSequence.charAt(i)) == '\t') {
                    charBuffer.put("        ");
                    continue;
                }
                if (c == '\n') {
                    charBuffer.put(c);
                    this.write((ByteBuffer)byteBuffer.position(charBuffer.position() * 2), true);
                    bl = true;
                    ++n3;
                    continue;
                }
                charBuffer.put(c);
            }
            if (!bl) {
                this.write((ByteBuffer)byteBuffer.position(charBuffer.position() * 2), false);
            }
        }
        catch (IOException iOException) {
            this.onWriteException();
        }
        this.lines.delayedFire();
        return n3;
    }

    public synchronized void write(char[] cArray) {
        this.doWrite(new CharArrayWrapper(cArray), 0, cArray.length);
    }

    public synchronized void println() {
        this.doWrite(lineSeparator, 0, lineSeparator.length());
    }

    public synchronized void write(String string, int n, int n2) {
        this.doWrite(string, n, n2);
    }

    public synchronized void write(String string) {
        this.doWrite(string, 0, string.length());
    }

    public synchronized void println(String string, OutputListener outputListener) {
        this.println(string, outputListener, false);
    }

    public synchronized void println(String string, OutputListener outputListener, boolean bl) {
        this.print(string, outputListener, bl, null, true);
    }

    synchronized void print(CharSequence charSequence, OutputListener outputListener, boolean bl, Color color, boolean bl2) {
        int n = this.doWrite(charSequence, 0, charSequence.length());
        if (bl2) {
            this.println();
            ++n;
        }
        if (this.checkError()) {
            return;
        }
        int n2 = this.lines.getLineCount() - 1;
        for (int i = n2 - n; i < n2; ++i) {
            if (outputListener != null) {
                this.lines.addListener(i, outputListener, bl);
            }
            if (color == null) continue;
            this.lines.setColor(i, color);
        }
    }

    private class LinesImpl
    extends AbstractLines {
        LinesImpl() {
        }

        protected Storage getStorage() {
            return OutWriter.this.getStorage();
        }

        protected boolean isDisposed() {
            return OutWriter.this.disposed;
        }

        public Object readLock() {
            return OutWriter.this;
        }

        public boolean isGrowing() {
            return !OutWriter.this.isClosed();
        }

        protected void handleException(Exception exception) {
            OutWriter.this.handleException(exception);
        }
    }

    static class DummyWriter
    extends Writer {
        DummyWriter() {
            super(new Object());
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
        }
    }

    class CharArrayWrapper
    implements CharSequence {
        private char[] arr;
        private int off;
        private int len;

        public CharArrayWrapper(char[] cArray) {
            this(cArray, 0, cArray.length);
        }

        public CharArrayWrapper(char[] cArray, int n, int n2) {
            this.arr = cArray;
            this.off = n;
            this.len = n2;
        }

        public char charAt(int n) {
            return this.arr[this.off + n];
        }

        public int length() {
            return this.len;
        }

        public CharSequence subSequence(int n, int n2) {
            return new CharArrayWrapper(this.arr, this.off + n, n2 - n);
        }

        public String toString() {
            return new String(this.arr, this.off, this.len);
        }
    }
}

