/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.OutputDocument;
import org.openide.util.NbBundle;

class ExtPlainView
extends PlainView {
    private final Segment SEGMENT = new Segment();
    private final int MAXLINELEN = 4096;
    private final String lineTooLong = NbBundle.getMessage(ExtPlainView.class, (String)"MSG_LINE_TOO_LONG");
    private static final boolean antialias = Boolean.getBoolean("swing.aatext") || "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static Map hintsMap = null;
    Font font;
    int tabBase;
    int longestLineLength;
    Element longestLine;

    static final Map getHints() {
        if (hintsMap == null && (hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
            hintsMap = new HashMap();
            if (antialias) {
                hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        return hintsMap;
    }

    ExtPlainView(Element element) {
        super(element);
    }

    public void paint(Graphics graphics, Shape shape) {
        ((Graphics2D)graphics).addRenderingHints(ExtPlainView.getHints());
        super.paint(graphics, shape);
    }

    Segment getSegment() {
        return SwingUtilities.isEventDispatchThread() ? this.SEGMENT : new Segment();
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        Document document = this.getDocument();
        if (document instanceof OutputDocument) {
            Segment segment = this.getSegment();
            if (!this.getText(n3, n4 - n3, segment)) {
                return n;
            }
            Lines lines = ((OutputDocument)document).getLines();
            int n5 = lines.getLineAt(n3);
            graphics.setColor(lines.getColorForLine(n5));
            int n6 = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n3);
            if (lines.isHyperlink(n5)) {
                this.underline(graphics, segment, n, n3, n2);
            }
            return n6;
        }
        return super.drawUnselectedText(graphics, n, n2, n3, n4);
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        Document document = this.getDocument();
        if (document instanceof OutputDocument) {
            Segment segment = this.getSegment();
            if (!this.getText(n3, n4 - n3, segment)) {
                return n;
            }
            Lines lines = ((OutputDocument)document).getLines();
            int n5 = lines.getLineAt(n3);
            graphics.setColor(lines.getColorForLine(n5));
            int n6 = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n3);
            if (lines.isHyperlink(n5)) {
                this.underline(graphics, segment, n, n3, n2);
            }
            return n6;
        }
        return super.drawUnselectedText(graphics, n, n2, n3, n4);
    }

    boolean getText(int n, int n2, Segment segment) throws BadLocationException {
        Document document = this.getDocument();
        Element element = this.getElement();
        int n3 = element.getElementIndex(n);
        Element element2 = element.getElement(n3);
        int n4 = element2.getStartOffset();
        int n5 = element2.getEndOffset() - 1 - n4;
        int n6 = Math.min(n2, n4 + 4096 - n);
        if (n6 <= 0) {
            segment.count = 0;
            return false;
        }
        document.getText(n, n6, segment);
        if (n5 > 4096 && n + n2 > n4 + 4096 - this.lineTooLong.length()) {
            int n7 = n - (n4 + 4096 - this.lineTooLong.length());
            int n8 = n7 < 0 ? 0 : n7;
            int n9 = n7 < 0 ? -n7 : 0;
            for (int i = n8; i < this.lineTooLong.length() && n9 + i - n8 < segment.array.length; ++i) {
                segment.array[n9 + i - n8] = this.lineTooLong.charAt(i);
            }
        }
        return true;
    }

    private void underline(Graphics graphics, Segment segment, int n, int n2, int n3) {
        int n4;
        char[] cArray = segment.array;
        int n5 = segment.offset + segment.count;
        int n6 = 0;
        for (n4 = segment.offset; n4 < n5 && Character.isWhitespace(cArray[n4]); ++n4) {
            ++n6;
        }
        n4 = Utilities.getTabbedTextWidth(segment, this.metrics, this.tabBase, (TabExpander)this, n2);
        segment.offset += n6;
        segment.count -= n6;
        int n7 = Utilities.getTabbedTextWidth(segment, this.metrics, this.tabBase, (TabExpander)this, n2 + n6);
        int n8 = graphics.getFontMetrics().getDescent() - 1;
        graphics.drawLine(n + n4 - n7, n3 + n8, n + n4, n3 + n8);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Element element = this.getElement();
        int n2 = element.getElementIndex(n);
        Rectangle rectangle = this.lineToRect(shape, n2);
        this.tabBase = rectangle.x;
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        Segment segment = this.getSegment();
        this.getText(n3, n - n3, segment);
        int n4 = Utilities.getTabbedTextWidth(segment, this.metrics, this.tabBase, (TabExpander)this, n3);
        rectangle.x += n4;
        rectangle.width = 1;
        rectangle.height = this.metrics.getHeight();
        return rectangle;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Document document = this.getDocument();
        if (!(document instanceof Document)) {
            return super.viewToModel(f, f2, shape, biasArray);
        }
        Rectangle rectangle = shape.getBounds();
        int n = (int)f;
        int n2 = (int)f2;
        if (n2 < rectangle.y) {
            return this.getStartOffset();
        }
        if (n2 > rectangle.y + rectangle.height) {
            return this.getEndOffset() - 1;
        }
        Element element = document.getDefaultRootElement();
        int n3 = Math.abs((n2 - rectangle.y) / this.metrics.getHeight());
        if (n3 >= element.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element element2 = element.getElement(n3);
        if (n < rectangle.x) {
            return element2.getStartOffset();
        }
        if (n > rectangle.x + rectangle.width) {
            return element2.getEndOffset() - 1;
        }
        try {
            int n4 = element2.getStartOffset();
            int n5 = element2.getEndOffset() - 1;
            Segment segment = this.getSegment();
            this.getText(n4, n5 - n4, segment);
            this.tabBase = rectangle.x;
            int n6 = n4 + Utilities.getTabbedTextOffset(segment, this.metrics, this.tabBase, n, this, n4);
            return n6;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public float getPreferredSpan(int n) {
        if (n == 1) {
            return super.getPreferredSpan(n);
        }
        return this.longestLineLength + 1;
    }

    protected void calcLongestLineLength() {
        Container container = this.getContainer();
        this.font = container.getFont();
        this.metrics = container.getFontMetrics(this.font);
        Element element = this.getElement();
        int n = element.getElementCount();
        this.longestLineLength = 0;
        for (int i = 0; i < n; ++i) {
            Element element2 = element.getElement(i);
            int n2 = this.getLineWidth(element2);
            if (n2 <= this.longestLineLength) continue;
            this.longestLineLength = n2;
            this.longestLine = element2;
        }
    }

    protected void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        if (this.font != font) {
            this.calcLongestLineLength();
        }
    }

    protected int getLineWidth(Element element) {
        int n;
        int n2 = element.getStartOffset();
        int n3 = element.getEndOffset() - 1;
        Segment segment = this.getSegment();
        try {
            this.getText(n2, n3 - n2, segment);
            n = Utilities.getTabbedTextWidth(segment, this.metrics, this.tabBase, (TabExpander)this, n2);
        }
        catch (BadLocationException badLocationException) {
            n = 0;
        }
        return n;
    }

    protected void updateDamage(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element[] elementArray;
        Document document = this.getDocument();
        if (!(document instanceof Document)) {
            super.updateDamage(documentEvent, shape, viewFactory);
            return;
        }
        Container container = this.getContainer();
        this.updateMetrics();
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        Element[] elementArray2 = elementChange != null ? elementChange.getChildrenAdded() : null;
        Element[] elementArray3 = elementArray = elementChange != null ? elementChange.getChildrenRemoved() : null;
        if (elementArray2 != null && elementArray2.length > 0 || elementArray != null && elementArray.length > 0) {
            int n;
            if (elementArray2 != null) {
                for (n = 0; n < elementArray2.length; ++n) {
                    int n2 = this.getLineWidth(elementArray2[n]);
                    if (n2 <= this.longestLineLength) continue;
                    this.longestLineLength = n2;
                    this.longestLine = elementArray2[n];
                }
            }
            if (elementArray != null) {
                for (n = 0; n < elementArray.length; ++n) {
                    if (elementArray[n] != this.longestLine) continue;
                    this.calcLongestLineLength();
                    break;
                }
            }
            this.preferenceChanged(null, true, true);
            container.repaint();
        } else {
            Element element2 = this.getElement();
            int n = element2.getElementIndex(documentEvent.getOffset());
            this.damageLineRange(n, n, shape, container);
            if (documentEvent.getType() == DocumentEvent.EventType.INSERT) {
                Element element3 = element2.getElement(n);
                int n3 = this.getLineWidth(element3);
                if (element3 == this.longestLine) {
                    this.preferenceChanged(null, true, false);
                } else if (n3 > this.longestLineLength) {
                    this.longestLineLength = n3;
                    this.longestLine = element3;
                    this.preferenceChanged(null, true, false);
                }
            } else if (documentEvent.getType() == DocumentEvent.EventType.REMOVE && element2.getElement(n) == this.longestLine) {
                this.calcLongestLineLength();
                this.preferenceChanged(null, true, false);
            }
        }
    }

    public float getMaximumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    public float getMinimumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        Element element = this.getElement();
        if (n == -1) {
            n = n2 == 5 || n2 == 3 ? this.getStartOffset() : this.getEndOffset() - 1;
        }
        switch (n2) {
            case 1: {
                int n3 = element.getElementIndex(n);
                int n4 = element.getElement(n3).getStartOffset();
                if (n3 <= 0) break;
                int n5 = n - n4;
                Element element2 = element.getElement(n3 - 1);
                n = element2.getStartOffset();
                n += Math.min(Math.min(4096, element2.getEndOffset() - n - 1), n5);
                break;
            }
            case 5: {
                int n6 = element.getElementIndex(n);
                int n7 = element.getElement(n6).getStartOffset();
                if (n6 >= element.getElementCount() - 1) break;
                int n8 = n - n7;
                Element element3 = element.getElement(n6 + 1);
                n = element3.getStartOffset();
                n += Math.min(Math.min(4096, element3.getEndOffset() - n - 1), n8);
                break;
            }
            case 7: {
                n = Math.max(0, n - 1);
                int n9 = element.getElementIndex(n);
                int n10 = element.getElement(n9).getStartOffset();
                if (n - n10 <= 4096) break;
                n = n10 + 4096;
                break;
            }
            case 3: {
                n = Math.min(n + 1, element.getEndOffset() - 1);
                int n11 = element.getElementIndex(n);
                int n12 = element.getElement(n11).getStartOffset();
                if (n - n12 <= 4096) break;
                n = element.getElementCount() > n11 + 1 ? element.getElement(n11 + 1).getStartOffset() : n12 + 4096;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + n2);
            }
        }
        return n;
    }
}

