/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.lib.ddl.impl.SpecificationFactory;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseOption;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RootNode
extends BaseNode {
    private static final String NAME = "Databases";
    private static final String ICONBASE = "org/netbeans/modules/db/resources/database.gif";
    private static final String FOLDER = "Root";
    private static RootNode instance = null;
    private static DatabaseOption option = null;
    private SpecificationFactory factory;

    public static RootNode instance() {
        if (instance == null) {
            NodeDataLookup nodeDataLookup = new NodeDataLookup();
            nodeDataLookup.add(ConnectionList.getDefault());
            instance = new RootNode(nodeDataLookup);
            instance.setup();
        }
        return instance;
    }

    public static boolean isCreated() {
        return instance != null;
    }

    private RootNode(NodeDataLookup nodeDataLookup) {
        super(new ChildNodeFactory((Lookup)nodeDataLookup), nodeDataLookup, FOLDER, null);
    }

    protected void initialize() {
        try {
            this.factory = new SpecificationFactory();
            if (this.factory == null) {
                throw new Exception(NbBundle.getMessage(RootNode.class, (String)"EXC_NoSpecificationFactory"));
            }
            this.initDebugListening();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public SpecificationFactory getSpecificationFactory() {
        return this.factory;
    }

    private void initDebugListening() {
        RootNode.getOption();
        option.getPropertySupport().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == null) {
                    RootNode.this.factory.setDebugMode(option.getDebugMode());
                    return;
                }
                if (propertyChangeEvent.getPropertyName().equals("debugMode")) {
                    RootNode.this.factory.setDebugMode((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
        this.factory.setDebugMode(option.getDebugMode());
    }

    public static synchronized DatabaseOption getOption() {
        if (option == null) {
            option = DatabaseOption.getDefault();
        }
        return option;
    }

    public String getName() {
        return NAME;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RootNode.class, (String)"RootNode_DISPLAYNAME");
    }

    public String getIconBase() {
        return ICONBASE;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(RootNode.class, (String)"ND_Root");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RootNode.class);
    }
}

