/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Procedure;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProcedureNode
extends BaseNode {
    private static final String ICONBASE = "org/netbeans/modules/db/resources/procedure.gif";
    private static final String FOLDER = "Procedure";
    private String name = "";
    private final MetadataElementHandle<Procedure> procedureHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static ProcedureNode create(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        ProcedureNode procedureNode = new ProcedureNode(nodeDataLookup, nodeProvider);
        procedureNode.setup();
        return procedureNode;
    }

    private ProcedureNode(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        super(new ChildNodeFactory((Lookup)nodeDataLookup), nodeDataLookup, FOLDER, nodeProvider);
        this.procedureHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    protected void initialize() {
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Procedure procedure = (Procedure)ProcedureNode.this.procedureHandle.resolve(metadata);
                        ProcedureNode.this.name = procedure.getName();
                        ProcedureNode.this.updateProperties(procedure);
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                Exceptions.printStackTrace((Throwable)metadataModelException);
            }
        }
    }

    private void updateProperties(Procedure procedure) {
        PropertySupport.Name name = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)name);
        if (procedure.getReturnValue() == null) {
            this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureNode.class, (String)"StoredProcedure"));
        } else {
            this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureNode.class, (String)"StoredFunction"));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getIconBase() {
        return ICONBASE;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ProcedureNode.class, (String)"ND_Procedure");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProcedureNode.class);
    }
}

