/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeRegistry
implements ChangeListener {
    private static final String PATH = "Databases/Explorer/";
    private static final String NODEPROVIDERS = "/NodeProviders";
    private final ChangeSupport changeSupport;
    private final List<NodeProvider> providers = new CopyOnWriteArrayList<NodeProvider>();
    private Lookup.Result lookupResult;

    public static NodeRegistry create(String string, NodeDataLookup nodeDataLookup) {
        NodeRegistry nodeRegistry = new NodeRegistry();
        nodeRegistry.init(string, (Lookup)nodeDataLookup);
        return nodeRegistry;
    }

    private NodeRegistry() {
        this.changeSupport = new ChangeSupport((Object)this);
    }

    private void init(String string, final Lookup lookup) {
        Lookup lookup2 = Lookups.forPath((String)(PATH + string + NODEPROVIDERS));
        this.lookupResult = lookup2.lookupResult(NodeProviderFactory.class);
        this.initProviders(lookup);
        this.lookupResult.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                NodeRegistry.this.initProviders(lookup);
                NodeRegistry.this.changeSupport.fireChange();
            }
        });
    }

    private void initProviders(Lookup lookup) {
        this.providers.clear();
        Collection collection = this.lookupResult.allInstances();
        for (NodeProviderFactory nodeProviderFactory : collection) {
            NodeProvider nodeProvider = nodeProviderFactory.createInstance(lookup);
            nodeProvider.addChangeListener(this);
            this.providers.add(nodeProvider);
        }
    }

    public synchronized void refresh() {
        for (NodeProvider nodeProvider : this.providers) {
            nodeProvider.refresh();
        }
    }

    public synchronized Collection<? extends Node> getNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (NodeProvider nodeProvider : this.providers) {
            arrayList.addAll(nodeProvider.getNodes());
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.changeSupport.fireChange();
    }
}

