/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.IndexNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Index;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class IndexNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle handle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private IndexNodeProvider(Lookup lookup) {
        super(lookup, new IndexComparator());
    }

    protected synchronized void initialize() {
        final ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Table table = (Table)IndexNodeProvider.this.handle.resolve(metadata);
                        if (table != null) {
                            Collection collection = table.getIndexes();
                            for (Index index : collection) {
                                MetadataElementHandle metadataElementHandle = MetadataElementHandle.create((MetadataElement)index);
                                Collection collection2 = IndexNodeProvider.this.getNodes(metadataElementHandle);
                                if (collection2.size() > 0) {
                                    arrayList.addAll(collection2);
                                    continue;
                                }
                                NodeDataLookup nodeDataLookup = new NodeDataLookup();
                                nodeDataLookup.add(IndexNodeProvider.this.connection);
                                nodeDataLookup.add(metadataElementHandle);
                                arrayList.add(IndexNode.create(nodeDataLookup, IndexNodeProvider.this));
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                Exceptions.printStackTrace((Throwable)metadataModelException);
            }
        }
        this.setNodes(arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IndexComparator
    implements Comparator<Node> {
        IndexComparator() {
        }

        @Override
        public int compare(Node node, Node node2) {
            return node.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            public IndexNodeProvider createInstance(Lookup lookup) {
                IndexNodeProvider indexNodeProvider = new IndexNodeProvider(lookup);
                return indexNodeProvider;
            }
        };

        private FactoryHolder() {
        }
    }
}

