/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.ColumnNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.api.View;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class ColumnNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle handle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private ColumnNodeProvider(Lookup lookup) {
        super(lookup, new ColumnComparator());
    }

    protected synchronized void initialize() {
        final ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Collection collection;
                        try {
                            Table table = (Table)ColumnNodeProvider.this.handle.resolve(metadata);
                            if (table == null) {
                                return;
                            }
                            collection = table.getColumns();
                        }
                        catch (ClassCastException classCastException) {
                            View view = (View)ColumnNodeProvider.this.handle.resolve(metadata);
                            if (view == null) {
                                return;
                            }
                            collection = view.getColumns();
                        }
                        for (View view : collection) {
                            MetadataElementHandle metadataElementHandle = MetadataElementHandle.create((MetadataElement)view);
                            Collection collection2 = ColumnNodeProvider.this.getNodes(metadataElementHandle);
                            if (collection2.size() > 0) {
                                arrayList.addAll(collection2);
                                continue;
                            }
                            NodeDataLookup nodeDataLookup = new NodeDataLookup();
                            nodeDataLookup.add(ColumnNodeProvider.this.connection);
                            nodeDataLookup.add(metadataElementHandle);
                            arrayList.add(ColumnNode.create(nodeDataLookup, ColumnNodeProvider.this));
                        }
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                Exceptions.printStackTrace((Throwable)metadataModelException);
            }
        }
        this.setNodes(arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ColumnComparator
    implements Comparator<Node> {
        ColumnComparator() {
        }

        @Override
        public int compare(Node node, Node node2) {
            ColumnNode columnNode = (ColumnNode)node;
            ColumnNode columnNode2 = (ColumnNode)node2;
            int n = 1;
            if (columnNode.getPosition() < columnNode2.getPosition()) {
                n = -1;
            }
            return n;
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            public ColumnNodeProvider createInstance(Lookup lookup) {
                ColumnNodeProvider columnNodeProvider = new ColumnNodeProvider(lookup);
                return columnNodeProvider;
            }
        };

        private FactoryHolder() {
        }
    }
}

