/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collection;
import org.netbeans.api.db.explorer.DatabaseMetaDataTransfer;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.lib.ddl.impl.RemoveColumn;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DatabaseMetaDataTransferAccessor;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.node.ColumnNameProvider;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.SchemaNameProvider;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.IndexColumn;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Nullable;
import org.netbeans.modules.db.metadata.model.api.PrimaryKey;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.api.Tuple;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnNode
extends BaseNode
implements SchemaNameProvider,
ColumnNameProvider {
    private static final String COLUMN = "org/netbeans/modules/db/resources/column.gif";
    private static final String PRIMARY = "org/netbeans/modules/db/resources/columnPrimary.gif";
    private static final String INDEX = "org/netbeans/modules/db/resources/columnIndex.gif";
    private static final String FOLDER = "Column";
    private String name = "";
    private String icon;
    private final MetadataElementHandle<Column> columnHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private boolean isTableColumn = true;

    public static ColumnNode create(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        ColumnNode columnNode = new ColumnNode(nodeDataLookup, nodeProvider);
        columnNode.setup();
        return columnNode;
    }

    private ColumnNode(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        super(nodeDataLookup, FOLDER, nodeProvider);
    }

    @Override
    public synchronized void refresh() {
        this.setupNames();
        super.refresh();
    }

    @Override
    protected void initialize() {
        this.setupNames();
    }

    private void setupNames() {
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Column column = (Column)ColumnNode.this.columnHandle.resolve(metadata);
                        if (column != null) {
                            ColumnNode.this.name = column.getName();
                            ColumnNode.this.icon = ColumnNode.COLUMN;
                            ColumnNode.this.updateProperties(column);
                            Tuple tuple = column.getParent();
                            if (tuple instanceof Table) {
                                Collection collection;
                                Table table = (Table)tuple;
                                PrimaryKey primaryKey = table.getPrimaryKey();
                                boolean bl = false;
                                if (primaryKey != null) {
                                    collection = primaryKey.getColumns();
                                    for (Column column2 : collection) {
                                        if (!column2.getName().equals(column.getName())) continue;
                                        bl = true;
                                        ColumnNode.this.icon = ColumnNode.PRIMARY;
                                        break;
                                    }
                                }
                                if (!bl) {
                                    collection = table.getIndexes();
                                    block1: for (Column column2 : collection) {
                                        Collection collection2 = column2.getColumns();
                                        for (IndexColumn indexColumn : collection2) {
                                            if (!indexColumn.getName().equals(column.getName())) continue;
                                            bl = true;
                                            ColumnNode.this.icon = ColumnNode.INDEX;
                                            continue block1;
                                        }
                                    }
                                }
                            } else {
                                ColumnNode.this.isTableColumn = false;
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                Exceptions.printStackTrace((Throwable)metadataModelException);
            }
        }
    }

    private void updateProperties(Column column) {
        PropertySupport.Name name = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)name);
        assert (column != null) : "Column " + this + " cannot be null.";
        if (column == null) {
            return;
        }
        try {
            this.addProperty("Null", "NullDescription", Boolean.class, false, column.getNullable() == Nullable.NULLABLE);
            this.addProperty("Datatype", "DatatypeDescription", String.class, false, column.getType().toString());
            int n = column.getLength();
            if (n == 0) {
                n = column.getPrecision();
            }
            this.addProperty("ColumnSize", "ColumnSizeDescription", Integer.class, false, n);
            this.addProperty("DecimalDigits", "DecimalDigitsDescription", Short.class, false, column.getScale());
            this.addProperty("Position", "PositionDescription", Integer.class, false, column.getPosition());
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    @Override
    public String getColumnName() {
        return ColumnNode.getColumnName(this.connection, this.columnHandle);
    }

    @Override
    public String getSchemaName() {
        return ColumnNode.getSchemaName(this.connection, this.columnHandle);
    }

    @Override
    public String getCatalogName() {
        return ColumnNode.getCatalogName(this.connection, this.columnHandle);
    }

    @Override
    public String getParentName() {
        return ColumnNode.getParentName(this.connection, this.columnHandle);
    }

    public int getPosition() {
        MetadataModel metadataModel = this.connection.getMetadataModel();
        final int[] nArray = new int[1];
        try {
            metadataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    Column column = (Column)ColumnNode.this.columnHandle.resolve(metadata);
                    nArray[0] = column.getPosition();
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            Exceptions.printStackTrace((Throwable)metadataModelException);
        }
        return nArray[0];
    }

    @Override
    public void destroy() {
        DatabaseConnector databaseConnector = this.connection.getConnector();
        Specification specification = databaseConnector.getDatabaseSpecification();
        try {
            RemoveColumn removeColumn = specification.createCommandRemoveColumn(this.getParentName());
            String string = this.getSchemaName();
            if (string == null) {
                string = this.getCatalogName();
            }
            removeColumn.setObjectOwner(string);
            removeColumn.removeColumn(this.getName());
            removeColumn.execute();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{this.getParentNode()});
    }

    @Override
    public boolean canDestroy() {
        if (this.isTableColumn) {
            DatabaseConnector databaseConnector = this.connection.getConnector();
            return databaseConnector.supportsCommand("RemoveColumnCommand");
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getIconBase() {
        return this.icon;
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
        exTransferable.put(new ExTransferable.Single(DatabaseMetaDataTransfer.COLUMN_FLAVOR){

            protected Object getData() {
                return DatabaseMetaDataTransferAccessor.DEFAULT.createColumnData(ColumnNode.this.connection.getDatabaseConnection(), ColumnNode.this.connection.findJDBCDriver(), ColumnNode.this.getParentName(), ColumnNode.this.getName());
            }
        });
        return exTransferable;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ColumnNode.class, (String)"ND_Column");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ColumnNode.class);
    }

    public static String getColumnName(DatabaseConnection databaseConnection, final MetadataElementHandle<Column> metadataElementHandle) {
        MetadataModel metadataModel = databaseConnection.getMetadataModel();
        final String[] stringArray = new String[]{null};
        try {
            metadataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    Column column = (Column)metadataElementHandle.resolve(metadata);
                    if (column != null) {
                        stringArray[0] = column.getName();
                    }
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            Exceptions.printStackTrace((Throwable)metadataModelException);
        }
        return stringArray[0];
    }

    public static String getParentName(DatabaseConnection databaseConnection, final MetadataElementHandle<Column> metadataElementHandle) {
        MetadataModel metadataModel = databaseConnection.getMetadataModel();
        final String[] stringArray = new String[]{null};
        try {
            metadataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    Column column = (Column)metadataElementHandle.resolve(metadata);
                    if (column != null) {
                        stringArray[0] = column.getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            Exceptions.printStackTrace((Throwable)metadataModelException);
        }
        return stringArray[0];
    }

    public static String getSchemaName(DatabaseConnection databaseConnection, final MetadataElementHandle<Column> metadataElementHandle) {
        MetadataModel metadataModel = databaseConnection.getMetadataModel();
        final String[] stringArray = new String[1];
        try {
            metadataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    Column column = (Column)metadataElementHandle.resolve(metadata);
                    if (column != null) {
                        stringArray[0] = column.getParent().getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            Exceptions.printStackTrace((Throwable)metadataModelException);
        }
        return stringArray[0];
    }

    public static String getCatalogName(DatabaseConnection databaseConnection, final MetadataElementHandle<Column> metadataElementHandle) {
        MetadataModel metadataModel = databaseConnection.getMetadataModel();
        final String[] stringArray = new String[1];
        try {
            metadataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    Column column = (Column)metadataElementHandle.resolve(metadata);
                    if (column != null) {
                        stringArray[0] = column.getParent().getParent().getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            Exceptions.printStackTrace((Throwable)metadataModelException);
        }
        return stringArray[0];
    }
}

