/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyProc;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Binding;
import org.jruby.nb.runtime.BlockBody;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class Block {
    private RubyProc proc = null;
    public Type type = Type.NORMAL;
    private final Binding binding;
    private final BlockBody body;
    private boolean[] escaped = new boolean[]{false};
    public static final Block NULL_BLOCK = new Block(){

        public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, RubyModule rubyModule, boolean bl) {
            throw threadContext.getRuntime().newLocalJumpError("noreason", iRubyObject, "yield called out of block");
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
            throw threadContext.getRuntime().newLocalJumpError("noreason", threadContext.getRuntime().newArrayNoCopy(iRubyObjectArray), "yield called out of block");
        }

        public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject) {
            throw threadContext.getRuntime().newLocalJumpError("noreason", iRubyObject, "yield called out of block");
        }

        public Block cloneBlock() {
            return this;
        }

        public BlockBody getBody() {
            return BlockBody.NULL_BODY;
        }
    };

    protected Block() {
        this(null, null);
    }

    public Block(BlockBody blockBody, Binding binding) {
        this.body = blockBody;
        this.binding = binding;
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return this.body.call(threadContext, iRubyObjectArray, this.binding, this.type);
    }

    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.body.yield(threadContext, iRubyObject, this.binding, this.type);
    }

    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, RubyModule rubyModule, boolean bl) {
        return this.body.yield(threadContext, iRubyObject, iRubyObject2, rubyModule, bl, this.binding, this.type);
    }

    public Block cloneBlock() {
        Block block = this.body.cloneBlock(this.binding);
        block.type = this.type;
        block.escaped = this.escaped;
        return block;
    }

    public Arity arity() {
        return this.body.arity();
    }

    public RubyProc getProcObject() {
        return this.proc;
    }

    public void setProcObject(RubyProc rubyProc) {
        this.proc = rubyProc;
    }

    public final boolean isGiven() {
        return this != NULL_BLOCK;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public BlockBody getBody() {
        return this.body;
    }

    public Frame getFrame() {
        return this.binding.getFrame();
    }

    public boolean isEscaped() {
        return this.escaped[0];
    }

    public void escape() {
        this.escaped[0] = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NORMAL,
        PROC,
        LAMBDA,
        THREAD;

    }
}

