/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyIO;
import org.jruby.nb.RubyInteger;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.ext.socket.RubySocket;
import org.jruby.nb.ext.socket.RubyTCPSocket;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.io.ChannelDescriptor;
import org.jruby.nb.util.io.InvalidValueException;
import org.jruby.nb.util.io.ModeFlags;

@JRubyClass(name={"TCPServer"}, parent="TCPSocket")
public class RubyTCPServer
extends RubyTCPSocket {
    private static ObjectAllocator TCPSERVER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyTCPServer(ruby, rubyClass);
        }
    };
    private ServerSocketChannel ssc;
    private InetSocketAddress socket_address;

    static void createTCPServer(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("TCPServer", ruby.fastGetClass("TCPSocket"), TCPSERVER_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(RubyTCPServer.class);
        ruby.getObject().fastSetConstant("TCPserver", rubyClass);
    }

    public RubyTCPServer(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, visibility=Visibility.PRIVATE, backtrace=true)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject;
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        IRubyObject iRubyObject3 = iRubyObject = iRubyObjectArray.length > 1 ? iRubyObjectArray[1] : this.getRuntime().getNil();
        if (iRubyObject2.isNil()) {
            iRubyObject2 = this.getRuntime().newString("0.0.0.0");
        } else if (iRubyObject2 instanceof RubyFixnum) {
            iRubyObject = iRubyObject2;
            iRubyObject2 = this.getRuntime().newString("0.0.0.0");
        }
        String string = iRubyObject2.convertToString().toString();
        try {
            int n;
            InetAddress inetAddress = InetAddress.getByName(string);
            this.ssc = ServerSocketChannel.open();
            if (iRubyObject instanceof RubyInteger) {
                n = RubyNumeric.fix2int(iRubyObject);
            } else {
                RubyString rubyString = iRubyObject.convertToString();
                RubyInteger rubyInteger = rubyString.convertToInteger(MethodIndex.TO_I, "to_i");
                n = RubyNumeric.fix2int(rubyInteger);
                if (n <= 0) {
                    n = RubyNumeric.fix2int(RubySocket.getservbyname(this.getRuntime().getObject(), new IRubyObject[]{rubyString}));
                }
            }
            this.socket_address = new InetSocketAddress(inetAddress, n);
            this.ssc.socket().bind(this.socket_address);
            this.initSocket(new ChannelDescriptor(this.ssc, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (UnknownHostException unknownHostException) {
            throw RubyTCPServer.sockerr(this, "initialize: name or service not known");
        }
        catch (BindException bindException) {
            throw this.getRuntime().newErrnoEADDRINUSEError();
        }
        catch (IOException iOException) {
            throw RubyTCPServer.sockerr(this, "initialize: name or service not known");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw RubyTCPServer.sockerr(this, illegalArgumentException.getMessage());
        }
        return this;
    }

    @JRubyMethod(name={"accept"})
    public IRubyObject accept() {
        RubyTCPSocket rubyTCPSocket = new RubyTCPSocket(this.getRuntime(), this.getRuntime().fastGetClass("TCPSocket"));
        ThreadContext threadContext = this.getRuntime().getCurrentContext();
        try {
            boolean bl;
            while (!(bl = threadContext.getThread().select(this, 16))) {
                this.getRuntime().getCurrentContext().pollThreadEvents();
            }
            try {
                SocketChannel socketChannel = this.ssc.accept();
                socketChannel.finishConnect();
                rubyTCPSocket.initSocket(new ChannelDescriptor(socketChannel, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
            }
            catch (InvalidValueException invalidValueException) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            return rubyTCPSocket;
        }
        catch (IOException iOException) {
            throw RubyTCPServer.sockerr(this, "problem when accepting");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(name={"accept_nonblock"})
    public IRubyObject accept_nonblock() {
        RubyTCPSocket rubyTCPSocket2;
        RubyTCPSocket rubyTCPSocket = new RubyTCPSocket(this.getRuntime(), this.getRuntime().fastGetClass("TCPSocket"));
        Selector selector = null;
        try {
            try {
                this.ssc.configureBlocking(false);
                selector = Selector.open();
                SelectionKey selectionKey = this.ssc.register(selector, 16);
                int n = selector.selectNow();
                if (n == 0) {
                    throw this.getRuntime().newErrnoEAGAINError("Resource temporarily unavailable");
                }
                try {
                    rubyTCPSocket.initSocket(new ChannelDescriptor(this.ssc.accept(), RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
                }
                catch (InvalidValueException invalidValueException) {
                    throw this.getRuntime().newErrnoEINVALError();
                }
                rubyTCPSocket2 = rubyTCPSocket;
                Object var7_8 = null;
            }
            catch (IOException iOException) {
                throw RubyTCPServer.sockerr(this, "problem when accepting");
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (selector == null) throw throwable;
                selector.close();
                throw throwable;
            }
            catch (IOException iOException2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return rubyTCPSocket2;
        }
        if (selector == null) return rubyTCPSocket2;
        selector.close();
        return rubyTCPSocket2;
    }

    @JRubyMethod(name={"listen"}, required=1)
    public IRubyObject listen(IRubyObject iRubyObject) {
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"peeraddt"}, rest=true)
    public IRubyObject peeraddr(IRubyObject[] iRubyObjectArray) {
        throw this.getRuntime().newNotImplementedError("not supported");
    }

    @JRubyMethod(name={"getpeername"}, rest=true)
    public IRubyObject getpeername(IRubyObject[] iRubyObjectArray) {
        throw this.getRuntime().newNotImplementedError("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, rest=true, frame=true, meta=true)
    public static IRubyObject open(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject2;
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, "new", iRubyObjectArray);
        if (!block.isGiven()) {
            return iRubyObject3;
        }
        try {
            iRubyObject2 = block.yield(threadContext, iRubyObject3);
            Object var7_6 = null;
            iRubyObject3.callMethod(threadContext, "close");
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            iRubyObject3.callMethod(threadContext, "close");
            throw throwable;
        }
        return iRubyObject2;
    }
}

