/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SClassNode
extends Node {
    private final Node receiverNode;
    private final StaticScope scope;
    private final Node bodyNode;

    public SClassNode(ISourcePosition iSourcePosition, Node node, StaticScope staticScope, Node node2) {
        super(iSourcePosition, NodeType.SCLASSNODE);
        assert (staticScope != null) : "scope is not null";
        assert (node != null) : "receiverNode is not null";
        this.receiverNode = node;
        this.scope = staticScope;
        this.bodyNode = node2;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitSClassNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = this.receiverNode.interpret(ruby, threadContext, iRubyObject, block);
        if (iRubyObject2 instanceof RubyFixnum || iRubyObject2 instanceof RubySymbol) {
            throw ruby.newTypeError("no virtual class for " + iRubyObject2.getMetaClass().getBaseName());
        }
        if (ruby.getSafeLevel() >= 4 && !iRubyObject2.isTaint()) {
            throw ruby.newSecurityError("Insecure: can't extend object.");
        }
        RubyClass rubyClass = iRubyObject2.getSingletonClass();
        this.scope.setModule(rubyClass);
        return ASTInterpreter.evalClassDefinitionBody(ruby, threadContext, this.scope, this.bodyNode, rubyClass, iRubyObject, block);
    }
}

