/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Statistics {
    public static double average(Collection<? extends Number> collection) {
        return Statistics.average(collection, false);
    }

    public static double average(Collection<? extends Number> collection, boolean bl) {
        if (collection == null) {
            throw new IllegalArgumentException("Null 'values' argument.");
        }
        int n = 0;
        double d = 0.0;
        for (Number number : collection) {
            if (number == null) {
                if (!bl) continue;
                return Double.NaN;
            }
            double d2 = number.doubleValue();
            if (Double.isNaN(d2)) {
                if (!bl) continue;
                return Double.NaN;
            }
            d += number.doubleValue();
            ++n;
        }
        return d / (double)n;
    }

    public static double median(Collection<? extends Number> collection) {
        double d = Double.NaN;
        if (collection != null) {
            int n = collection.size();
            ArrayList<Double> arrayList = new ArrayList<Double>(n);
            for (Number number : collection) {
                arrayList.add(number.doubleValue());
            }
            Collections.sort(arrayList);
            int n2 = arrayList.size();
            if (n2 > 0) {
                if (n2 % 2 == 1) {
                    if (n2 > 1) {
                        Number number = (Number)arrayList.get((n2 - 1) / 2);
                        d = number.doubleValue();
                    } else {
                        Number number = (Number)arrayList.get(0);
                        d = number.doubleValue();
                    }
                } else {
                    Number number = (Number)arrayList.get(n2 / 2 - 1);
                    Number number2 = (Number)arrayList.get(n2 / 2);
                    d = (number.doubleValue() + number2.doubleValue()) / 2.0;
                }
            }
        }
        return d;
    }

    public static double stdDev(Collection<? extends Number> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Null 'data' array.");
        }
        if (collection.size() == 0) {
            throw new IllegalArgumentException("Zero length 'data' array.");
        }
        double d = Statistics.average(collection);
        double d2 = 0.0;
        for (Number number : collection) {
            double d3 = number.doubleValue() - d;
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)(collection.size() - 1));
    }
}

