/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.codeviation.commons.patterns.Factory;
import org.codeviation.commons.patterns.Filter;
import org.codeviation.commons.utils.StreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil {
    public static Factory<URL, File> TO_URL = new UrlFactory();
    public static Factory<String, File> TO_STRING = new StringFactory();
    public static Factory<InputStream, File> TO_INPUT_STREAM = new InputStreamFactory();
    public static Factory<OutputStream, File> TO_OUTPUT_STREAM = new OutputStreamFactory();

    private FileUtil() {
    }

    public static String asString(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        int n2 = fileInputStream.read(byArray);
        if (n2 < n) {
            fileInputStream.close();
            throw new IOException("Could not read whole file" + file + " read " + n2 + " instead of " + n);
        }
        fileInputStream.close();
        return new String(byArray, 0, n);
    }

    public static Iterator<String> asLines(File file) throws FileNotFoundException, IOException {
        return StreamUtil.asLines(new FileInputStream(file));
    }

    public static void copy(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        StreamUtil.copy(fileInputStream, fileOutputStream);
        ((InputStream)fileInputStream).close();
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public static void fromString(File file, String ... stringArray) throws FileNotFoundException, IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        for (String string : stringArray) {
            ((OutputStream)bufferedOutputStream).write(string.getBytes());
        }
        ((OutputStream)bufferedOutputStream).close();
    }

    public static void fromLines(File file, String ... stringArray) throws FileNotFoundException, IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        for (String string : stringArray) {
            ((OutputStream)bufferedOutputStream).write(string.getBytes());
            ((OutputStream)bufferedOutputStream).write(10);
        }
        ((OutputStream)bufferedOutputStream).close();
    }

    public static boolean delete(File file) {
        File[] fileArray;
        boolean bl = true;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null && fileArray.length != 0) {
            for (File file2 : fileArray) {
                bl = bl ? FileUtil.delete(file2) : false;
            }
        }
        bl = bl ? file.delete() : false;
        return bl;
    }

    public static Factory<File, String> fileFactory(File file) {
        return new FileFactory(file, null);
    }

    public static Factory<File, String> fileFactory(File file, Filter<File> filter) {
        return new FileFactory(file, filter);
    }

    public static File file(File file, String ... stringArray) {
        return new File(file, FileUtil.path(File.separatorChar, stringArray));
    }

    public static void assureDirectory(File file) throws IOException {
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException("Can't create directory : " + file.getAbsolutePath());
        }
    }

    public static String path(String ... stringArray) {
        return FileUtil.path(File.pathSeparatorChar, stringArray);
    }

    public static String path(char c, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i == stringArray.length - 1) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static File resolve(String string, String string2) {
        return FileUtil.resolve(new File(string), string2 == null ? null : new File(string2));
    }

    public static File resolve(File file, String string) {
        return FileUtil.resolve(file, string == null ? null : new File(string));
    }

    public static File resolve(File file, File file2) {
        if (file2 == null) {
            return file;
        }
        if (file2.isAbsolute()) {
            return file2;
        }
        return new File(file, file2.getPath());
    }

    public static String nameNoExt(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String extensions(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1, string.length());
    }

    public static String extension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1, string.length());
    }

    public static URL toURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InputStreamFactory
    implements Factory<InputStream, File> {
        private InputStreamFactory() {
        }

        @Override
        public InputStream create(File file) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException(fileNotFoundException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputStreamFactory
    implements Factory<OutputStream, File> {
        private OutputStreamFactory() {
        }

        @Override
        public OutputStream create(File file) {
            try {
                return new FileOutputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException(fileNotFoundException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringFactory
    implements Factory<String, File> {
        private StringFactory() {
        }

        @Override
        public String create(File file) {
            try {
                return FileUtil.asString(file);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UrlFactory
    implements Factory<URL, File> {
        private UrlFactory() {
        }

        @Override
        public URL create(File file) {
            try {
                return FileUtil.toURL(file);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException(malformedURLException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileFactory
    implements Factory<File, String> {
        private File root;
        private Filter<File> filter;

        public FileFactory(File file, Filter<File> filter) {
            this.root = file;
            this.filter = filter;
        }

        @Override
        public File create(String string) {
            File file = this.root == null ? new File(string) : new File(this.root, string);
            if (this.filter == null) {
                return file;
            }
            return this.filter.accept(file) ? file : null;
        }
    }
}

