/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsps.parserapi;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import org.netbeans.modules.web.jsps.parserapi.Node;
import org.xml.sax.Attributes;

class DumpVisitor
extends Node.Visitor {
    private static final Logger LOGGER = Logger.getLogger(DumpVisitor.class.getName());
    private int indent = 0;
    private StringBuilder buf = new StringBuilder();

    private DumpVisitor() {
    }

    protected void visitCommon(Node node) throws JspException {
        this.printString("\nNode [" + node.getStart() + ", " + this.getDisplayClassName(node.getClass().getName()) + "] ");
    }

    private String getDisplayClassName(String string) {
        int n = string.indexOf(36);
        return string.substring(n + 1);
    }

    private String getAttributes(Attributes attributes) {
        if (attributes == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < attributes.getLength(); ++i) {
            stringBuilder.append(" ");
            stringBuilder.append(attributes.getQName(i));
            stringBuilder.append("=\"");
            stringBuilder.append(attributes.getValue(i));
            stringBuilder.append("\"");
        }
        return stringBuilder.toString();
    }

    private void printString(String string) {
        this.printIndent();
        this.buf.append(string);
    }

    private void printString(String string, String string2, String string3) {
        this.printIndent();
        if (string2 != null) {
            this.buf.append(string);
            this.buf.append(string2);
            this.buf.append(string3);
        } else {
            this.buf.append(string);
            this.buf.append(string3);
        }
    }

    private void printAttributes(String string, Attributes attributes, String string2) {
        this.printString(string, this.getAttributes(attributes), string2);
    }

    private void dumpBody(Node node) throws JspException {
        Node.Nodes nodes = node.getBody();
        if (nodes != null) {
            ++this.indent;
            nodes.visit(this);
            --this.indent;
        }
    }

    public void visit(Node.TagDirective tagDirective) throws JspException {
        this.visitCommon(tagDirective);
        this.printAttributes("<%@ tag", tagDirective.getAttributes(), "%>");
    }

    public void visit(Node.PageDirective pageDirective) throws JspException {
        this.visitCommon(pageDirective);
        this.printAttributes("<%@ page", pageDirective.getAttributes(), "%>");
    }

    public void visit(Node.TaglibDirective taglibDirective) throws JspException {
        this.visitCommon(taglibDirective);
        this.printAttributes("<%@ taglib", taglibDirective.getAttributes(), "%>");
    }

    public void visit(Node.IncludeDirective includeDirective) throws JspException {
        this.visitCommon(includeDirective);
        this.printAttributes("<%@ include", includeDirective.getAttributes(), "%>");
        this.dumpBody(includeDirective);
    }

    public void visit(Node.Comment comment) throws JspException {
        this.visitCommon(comment);
        this.printString("<%--", comment.getText(), "--%>");
    }

    public void visit(Node.Declaration declaration) throws JspException {
        this.visitCommon(declaration);
        this.printString("<%!", declaration.getText(), "%>");
    }

    public void visit(Node.Expression expression) throws JspException {
        this.visitCommon(expression);
        this.printString("<%=", expression.getText(), "%>");
    }

    public void visit(Node.Scriptlet scriptlet) throws JspException {
        this.visitCommon(scriptlet);
        this.printString("<%", scriptlet.getText(), "%>");
    }

    public void visit(Node.IncludeAction includeAction) throws JspException {
        this.visitCommon(includeAction);
        this.printAttributes("<jsp:include", includeAction.getAttributes(), ">");
        this.dumpBody(includeAction);
        this.printString("</jsp:include>");
    }

    public void visit(Node.ForwardAction forwardAction) throws JspException {
        this.visitCommon(forwardAction);
        this.printAttributes("<jsp:forward", forwardAction.getAttributes(), ">");
        this.dumpBody(forwardAction);
        this.printString("</jsp:forward>");
    }

    public void visit(Node.GetProperty getProperty) throws JspException {
        this.visitCommon(getProperty);
        this.printAttributes("<jsp:getProperty", getProperty.getAttributes(), "/>");
    }

    public void visit(Node.SetProperty setProperty) throws JspException {
        this.visitCommon(setProperty);
        this.printAttributes("<jsp:setProperty", setProperty.getAttributes(), ">");
        this.dumpBody(setProperty);
        this.printString("</jsp:setProperty>");
    }

    public void visit(Node.UseBean useBean) throws JspException {
        this.visitCommon(useBean);
        this.printAttributes("<jsp:useBean", useBean.getAttributes(), ">");
        this.dumpBody(useBean);
        this.printString("</jsp:useBean>");
    }

    public void visit(Node.PlugIn plugIn) throws JspException {
        this.visitCommon(plugIn);
        this.printAttributes("<jsp:plugin", plugIn.getAttributes(), ">");
        this.dumpBody(plugIn);
        this.printString("</jsp:plugin>");
    }

    public void visit(Node.ParamsAction paramsAction) throws JspException {
        this.visitCommon(paramsAction);
        this.printAttributes("<jsp:params", paramsAction.getAttributes(), ">");
        this.dumpBody(paramsAction);
        this.printString("</jsp:params>");
    }

    public void visit(Node.ParamAction paramAction) throws JspException {
        this.visitCommon(paramAction);
        this.printAttributes("<jsp:param", paramAction.getAttributes(), ">");
        this.dumpBody(paramAction);
        this.printString("</jsp:param>");
    }

    public void visit(Node.NamedAttribute namedAttribute) throws JspException {
        this.visitCommon(namedAttribute);
        this.printAttributes("<jsp:attribute", namedAttribute.getAttributes(), ">");
        this.dumpBody(namedAttribute);
        this.printString("</jsp:attribute>");
    }

    public void visit(Node.JspBody jspBody) throws JspException {
        this.visitCommon(jspBody);
        this.printAttributes("<jsp:body", jspBody.getAttributes(), ">");
        this.dumpBody(jspBody);
        this.printString("</jsp:body>");
    }

    public void visit(Node.ELExpression eLExpression) throws JspException {
        this.visitCommon(eLExpression);
        this.printString(eLExpression.getText());
    }

    public void visit(Node.CustomTag customTag) throws JspException {
        this.visitCommon(customTag);
        this.printAttributes("<" + customTag.getQName(), customTag.getAttributes(), ">");
        this.dumpBody(customTag);
        this.printString("</" + customTag.getQName() + ">");
    }

    public void visit(Node.UninterpretedTag uninterpretedTag) throws JspException {
        this.visitCommon(uninterpretedTag);
        String string = uninterpretedTag.getQName();
        this.printAttributes("<" + string, uninterpretedTag.getAttributes(), ">");
        this.dumpBody(uninterpretedTag);
        this.printString("</" + string + ">");
    }

    public void visit(Node.InvokeAction invokeAction) throws JspException {
        this.visitCommon(invokeAction);
        this.printAttributes("<jsp:invoke", invokeAction.getAttributes(), ">");
        this.dumpBody(invokeAction);
        this.printString("</jsp:invoke>");
    }

    public void visit(Node.DoBodyAction doBodyAction) throws JspException {
        this.visitCommon(doBodyAction);
        this.printAttributes("<jsp:doBody", doBodyAction.getAttributes(), ">");
        this.dumpBody(doBodyAction);
        this.printString("</jsp:doBody>");
    }

    public void visit(Node.TemplateText templateText) throws JspException {
        this.visitCommon(templateText);
        this.printString(new String(templateText.getText()));
    }

    private void printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.buf.append("  ");
        }
    }

    private String getString() {
        return this.buf.toString();
    }

    public static String dump(Node node) {
        try {
            DumpVisitor dumpVisitor = new DumpVisitor();
            node.accept(dumpVisitor);
            return dumpVisitor.getString();
        }
        catch (JspException jspException) {
            LOGGER.log(Level.INFO, null, jspException);
            return jspException.getMessage();
        }
    }

    public static String dump(Node.Nodes nodes) {
        try {
            DumpVisitor dumpVisitor = new DumpVisitor();
            nodes.visit(dumpVisitor);
            return dumpVisitor.getString();
        }
        catch (JspException jspException) {
            LOGGER.log(Level.INFO, null, jspException);
            return jspException.getMessage();
        }
    }
}

