/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ant;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.Transport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JPDAStart
extends Task
implements Runnable {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.ant");
    private static final String SOCKET_TRANSPORT = "dt_socket";
    private static final String SHMEM_TRANSPORT = "dt_shmem";
    private String addressProperty;
    private String transport = "dt_socket";
    private String name;
    private Sourcepath sourcepath = null;
    private Path classpath = null;
    private Path bootclasspath = null;
    private Object[] lock = null;
    private String stopClassName = null;
    private String listeningCP = null;

    public void setAddressProperty(String propertyName) {
        this.addressProperty = propertyName;
    }

    private String getAddressProperty() {
        return this.addressProperty;
    }

    public void setTransport(String transport) {
        logger.fine("Set transport: '" + transport + "'");
        this.transport = transport;
    }

    private String getTransport() {
        return this.transport;
    }

    public void setName(String name) {
        this.name = name;
    }

    private String getName() {
        return this.name;
    }

    public void setStopClassName(String stopClassName) {
        this.stopClassName = stopClassName;
    }

    private String getStopClassName() {
        return this.stopClassName;
    }

    public void setListeningcp(String listeningCP) {
        this.listeningCP = listeningCP;
    }

    public void addClasspath(Path path) {
        if (this.classpath != null) {
            throw new BuildException("Only one classpath subelement is supported");
        }
        this.classpath = path;
    }

    public void addBootclasspath(Path path) {
        if (this.bootclasspath != null) {
            throw new BuildException("Only one bootclasspath subelement is supported");
        }
        this.bootclasspath = path;
    }

    public void addSourcepath(Sourcepath path) {
        if (this.sourcepath != null) {
            throw new BuildException("Only one sourcepath subelement is supported");
        }
        this.sourcepath = path;
    }

    static void verifyPaths(Project project, Path path) {
        if (path == null) {
            return;
        }
        String[] paths = path.list();
        for (int i = 0; i < paths.length; ++i) {
            String pathName = project.replaceProperties(paths[i]);
            File file = FileUtil.normalizeFile((File)project.resolveFile(pathName));
            if (file.exists()) continue;
            project.log("Non-existing path \"" + pathName + "\" provided.", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        JPDAStart.verifyPaths(this.getProject(), this.classpath);
        JPDAStart.verifyPaths(this.getProject(), this.sourcepath);
        try {
            logger.fine("JPDAStart.execute()");
            JPDAStart.debug("Execute started");
            if (this.name == null) {
                throw new BuildException("name attribute must specify name of this debugging session", this.getLocation());
            }
            if (this.addressProperty == null) {
                throw new BuildException("addressproperty attribute must specify name of property to which address will be set", this.getLocation());
            }
            if (this.transport == null) {
                this.transport = SOCKET_TRANSPORT;
            }
            JPDAStart.debug("Entering synch lock");
            Object[] objectArray = this.lock = new Object[2];
            synchronized (this.lock) {
                JPDAStart.debug("Entered synch lock");
                RequestProcessor.getDefault().post((Runnable)this);
                try {
                    JPDAStart.debug("Entering wait");
                    this.lock.wait();
                    JPDAStart.debug("Wait finished");
                    if (this.lock[1] != null) {
                        if (this.lock[1] instanceof DebuggerStartException) {
                            throw new BuildException(((DebuggerStartException)((Object)this.lock[1])).getLocalizedMessage());
                        }
                        if (this.lock[1] instanceof ThreadDeath) {
                            throw (ThreadDeath)this.lock[1];
                        }
                        throw new BuildException((Throwable)this.lock[1]);
                    }
                }
                catch (InterruptedException e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new BuildException(t);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.fine("JPDAStart.run()");
        JPDAStart.debug("Entering synch lock");
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            JPDAStart.debug("Entered synch lock");
            try {
                String address;
                Connector lc = null;
                for (ListeningConnector llc : Bootstrap.virtualMachineManager().listeningConnectors()) {
                    Transport t = llc.transport();
                    if (t == null || !t.name().equals(this.transport)) continue;
                    lc = llc;
                    break;
                }
                if (lc == null) {
                    throw new BuildException("No trasports named " + this.transport + " found!");
                }
                logger.fine("Listening using transport " + this.transport);
                Map<String, Connector.Argument> args = lc.defaultArguments();
                try {
                    address = lc.startListening(args);
                }
                catch (IOException ioex) {
                    this.getProject().log("Listening failed with arguments: " + args);
                    throw ioex;
                }
                catch (IllegalConnectorArgumentsException iaex) {
                    this.getProject().log("Listening failed with arguments: " + args);
                    throw iaex;
                }
                if (SOCKET_TRANSPORT.equals(this.transport)) {
                    try {
                        int port = Integer.parseInt(address.substring(address.indexOf(58) + 1));
                        Connector.IntegerArgument portArg = (Connector.IntegerArgument)args.get("port");
                        portArg.setValue(port);
                        String host = address.substring(0, address.indexOf(58));
                        try {
                            InetAddress.getByName(host);
                        }
                        catch (UnknownHostException uhex) {
                            address = "localhost:" + port;
                        }
                        catch (SecurityException se) {}
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (SHMEM_TRANSPORT.equals(this.transport)) {
                    try {
                        Connector.StringArgument name = (Connector.StringArgument)args.get("name");
                        name.setValue(address);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.getProject().setNewProperty(this.getAddressProperty(), address);
                JPDAStart.debug("Creating source path");
                ClassPath sourcePath = JPDAStart.createSourcePath(this.getProject(), this.classpath, this.sourcepath);
                ClassPath jdkSourcePath = JPDAStart.createJDKSourcePath(this.getProject(), this.bootclasspath);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Create sourcepath:");
                    logger.fine("    classpath : " + this.classpath);
                    logger.fine("    sourcepath : " + (Object)((Object)this.sourcepath));
                    logger.fine("    bootclasspath : " + this.bootclasspath);
                    logger.fine("    >> sourcePath : " + sourcePath);
                    logger.fine("    >> jdkSourcePath : " + jdkSourcePath);
                }
                MethodBreakpoint first = null;
                if (this.stopClassName != null && this.stopClassName.length() > 0) {
                    logger.fine("create method breakpoint, class name = " + this.stopClassName);
                    first = this.createBreakpoint(this.stopClassName);
                }
                JPDAStart.debug("Debugger started");
                logger.fine("start listening at " + address);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("sourcepath", sourcePath);
                properties.put("name", this.getName());
                properties.put("jdksources", jdkSourcePath);
                properties.put("listeningCP", this.listeningCP);
                String workDir = this.getProject().getProperty("work.dir");
                File baseDir = workDir != null ? new File(workDir) : this.getProject().getBaseDir();
                properties.put("baseDir", baseDir);
                logger.fine("JPDAStart: properties = " + properties);
                Connector flc = lc;
                final WeakReference[] startedSessionRef = new WeakReference[]{new WeakReference<Object>(null)};
                HashMap listeners = new HashMap();
                LinkedList<ExceptionBreakpoint> artificialBreakpoints = new LinkedList<ExceptionBreakpoint>();
                if (this.listeningCP != null) {
                    ExceptionBreakpoint b = this.createCompilationErrorBreakpoint();
                    DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)b);
                    artificialBreakpoints.add(b);
                }
                DebuggerManager.getDebuggerManager().addDebuggerListener("debuggerEngines", (DebuggerManagerListener)new Listener((Breakpoint)first, artificialBreakpoints, listeners, startedSessionRef));
                RequestProcessor.getDefault().post(new Runnable((ListeningConnector)flc, args, properties){
                    final /* synthetic */ ListeningConnector val$flc;
                    final /* synthetic */ Map val$args;
                    final /* synthetic */ Map val$properties;
                    {
                        this.val$flc = listeningConnector;
                        this.val$args = map;
                        this.val$properties = map2;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        DebuggerManagerAdapter sessionListener = new DebuggerManagerAdapter(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void sessionAdded(Session session) {
                                WeakReference[] weakReferenceArray = startedSessionRef;
                                synchronized (startedSessionRef) {
                                    startedSessionRef[0] = new WeakReference<Session>(session);
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    return;
                                }
                            }
                        };
                        try {
                            DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)sessionListener);
                            JPDADebugger.startListening((ListeningConnector)this.val$flc, (Map)this.val$args, (Object[])new Object[]{this.val$properties});
                        }
                        catch (DebuggerStartException debuggerStartException) {
                        }
                        finally {
                            DebuggerManager.getDebuggerManager().removeDebuggerListener((DebuggerManagerListener)sessionListener);
                        }
                    }
                });
                this.getProject().addBuildListener(new BuildListener((ListeningConnector)flc, args, startedSessionRef){
                    final /* synthetic */ ListeningConnector val$flc;
                    final /* synthetic */ Map val$args;
                    final /* synthetic */ WeakReference[] val$startedSessionRef;
                    {
                        this.val$flc = listeningConnector;
                        this.val$args = map;
                        this.val$startedSessionRef = weakReferenceArray;
                    }

                    public void messageLogged(BuildEvent event) {
                    }

                    public void taskStarted(BuildEvent event) {
                    }

                    public void taskFinished(BuildEvent event) {
                    }

                    public void targetStarted(BuildEvent event) {
                    }

                    public void targetFinished(BuildEvent event) {
                    }

                    public void buildStarted(BuildEvent event) {
                    }

                    public void buildFinished(BuildEvent event) {
                        try {
                            this.val$flc.stopListening(this.val$args);
                        }
                        catch (IOException ioex) {
                        }
                        catch (IllegalConnectorArgumentsException iaex) {
                            // empty catch block
                        }
                        Session s = (Session)this.val$startedSessionRef[0].get();
                        if (s != null) {
                            s.kill();
                        }
                    }
                });
            }
            catch (IOException ioex) {
                this.lock[1] = ioex;
            }
            catch (IllegalConnectorArgumentsException icaex) {
                this.lock[1] = icaex;
            }
            catch (ThreadDeath td) {
                this.lock[1] = td;
            }
            finally {
                JPDAStart.debug("Notifying");
                this.lock.notify();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private MethodBreakpoint createBreakpoint(String stopClassName) {
        MethodBreakpoint breakpoint = MethodBreakpoint.create((String)stopClassName, (String)"*");
        breakpoint.setHidden(true);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)breakpoint);
        return breakpoint;
    }

    private ExceptionBreakpoint createCompilationErrorBreakpoint() {
        ExceptionBreakpoint b = ExceptionBreakpoint.create((String)"java.lang.RuntimeException", (int)2);
        b.setHidden(true);
        b.addJPDABreakpointListener(new JPDABreakpointListener(){

            public void breakpointReached(JPDABreakpointEvent event) {
                boolean suspend = false;
                try {
                    ObjectVariable ov;
                    JPDAClassType ct;
                    if (event.getVariable() instanceof ObjectVariable && (ct = (ov = (ObjectVariable)event.getVariable()).getClassType()) != null && (suspend = "java.lang.RuntimeException".equals(ct.getName()))) {
                        Method invokeMethodMethod = ov.getClass().getMethod("invokeMethod", JPDAThread.class, String.class, String.class, Variable[].class);
                        invokeMethodMethod.setAccessible(true);
                        Variable message = (Variable)invokeMethodMethod.invoke((Object)ov, event.getThread(), "getMessage", "()Ljava/lang/String;", new Variable[0]);
                        if (message != null) {
                            suspend = message.getValue().startsWith("\"Uncompilable source code");
                        }
                    }
                }
                catch (IllegalAccessException iaex) {
                    logger.log(Level.FINE, null, iaex);
                }
                catch (InvocationTargetException itex) {
                    logger.log(Level.FINE, null, itex);
                }
                catch (NoSuchMethodException ex) {
                    logger.log(Level.FINE, null, ex);
                }
                if (!suspend) {
                    event.resume();
                }
            }
        });
        b.setPrintText(NbBundle.getBundle((String)"org/netbeans/modules/debugger/jpda/ant/Bundle").getString("MSG_StoppedOnCompileError"));
        return b;
    }

    private static final void debug(String msg) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        logger.finer(new Date() + " [" + Thread.currentThread().getName() + "] - " + msg);
    }

    static ClassPath createSourcePath(Project project, Path classpath, Sourcepath sourcepath) {
        if (sourcepath != null && sourcepath.isExclusive()) {
            return JPDAStart.convertToClassPath(project, sourcepath);
        }
        ClassPath cp = JPDAStart.convertToSourcePath(project, classpath);
        ClassPath sp = JPDAStart.convertToClassPath(project, sourcepath);
        ClassPath sourcePath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cp, sp});
        return sourcePath;
    }

    static ClassPath createJDKSourcePath(Project project, Path bootclasspath) {
        if (bootclasspath == null) {
            JavaPlatform jp = JavaPlatform.getDefault();
            if (jp != null) {
                return jp.getSourceFolders();
            }
            return ClassPathSupport.createClassPath((List)Collections.EMPTY_LIST);
        }
        return JPDAStart.convertToSourcePath(project, bootclasspath);
    }

    private static ClassPath convertToClassPath(Project project, Path path) {
        String[] paths = path == null ? new String[]{} : path.list();
        ArrayList<URL> l = new ArrayList<URL>();
        int k = paths.length;
        for (int i = 0; i < k; ++i) {
            URL url;
            String pathName = project.replaceProperties(paths[i]);
            File f = FileUtil.normalizeFile((File)project.resolveFile(pathName));
            if (!JPDAStart.isValid(f, project) || (url = JPDAStart.fileToURL(f, project)) == null) continue;
            l.add(url);
        }
        URL[] urls = l.toArray(new URL[l.size()]);
        return ClassPathSupport.createClassPath((URL[])urls);
    }

    private static ClassPath convertToSourcePath(Project project, Path path) {
        String[] paths = path == null ? new String[]{} : path.list();
        ArrayList<PathResourceImplementation> l = new ArrayList<PathResourceImplementation>();
        HashSet<URL> exist = new HashSet<URL>();
        int k = paths.length;
        for (int i = 0; i < k; ++i) {
            URL url;
            String pathName = project.replaceProperties(paths[i]);
            File file = FileUtil.normalizeFile((File)project.resolveFile(pathName));
            if (!JPDAStart.isValid(file, project) || (url = JPDAStart.fileToURL(file, project)) == null) continue;
            logger.fine("convertToSourcePath - class: " + url);
            try {
                SourceForBinaryQuery.Result srcRootsResult = SourceForBinaryQuery.findSourceRoots((URL)url);
                FileObject[] fos = srcRootsResult.getRoots();
                int jj = fos.length;
                logger.fine("  source roots = " + Arrays.asList(fos) + "; jj = " + jj);
                for (int j = 0; j < jj; ++j) {
                    logger.fine("convertToSourcePath - source : " + fos[j]);
                    if (FileUtil.isArchiveFile((FileObject)fos[j])) {
                        fos[j] = FileUtil.getArchiveRoot((FileObject)fos[j]);
                    }
                    try {
                        url = fos[j].getURL();
                    }
                    catch (FileStateInvalidException ex) {
                        ErrorManager.getDefault().notify(4096, (Throwable)ex);
                        continue;
                    }
                    if (url == null || exist.contains(url)) continue;
                    l.add(ClassPathSupport.createResource((URL)url));
                    exist.add(url);
                }
                continue;
            }
            catch (IllegalArgumentException ex) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
                logger.fine("Have illegal url! " + ex.getLocalizedMessage());
            }
        }
        return ClassPathSupport.createClassPath(l);
    }

    private static URL fileToURL(File file, Project project) {
        try {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) {
                project.log("Have no FileObject for " + file.getAbsolutePath(), 1);
                return null;
            }
            if (FileUtil.isArchiveFile((FileObject)fileObject) && (fileObject = FileUtil.getArchiveRoot((FileObject)fileObject)) == null) {
                project.log("Bad archive " + file.getAbsolutePath(), 1);
                return null;
            }
            return fileObject.getURL();
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
            return null;
        }
    }

    private static boolean isValid(File f, Project project) {
        if (f.getPath().indexOf("${") != -1 && !f.exists()) {
            project.log("Classpath item " + f + " will be ignored.", 3);
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Listener
    extends DebuggerManagerAdapter {
        private Set debuggers = new HashSet();
        private Breakpoint first;
        private final List<Breakpoint> artificalBreakpoints;
        private final Map<URL, BuildArtifactMapper.ArtifactsUpdated> listeners;
        private final WeakReference<Session>[] startedSessionRef;

        private Listener(Breakpoint first, List<Breakpoint> artificalBreakpoints, Map<URL, BuildArtifactMapper.ArtifactsUpdated> listeners, WeakReference<Session>[] startedSessionRef) {
            this.first = first;
            this.artificalBreakpoints = artificalBreakpoints;
            this.listeners = listeners;
            this.startedSessionRef = startedSessionRef;
        }

        public void propertyChange(final PropertyChangeEvent e) {
            int state;
            if ("state".equals(e.getPropertyName()) && (state = ((Integer)e.getNewValue()).intValue()) == 3) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (Listener.this.first != null) {
                            DebuggerManager.getDebuggerManager().removeBreakpoint(Listener.this.first);
                            Listener.this.first = null;
                            ((JPDADebugger)e.getSource()).removePropertyChangeListener((PropertyChangeListener)((Object)Listener.this));
                        }
                    }
                });
            }
        }

        private void dispose() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("debuggerEngines", (DebuggerManagerListener)this);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    if (Listener.this.artificalBreakpoints != null) {
                        for (Breakpoint breakpoint : Listener.this.artificalBreakpoints) {
                            DebuggerManager.getDebuggerManager().removeBreakpoint(breakpoint);
                        }
                    }
                    if (Listener.this.first != null) {
                        DebuggerManager.getDebuggerManager().removeBreakpoint(Listener.this.first);
                    }
                    if (Listener.this.listeners != null) {
                        for (Map.Entry entry : Listener.this.listeners.entrySet()) {
                            BuildArtifactMapper.removeArtifactsUpdatedListener((URL)((URL)entry.getKey()), (BuildArtifactMapper.ArtifactsUpdated)((BuildArtifactMapper.ArtifactsUpdated)entry.getValue()));
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void engineAdded(DebuggerEngine engine) {
            WeakReference<Session>[] weakReferenceArray = this.startedSessionRef;
            synchronized (this.startedSessionRef) {
                Session s = (Session)this.startedSessionRef[0].get();
                // ** MonitorExit[var3_2] (shouldn't be in output)
                if (s == null) {
                    return;
                }
                boolean haveEngine = false;
                for (String l : s.getSupportedLanguages()) {
                    if (!engine.equals(s.getEngineForLanguage(l))) continue;
                    haveEngine = true;
                    break;
                }
                if (!haveEngine) {
                    return;
                }
                JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
                if (debugger == null) {
                    return;
                }
                debugger.addPropertyChangeListener("state", (PropertyChangeListener)((Object)this));
                this.debuggers.add(debugger);
                return;
            }
        }

        public void engineRemoved(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            if (this.debuggers.remove(debugger) && this.debuggers.isEmpty()) {
                debugger.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
                this.dispose();
            }
        }
    }

    public static class Sourcepath
    extends Path {
        private boolean isExclusive;

        public Sourcepath(Project p) {
            super(p);
        }

        public void setExclusive(String exclusive) {
            this.isExclusive = "true".equalsIgnoreCase(exclusive);
        }

        boolean isExclusive() {
            return this.isExclusive;
        }
    }
}

