/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RootObj;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public final class FileBasedURLMapper
extends URLMapper {
    public final URL getURL(FileObject fileObject, int n) {
        if (n == 2) {
            return null;
        }
        URL uRL = null;
        try {
            if (fileObject instanceof BaseFileObj) {
                BaseFileObj baseFileObj = (BaseFileObj)fileObject;
                uRL = FileBasedURLMapper.fileToURL(baseFileObj.getFileName().getFile(), fileObject);
            } else if (fileObject instanceof RootObj) {
                RootObj rootObj = (RootObj)fileObject;
                return this.getURL((FileObject)rootObj.getRealRoot(), n);
            }
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL;
    }

    public final FileObject[] getFileObjects(URL uRL) {
        File file;
        if (!"file".equals(uRL.getProtocol())) {
            return null;
        }
        if (uRL.getPath().equals("//") || uRL.getPath().equals("////")) {
            return null;
        }
        FileObject fileObject = null;
        try {
            file = FileUtil.normalizeFile((File)new File(uRL.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            Exceptions.printStackTrace((Throwable)uRISyntaxException);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)illegalArgumentException, (String)("URL=" + uRL)));
            return null;
        }
        fileObject = FileBasedFileSystem.getFileObject(file, FileObjectFactory.Caller.ToFileObject);
        return new FileObject[]{fileObject};
    }

    private static URL fileToURL(File file, FileObject fileObject) throws MalformedURLException {
        String string;
        URL uRL = file.toURI().toURL();
        if (fileObject.isFolder() && !(string = uRL.toExternalForm()).endsWith("/")) {
            uRL = new URL(string + "/");
        }
        return uRL;
    }
}

