/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.templates;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GrailsTargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final String NEW_CLASS_PREFIX = NbBundle.getMessage(GrailsTargetChooserPanelGUI.class, (String)"LBL_GrailsTargetChooserPanelGUI_NewArtifactPrefix");
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private Project project;
    private String expectedExtension;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private SourceGroup group;
    private JPanel bottomPanelContainer;
    private JLabel documentNameLabel;
    private JTextField documentNameTextField;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JTextField projectTextField;
    private JSeparator targetSeparator;
    private RequestProcessor.Task updatePackagesTask = null;
    private static final ComboBoxModel WAIT_MODEL = new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(GrailsTargetChooserPanelGUI.class, (String)"LBL_GrailsTargetChooserPanelGUI_PackageName_PleaseWait")});

    public GrailsTargetChooserPanelGUI(Project project, SourceGroup sourceGroup, Component component) {
        Component component2;
        this.project = project;
        this.group = sourceGroup;
        this.initComponents();
        this.packageComboBox.getEditor().addActionListener(this);
        this.documentNameTextField.getDocument().addDocumentListener(this);
        if (component != null) {
            this.bottomPanelContainer.add(component, "Center");
        }
        if ((component2 = this.packageComboBox.getEditor().getEditorComponent()) instanceof JTextField) {
            ((JTextField)component2).getDocument().addDocumentListener(this);
        } else {
            this.packageComboBox.addActionListener(this);
        }
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.setPreferredSize(PREF_DIM);
        this.setName(NbBundle.getBundle(GrailsTargetChooserPanelGUI.class).getString("LBL_GrailsTargetChooserPanelGUI_Name"));
    }

    public void addNotify() {
        Dimension dimension = this.jPanel2.getPreferredSize();
        Dimension dimension2 = this.bottomPanelContainer.getPreferredSize();
        Dimension dimension3 = this.targetSeparator.getPreferredSize();
        int n = dimension.height + dimension2.height + dimension3.height + 12;
        if (n > GrailsTargetChooserPanelGUI.PREF_DIM.height) {
            this.setPreferredSize(new Dimension(GrailsTargetChooserPanelGUI.PREF_DIM.width, n));
        }
        super.addNotify();
    }

    public void initValues(FileObject fileObject, FileObject fileObject2, String string) {
        String string2;
        DataObject dataObject;
        assert (this.project != null) : "Project must be specified.";
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        assert (fileObject != null);
        String string3 = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
            string3 = dataObject.getNodeDelegate().getDisplayName();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            string3 = fileObject.getName();
        }
        this.putClientProperty("NewFileWizard_Title", string3);
        dataObject = this.group;
        Object object = this.getPreselectedPackage((SourceGroup)dataObject, fileObject2, this.packageComboBox.getModel());
        if (object != null) {
            this.packageComboBox.getEditor().setItem(object);
        }
        if (fileObject != null && this.documentNameTextField.getText().trim().length() == 0) {
            String string4 = string2 = NEW_CLASS_PREFIX + fileObject.getName();
            if (fileObject2 != null) {
                FileObject fileObject3;
                int n = 0;
                while ((fileObject3 = fileObject2.getFileObject(string4, fileObject.getExt())) != null) {
                    string4 = string2 + ++n;
                }
            }
            this.documentNameTextField.setText(string4);
            this.documentNameTextField.selectAll();
        }
        this.updatePackages();
        if (string != null) {
            this.expectedExtension = string;
        } else {
            string2 = fileObject == null ? "" : fileObject.getExt();
            this.expectedExtension = string2.length() == 0 ? "" : "." + string2;
        }
        this.updateText();
    }

    public FileObject getRootFolder() {
        return this.group.getRootFolder();
    }

    public String getPackageFileName() {
        String string = this.packageComboBox.getEditor().getItem().toString();
        return string.replace('.', '/');
    }

    String getPackageName() {
        return this.packageComboBox.getEditor().getItem().toString();
    }

    public String getTargetName() {
        String string = this.documentNameTextField.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private void initComponents() {
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.documentNameLabel = new JLabel();
        this.documentNameTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.projectTextField = new JTextField();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.documentNameLabel.setLabelFor(this.documentNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.documentNameLabel, (String)NbBundle.getMessage(GrailsTargetChooserPanelGUI.class, (String)"LBL_GrailsTargetChooserPanelGUI_ClassName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.documentNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.documentNameTextField, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/groovy/grailsproject/templates/Bundle");
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_documentNameTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel5.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(GrailsTargetChooserPanelGUI.class, (String)"LBL_GrailsTargetChooserPanelGUI_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_projectTextField"));
        this.packageLabel.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(GrailsTargetChooserPanelGUI.class, (String)"LBL_GrailsTargetChooserPanelGUI_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.packageLabel, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.packageComboBox, gridBagConstraints);
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_packageComboBox"));
        this.fileLabel.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(GrailsTargetChooserPanelGUI.class, (String)"LBL_GrailsTargetChooserPanelGUI_CreatedFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.jPanel2.add((Component)this.fileLabel, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 12, 0);
        this.jPanel2.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_fileTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_JavaTargetChooserPanelGUI"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.packageComboBox == actionEvent.getSource()) {
            this.updateText();
            this.fireChange();
        } else if (this.packageComboBox.getEditor() == actionEvent.getSource()) {
            this.updateText();
            this.fireChange();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateText();
        this.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    private void updatePackages() {
        WAIT_MODEL.setSelectedItem(this.packageComboBox.getEditor().getItem());
        this.packageComboBox.setModel(WAIT_MODEL);
        if (this.updatePackagesTask != null) {
            this.updatePackagesTask.cancel();
        }
        this.updatePackagesTask = new RequestProcessor("ComboUpdatePackages").post(new Runnable(){
            private ComboBoxModel model;

            public void run() {
                if (!SwingUtilities.isEventDispatchThread()) {
                    this.model = PackageView.createListView((SourceGroup)GrailsTargetChooserPanelGUI.this.group);
                    SwingUtilities.invokeLater(this);
                } else {
                    this.model.setSelectedItem(GrailsTargetChooserPanelGUI.this.packageComboBox.getEditor().getItem());
                    GrailsTargetChooserPanelGUI.this.packageComboBox.setModel(this.model);
                }
            }
        });
    }

    private void updateText() {
        SourceGroup sourceGroup = this.group;
        FileObject fileObject = sourceGroup.getRootFolder();
        String string = this.getPackageFileName();
        String string2 = this.documentNameTextField.getText().trim();
        if (string2.length() > 0) {
            string2 = string2 + this.expectedExtension;
        }
        String string3 = FileUtil.getFileDisplayName((FileObject)fileObject) + (string.startsWith("/") || string.startsWith(File.separator) ? "" : "/") + string + (string.endsWith("/") || string.endsWith(File.separator) || string.length() == 0 ? "" : "/") + string2;
        this.fileTextField.setText(string3.replace('/', File.separatorChar));
    }

    private Object getPreselectedPackage(SourceGroup sourceGroup, FileObject fileObject, ListModel listModel) {
        if (fileObject == null) {
            return null;
        }
        FileObject fileObject2 = sourceGroup.getRootFolder();
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        if (string == null) {
            return null;
        }
        String string2 = string.replace('/', '.');
        return string2;
    }

    private static final class GroupListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            SourceGroup sourceGroup = (SourceGroup)object;
            super.getListCellRendererComponent((JList<?>)jList, sourceGroup.getDisplayName(), n, bl, bl2);
            this.setIcon(sourceGroup.getIcon(false));
            return this;
        }
    }
}

