/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsActionProvider;
import org.netbeans.modules.groovy.grailsproject.GrailsProjectOperations;
import org.netbeans.modules.groovy.grailsproject.GrailsServerState;
import org.netbeans.modules.groovy.grailsproject.GrailsSources;
import org.netbeans.modules.groovy.grailsproject.classpath.ClassPathProviderImpl;
import org.netbeans.modules.groovy.grailsproject.classpath.SourceRoots;
import org.netbeans.modules.groovy.grailsproject.commands.GrailsCommandSupport;
import org.netbeans.modules.groovy.grailsproject.completion.ControllerCompletionProvider;
import org.netbeans.modules.groovy.grailsproject.completion.DomainCompletionProvider;
import org.netbeans.modules.groovy.grailsproject.config.BuildConfig;
import org.netbeans.modules.groovy.grailsproject.queries.GrailsProjectEncodingQueryImpl;
import org.netbeans.modules.groovy.grailsproject.ui.GrailsLogicalViewProvider;
import org.netbeans.modules.groovy.grailsproject.ui.customizer.GrailsProjectCustomizerProvider;
import org.netbeans.modules.groovy.support.spi.GroovyFeature;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;
import org.w3c.dom.Element;

public final class GrailsProject
implements Project {
    private static final Logger LOG = Logger.getLogger(GrailsProject.class.getName());
    private final FileObject projectDir;
    private final ProjectState projectState;
    private final LogicalViewProvider logicalView;
    private final ClassPathProviderImpl cpProvider;
    private final GrailsCommandSupport commandSupport;
    private final BuildConfig buildConfig;
    private SourceRoots sourceRoots;
    private SourceRoots testRoots;
    private Lookup lookup;

    public GrailsProject(FileObject fileObject, ProjectState projectState) {
        this.projectDir = fileObject;
        this.projectState = projectState;
        this.logicalView = new GrailsLogicalViewProvider(this);
        this.cpProvider = new ClassPathProviderImpl(this.getSourceRoots(), this.getTestSourceRoots(), FileUtil.toFile((FileObject)fileObject), this);
        this.commandSupport = new GrailsCommandSupport(this);
        this.buildConfig = new BuildConfig(this);
    }

    public static GrailsProject inferGrailsProject() {
        GrailsProject grailsProject;
        Lookup lookup;
        Lookup lookup2;
        Lookup lookup3 = WindowManager.getDefault().getRegistry().getActivatedNodes();
        if (lookup3 != null) {
            lookup2 = lookup3;
            int n = ((Lookup)lookup2).length;
            for (int i = 0; i < n; ++i) {
                lookup = lookup2[i];
                Project[] projectArray = GrailsProject.lookupGrailsProject(lookup.getLookup());
                if (projectArray == null) continue;
                return projectArray;
            }
        }
        if ((grailsProject = GrailsProject.lookupGrailsProject(lookup2 = Utilities.actionsGlobalContext())) != null) {
            return grailsProject;
        }
        FileObject fileObject = (FileObject)lookup2.lookup(FileObject.class);
        if (fileObject != null && (grailsProject = GrailsProject.lookupGrailsProject(FileOwnerQuery.getOwner((FileObject)fileObject))) != null) {
            return grailsProject;
        }
        lookup = OpenProjects.getDefault();
        grailsProject = GrailsProject.lookupGrailsProject(lookup.getMainProject());
        if (grailsProject != null) {
            return grailsProject;
        }
        for (Project project : lookup.getOpenProjects()) {
            grailsProject = GrailsProject.lookupGrailsProject(project);
            if (grailsProject == null) continue;
            return grailsProject;
        }
        return null;
    }

    private static GrailsProject lookupGrailsProject(Project project) {
        if (project != null) {
            return GrailsProject.lookupGrailsProject(project.getLookup());
        }
        return null;
    }

    private static GrailsProject lookupGrailsProject(Lookup lookup) {
        GrailsProject grailsProject = (GrailsProject)lookup.lookup(GrailsProject.class);
        if (grailsProject != null) {
            return grailsProject;
        }
        Project project = (Project)lookup.lookup(Project.class);
        if (project != null && (grailsProject = (GrailsProject)project.getLookup().lookup(GrailsProject.class)) != null) {
            return grailsProject;
        }
        return null;
    }

    public FileObject getProjectDirectory() {
        return this.projectDir;
    }

    public ProjectState getProjectState() {
        return this.projectState;
    }

    public GrailsCommandSupport getCommandSupport() {
        return this.commandSupport;
    }

    public BuildConfig getBuildConfig() {
        return this.buildConfig;
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = Lookups.fixed((Object[])new Object[]{this, this.projectState, new Info(), new GrailsActionProvider(this), GrailsSources.create(this), new GrailsServerState(this), new GrailsProjectCustomizerProvider(this), new GrailsProjectOperations(this), new GrailsProjectEncodingQueryImpl(), new OpenHook(), new AuxiliaryConfigurationImpl(), new RecommendedTemplatesImpl(), new GroovyFeatureImpl(), new ControllerCompletionProvider(), new DomainCompletionProvider(), this.logicalView, this.cpProvider, new GrailsProjectConfig((Project)this)});
        }
        return this.lookup;
    }

    public synchronized SourceRoots getSourceRoots() {
        if (this.sourceRoots == null) {
            this.sourceRoots = new SourceRoots(this, this.projectDir);
        }
        return this.sourceRoots;
    }

    public synchronized SourceRoots getTestSourceRoots() {
        if (this.testRoots == null) {
            this.testRoots = new SourceRoots(this, this.projectDir);
        }
        return this.testRoots;
    }

    private static final class GroovyFeatureImpl
    implements GroovyFeature {
        private GroovyFeatureImpl() {
        }

        public boolean isGroovyEnabled() {
            return true;
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] RECOMMENDED_TYPES = new String[]{"groovy", "java-classes", "XML", "simple-files"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/Groovy/DomainClass.groovy", "Templates/Groovy/Controller.groovy", "Templates/Groovy/IntegrationTest.groovy", "Templates/Groovy/GantScript.groovy", "Templates/Groovy/Service.groovy", "Templates/Groovy/TagLib.groovy", "Templates/Groovy/UnitTest.groovy", "Templates/Other/Folder", "Templates/Other/properties.properties", "simple-files"};

        private RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return RECOMMENDED_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }
    }

    private static class AuxiliaryConfigurationImpl
    implements AuxiliaryConfiguration {
        private AuxiliaryConfigurationImpl() {
        }

        public Element getConfigurationFragment(String string, String string2, boolean bl) {
            return null;
        }

        public void putConfigurationFragment(Element element, boolean bl) throws IllegalArgumentException {
        }

        public boolean removeConfigurationFragment(String string, String string2, boolean bl) throws IllegalArgumentException {
            return false;
        }
    }

    private class OpenHook
    extends ProjectOpenedHook {
        private OpenHook() {
        }

        protected void projectOpened() {
            ClassPath[] classPathArray = GrailsProject.this.cpProvider.getProjectClassPaths("classpath/source");
            GlobalPathRegistry.getDefault().register("classpath/boot", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().register("classpath/compile", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/compile"));
            GlobalPathRegistry.getDefault().register("classpath/source", classPathArray);
        }

        protected void projectClosed() {
            GlobalPathRegistry.getDefault().unregister("classpath/boot", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().unregister("classpath/compile", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/compile"));
            GlobalPathRegistry.getDefault().unregister("classpath/source", GrailsProject.this.cpProvider.getProjectClassPaths("classpath/source"));
        }
    }

    private final class Info
    implements ProjectInformation {
        private Info() {
        }

        public Icon getIcon() {
            Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/groovy/grails/resources/GrailsIcon16x16.png");
            return image == null ? null : new ImageIcon(image);
        }

        public String getName() {
            return GrailsProject.this.getProjectDirectory().getName();
        }

        public String getDisplayName() {
            return this.getName();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public Project getProject() {
            return GrailsProject.this;
        }
    }
}

