/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.folding;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.editor.parser.CppFoldRecord;
import org.netbeans.modules.cnd.folding.APTFoldingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class APTFoldingCommentFilter
implements TokenStream {
    private static final int COMMENTS_FOLD = 3;
    private static final int INITIAL_COMMENT_FOLD = 1;
    private static final int BLOCK_COMMENT_FOLD = 2;
    private static final int BEFORE_FIRST_TOKEN_STATE = 0;
    private static final int INIT_STATE = 1;
    private static final int AFTER_LINE_COMMENT = 3;
    private final TokenStream orig;
    private int state = 0;
    private int lastTokenLine = -1;
    private CppFoldRecord initialCommentFold = null;
    private List<CppFoldRecord> blockCommentFolds = new ArrayList<CppFoldRecord>();
    private List<CppFoldRecord> lineCommentFolds = new ArrayList<CppFoldRecord>();
    private APTToken firstLineComment = null;
    private APTToken lastLineComment = null;

    public APTFoldingCommentFilter(TokenStream tokenStream) {
        this.orig = tokenStream;
    }

    public Token nextToken() throws TokenStreamException {
        APTToken aPTToken = null;
        boolean bl = true;
        block5: while (bl) {
            aPTToken = (APTToken)this.orig.nextToken();
            switch (aPTToken.getType()) {
                case 219: {
                    this.createBlockCommentsFold(aPTToken);
                    continue block5;
                }
                case 220: {
                    if (this.lastTokenLine == aPTToken.getLine()) continue block5;
                    if (this.firstLineComment == null) {
                        this.firstLineComment = aPTToken;
                        this.state = 3;
                    }
                    this.lastLineComment = aPTToken;
                    continue block5;
                }
                case 1: {
                    bl = false;
                    this.createLineCommentsFoldIfNeeded();
                    continue block5;
                }
            }
            bl = false;
            this.lastTokenLine = aPTToken.getEndLine();
            this.createLineCommentsFoldIfNeeded();
        }
        return aPTToken;
    }

    public String toString() {
        String string = this.orig.toString();
        return string;
    }

    public void onPreprocNode(APT aPT) {
        switch (this.state) {
            case 0: {
                this.state = 1;
                break;
            }
            case 3: {
                this.createLineCommentsFoldIfNeeded();
            }
        }
    }

    public List<CppFoldRecord> getFolders() {
        ArrayList<CppFoldRecord> arrayList = new ArrayList<CppFoldRecord>(this.blockCommentFolds.size() + this.lineCommentFolds.size() + 1);
        if (this.initialCommentFold != null) {
            arrayList.add(this.initialCommentFold);
        }
        arrayList.addAll(this.blockCommentFolds);
        arrayList.addAll(this.lineCommentFolds);
        return arrayList;
    }

    private void createLineCommentsFoldIfNeeded() {
        if (this.state == 3) {
            if (this.firstLineComment != this.lastLineComment) {
                assert (this.firstLineComment != null);
                assert (this.lastLineComment != null);
                this.lineCommentFolds.add(this.createFoldRecord(3, this.firstLineComment, this.lastLineComment));
            }
            this.firstLineComment = null;
            this.lastLineComment = null;
            this.state = 1;
        }
    }

    private void createBlockCommentsFold(APTToken aPTToken) {
        this.createLineCommentsFoldIfNeeded();
        if (this.state == 0) {
            assert (this.initialCommentFold == null) : "how there could be two copyrights?";
            this.initialCommentFold = this.createFoldRecord(1, aPTToken, aPTToken);
        } else {
            this.blockCommentFolds.add(this.createFoldRecord(2, aPTToken, aPTToken));
        }
        this.state = 1;
    }

    private CppFoldRecord createFoldRecord(int n, APTToken aPTToken, APTToken aPTToken2) {
        if (APTFoldingUtils.isStandalone()) {
            return new CppFoldRecord(n, aPTToken.getLine(), aPTToken.getColumn(), aPTToken2.getEndLine(), aPTToken2.getEndColumn());
        }
        return new CppFoldRecord(n, aPTToken.getOffset(), aPTToken2.getEndOffset());
    }
}

