/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.ricoh.dalp;

import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.j2me.cdc.project.ricoh.dalp.DalpParserHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class DalpParser
implements ContentHandler {
    private StringBuffer buffer;
    private DalpParserHandler handler;
    private Stack context;
    private EntityResolver resolver;

    public DalpParser(DalpParserHandler dalpParserHandler, EntityResolver entityResolver) {
        this.handler = dalpParserHandler;
        this.resolver = entityResolver;
        this.buffer = new StringBuffer(111);
        this.context = new Stack();
    }

    public final void setDocumentLocator(Locator locator) {
    }

    public final void startDocument() throws SAXException {
    }

    public final void endDocument() throws SAXException {
    }

    public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.dispatch(true);
        this.context.push(new Object[]{string3, new AttributesImpl(attributes)});
        if ("jar".equals(string3)) {
            this.handler.handle_jar(attributes);
        } else if ("dsdk".equals(string3)) {
            this.handler.handle_dsdk(attributes);
        } else if ("install".equals(string3)) {
            this.handler.handle_install(attributes);
        } else if ("dalp".equals(string3)) {
            this.handler.start_dalp(attributes);
        } else if ("resources".equals(string3)) {
            this.handler.start_resources(attributes);
        } else if ("offline-allowed".equals(string3)) {
            this.handler.handle_offline_allowed(attributes);
        } else if ("application-desc".equals(string3)) {
            this.handler.handle_application_desc(attributes);
        } else if ("all-permissions".equals(string3)) {
            this.handler.handle_all_permissions(attributes);
        } else if ("information".equals(string3)) {
            this.handler.start_information(attributes);
        } else if ("security".equals(string3)) {
            this.handler.start_security(attributes);
        }
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        this.dispatch(false);
        this.context.pop();
        if ("dalp".equals(string3)) {
            this.handler.end_dalp();
        } else if ("resources".equals(string3)) {
            this.handler.end_resources();
        } else if ("information".equals(string3)) {
            this.handler.end_information();
        } else if ("security".equals(string3)) {
            this.handler.end_security();
        }
    }

    public final void characters(char[] cArray, int n, int n2) throws SAXException {
        this.buffer.append(cArray, n, n2);
    }

    public final void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public final void processingInstruction(String string, String string2) throws SAXException {
    }

    public final void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public final void endPrefixMapping(String string) throws SAXException {
    }

    public final void skippedEntity(String string) throws SAXException {
    }

    private void dispatch(boolean bl) throws SAXException {
        if (bl && this.buffer.length() == 0) {
            return;
        }
        Object[] objectArray = (Object[])this.context.peek();
        String string = (String)objectArray[0];
        Attributes attributes = (Attributes)objectArray[1];
        if ("application-ver".equals(string)) {
            if (bl) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_application_ver(this.buffer.length() == 0 ? null : this.buffer.toString(), attributes);
        } else if ("vendor".equals(string)) {
            if (bl) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_vendor(this.buffer.length() == 0 ? null : this.buffer.toString(), attributes);
        } else if ("encode-file".equals(string)) {
            if (bl) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_encode_file(this.buffer.length() == 0 ? null : this.buffer.toString(), attributes);
        } else if ("title".equals(string)) {
            if (bl) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_title(this.buffer.length() == 0 ? null : this.buffer.toString(), attributes);
        } else if ("telephone".equals(string)) {
            if (bl) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_telephone(this.buffer.length() == 0 ? null : this.buffer.toString(), attributes);
        } else if ("fax".equals(string)) {
            if (bl) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_fax(this.buffer.length() == 0 ? null : this.buffer.toString(), attributes);
        } else if ("e-mail".equals(string)) {
            if (bl) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_e_mail(this.buffer.length() == 0 ? null : this.buffer.toString(), attributes);
        } else if ("product-id".equals(string)) {
            if (bl) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_product_id(this.buffer.length() == 0 ? null : this.buffer.toString(), attributes);
        } else if ("icon".equals(string)) {
            if (bl) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_icon(this.buffer.length() == 0 ? null : this.buffer.toString(), attributes);
        } else if ("description".equals(string)) {
            if (bl) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_description(this.buffer.length() == 0 ? null : this.buffer.toString(), attributes);
        } else if ("argument".equals(string)) {
            if (bl) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_argument(this.buffer.length() == 0 ? null : this.buffer.toString(), attributes);
        }
        this.buffer.delete(0, this.buffer.length());
    }

    public void parse(InputSource inputSource) throws SAXException, ParserConfigurationException, IOException {
        DalpParser.parse(inputSource, this);
    }

    public void parse(URL uRL) throws SAXException, ParserConfigurationException, IOException {
        DalpParser.parse(new InputSource(uRL.toExternalForm()), this);
    }

    public static void parse(InputSource inputSource, DalpParserHandler dalpParserHandler) throws SAXException, ParserConfigurationException, IOException {
        DalpParser.parse(inputSource, new DalpParser(dalpParserHandler, null));
    }

    public static void parse(URL uRL, DalpParserHandler dalpParserHandler) throws SAXException, ParserConfigurationException, IOException {
        DalpParser.parse(new InputSource(uRL.toExternalForm()), dalpParserHandler);
    }

    private static void parse(InputSource inputSource, DalpParser dalpParser) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(false);
        XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
        xMLReader.setContentHandler(dalpParser);
        xMLReader.setErrorHandler(dalpParser.getDefaultErrorHandler());
        if (dalpParser.resolver != null) {
            xMLReader.setEntityResolver(dalpParser.resolver);
        }
        xMLReader.parse(inputSource);
    }

    protected ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            public void error(SAXParseException sAXParseException) throws SAXException {
                if (DalpParser.this.context.isEmpty()) {
                    System.err.println("Missing DOCTYPE.");
                }
                throw sAXParseException;
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }

            public void warning(SAXParseException sAXParseException) throws SAXException {
            }
        };
    }
}

