/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer.editable;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.diff.DiffModuleConfig;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffContentPanel;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffMark;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffSplitPaneDivider;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffViewManager;
import org.netbeans.modules.diff.builtin.visualizer.editable.NoContentPanel;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.spi.diff.DiffControllerImpl;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class EditableDiffView
extends DiffControllerImpl
implements DiffView,
DocumentListener,
AncestorListener,
PropertyChangeListener,
PreferenceChangeListener {
    private static final int INITIAL_DIVIDER_SIZE = 32;
    private Stroke boldStroke = new BasicStroke(3.0f);
    private Color colorMissing;
    private Color colorAdded;
    private Color colorChanged;
    private Color colorLines = Color.DARK_GRAY;
    private Color COLOR_READONLY_BG = new Color(240, 240, 240);
    private final Difference[] NO_DIFFERENCES = new Difference[0];
    private DiffContentPanel jEditorPane1;
    private DiffContentPanel jEditorPane2;
    private boolean secondSourceAvailable;
    private boolean firstSourceAvailable;
    private final boolean binaryDiff;
    private JViewport jViewport2;
    final JLabel fileLabel1 = new JLabel();
    final JLabel fileLabel2 = new JLabel();
    final JPanel filePanel1 = new JPanel();
    final JPanel filePanel2 = new JPanel();
    final JSplitPane jSplitPane1 = new JSplitPane();
    private int diffSerial;
    private Difference[] diffs = this.NO_DIFFERENCES;
    private boolean ignoredUpdateEvents;
    private int horizontalScroll1ChangedValue = -1;
    private int horizontalScroll2ChangedValue = -1;
    private RequestProcessor.Task refreshDiffTask = RequestProcessor.getDefault().create((Runnable)new RefreshDiffTask());
    private DiffViewManager manager;
    private boolean actionsEnabled;
    private DiffSplitPaneUI spui;
    private Document baseDocument;
    private Document modifiedDocument;
    private EditorCookie.Observable editableCookie;
    private Document editableDocument;
    private UndoRedo.Manager editorUndoRedo;
    private EditableDiffMarkProvider diffMarkprovider;

    public EditableDiffView(final StreamSource streamSource, final StreamSource streamSource2) throws IOException {
        String string;
        this.initColors();
        String string2 = streamSource.getTitle();
        if (string2 == null) {
            string2 = NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_NoTitle");
        }
        if ((string = streamSource2.getTitle()) == null) {
            string = NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_NoTitle");
        }
        String string3 = streamSource.getMIMEType();
        String string4 = streamSource2.getMIMEType();
        if (string3 == null) {
            string3 = string4;
        }
        if (string4 == null) {
            string4 = string3;
        }
        this.binaryDiff = string3 == null || string4 == null || string3.equals("application/octet-stream") || string4.equals("application/octet-stream");
        this.actionsEnabled = streamSource2.isEditable();
        this.diffMarkprovider = new EditableDiffMarkProvider();
        this.initComponents();
        if (!this.binaryDiff) {
            this.jEditorPane2.getEditorPane().putClientProperty("org.netbeans.modules.diff.builtin.visualizer.editable.MarkProvider", (Object)this.diffMarkprovider);
        }
        this.jSplitPane1.setName(NbBundle.getMessage(EditableDiffView.class, (String)"DiffComponent.title", (Object)streamSource.getName(), (Object)streamSource2.getName()));
        this.spui = new DiffSplitPaneUI(this.jSplitPane1);
        this.jSplitPane1.setUI(this.spui);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jSplitPane1.setDividerSize(32);
        this.jSplitPane1.putClientProperty("PersistenceType", "Never");
        this.jSplitPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_DiffPanelA11yName"));
        this.jSplitPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_DiffPanelA11yDesc"));
        this.setSourceTitle(this.fileLabel1, string2);
        this.setSourceTitle(this.fileLabel2, string);
        final String string5 = string3;
        final String string6 = string4;
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    NoContentPanel noContentPanel;
                    Color color = UIManager.getColor("scrollpane_border");
                    if (color == null) {
                        color = UIManager.getColor("controlShadow");
                    }
                    EditableDiffView.this.jSplitPane1.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, color));
                    if (EditableDiffView.this.binaryDiff) {
                        EditableDiffView.this.adjustPreferredSizes();
                        return;
                    }
                    EditableDiffView.this.jEditorPane1.getScrollPane().setBorder(null);
                    EditableDiffView.this.jEditorPane2.getScrollPane().setBorder(null);
                    EditableDiffView.this.jEditorPane1.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, color));
                    EditableDiffView.this.jEditorPane2.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, color));
                    EditableDiffView.this.jEditorPane1.getEditorPane().setEditorKit(CloneableEditorSupport.getEditorKit((String)string5));
                    EditableDiffView.this.jEditorPane2.getEditorPane().setEditorKit(CloneableEditorSupport.getEditorKit((String)string6));
                    try {
                        EditableDiffView.this.setSource1(streamSource);
                        EditableDiffView.this.setSource2(streamSource2);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(EditableDiffView.class.getName()).log(Level.INFO, "Diff source unavailable", iOException);
                    }
                    if (!EditableDiffView.this.secondSourceAvailable) {
                        EditableDiffView.this.filePanel2.remove(EditableDiffView.this.jEditorPane2);
                        noContentPanel = new NoContentPanel(NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_NoContent"));
                        noContentPanel.setPreferredSize(new Dimension(((EditableDiffView)EditableDiffView.this).jEditorPane1.getPreferredSize().width, noContentPanel.getPreferredSize().height));
                        EditableDiffView.this.filePanel2.add(noContentPanel);
                        EditableDiffView.this.actionsEnabled = false;
                    }
                    if (!EditableDiffView.this.firstSourceAvailable) {
                        EditableDiffView.this.filePanel1.remove(EditableDiffView.this.jEditorPane1);
                        noContentPanel = new NoContentPanel(NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_NoContent"));
                        noContentPanel.setPreferredSize(new Dimension(((EditableDiffView)EditableDiffView.this).jEditorPane2.getPreferredSize().width, noContentPanel.getPreferredSize().height));
                        EditableDiffView.this.filePanel1.add(noContentPanel);
                        EditableDiffView.this.actionsEnabled = false;
                    }
                    EditableDiffView.this.adjustPreferredSizes();
                    int n = EditableDiffView.this.jEditorPane2.getEditorPane().getBackground().getRGB() & 0xFFFFFF;
                    if (EditableDiffView.this.jEditorPane2.getEditorPane().isEditable() && n == 0xFFFFFF && System.getProperty("netbeans.experimental.diff.ReadonlyBg") == null) {
                        EditableDiffView.this.jEditorPane1.getEditorPane().setBackground(EditableDiffView.this.COLOR_READONLY_BG);
                    }
                    if (n == 0) {
                        EditableDiffView.this.colorLines = Color.WHITE;
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(EditableDiffView.class.getName()).log(Level.SEVERE, ".colorLines:" + this.colorLines + ", .jviewPort2:" + this.jViewport2 + ", editableDocument:" + this.editableDocument + ", editableCookie:" + this.editableCookie + ", editorUndoRedo:" + this.editorUndoRedo, interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(EditableDiffView.class.getName()).log(Level.SEVERE, ".colorLines:" + this.colorLines + ", .jviewPort2:" + this.jViewport2 + ", editableDocument:" + this.editableDocument + ", editableCookie:" + this.editableCookie + ", editorUndoRedo:" + this.editorUndoRedo, invocationTargetException);
        }
        if (this.binaryDiff) {
            return;
        }
        this.jSplitPane1.addAncestorListener(this);
        this.refreshDiffTask.run();
        this.manager = new DiffViewManager(this);
        this.manager.init();
    }

    private void adjustPreferredSizes() {
        Dimension dimension = this.fileLabel1.getPreferredSize();
        Dimension dimension2 = this.fileLabel2.getPreferredSize();
        if (dimension.width > dimension2.width) {
            this.fileLabel2.setPreferredSize(new Dimension(dimension.width, dimension2.height));
        } else {
            this.fileLabel1.setPreferredSize(new Dimension(dimension2.width, dimension.height));
        }
    }

    public void setLocation(final DiffController.DiffPane diffPane, final DiffController.LocationType locationType, final int n) {
        this.manager.runWithSmartScrollingDisabled(new Runnable(){

            public void run() {
                if (locationType == DiffController.LocationType.DifferenceIndex) {
                    EditableDiffView.this.setDifferenceImpl(n);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (diffPane == DiffController.DiffPane.Base) {
                                EditableDiffView.this.setBaseLineNumberImpl(n);
                            } else {
                                EditableDiffView.this.setModifiedLineNumberImpl(n);
                            }
                        }
                    });
                }
            }
        });
    }

    private void setModifiedLineNumberImpl(int n) {
        this.initGlobalSizes();
        try {
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.jEditorPane2.getEditorPane());
            if (editorUI == null) {
                return;
            }
            int n2 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane2.getEditorPane().getDocument()), (int)n);
            this.jEditorPane2.getEditorPane().setCaretPosition(n2);
            int n3 = editorUI.getLineHeight();
            int n4 = this.jEditorPane2.getScrollPane().getViewport().getViewRect().height / 2 + 1;
            int n5 = n3 * n - n4;
            JScrollBar jScrollBar = this.jEditorPane2.getScrollPane().getVerticalScrollBar();
            jScrollBar.setValue(n5);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Logger.getLogger(EditableDiffView.class.getName()).log(Level.INFO, null, indexOutOfBoundsException);
        }
    }

    private void setBaseLineNumberImpl(int n) {
        this.initGlobalSizes();
        try {
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.jEditorPane1.getEditorPane());
            if (editorUI == null) {
                return;
            }
            int n2 = editorUI.getLineHeight();
            int n3 = this.jEditorPane1.getScrollPane().getViewport().getViewRect().height / 2 + 1;
            int n4 = n2 * n - n3;
            int n5 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane1.getEditorPane().getDocument()), (int)n);
            this.jEditorPane1.getEditorPane().setCaretPosition(n5);
            JScrollBar jScrollBar = this.jEditorPane1.getScrollPane().getVerticalScrollBar();
            JScrollBar jScrollBar2 = this.jEditorPane2.getScrollPane().getVerticalScrollBar();
            jScrollBar.setValue(n4);
            jScrollBar2.setValue(n4);
            this.updateCurrentDifference();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ErrorManager.getDefault().notify((Throwable)indexOutOfBoundsException);
        }
    }

    private void setDifferenceImpl(int n) {
        if (n < -1 || n >= this.diffs.length) {
            throw new IllegalArgumentException("Illegal difference number: " + n);
        }
        if (n != -1) {
            this.setDifferenceIndex(n);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditableDiffView.this.ignoredUpdateEvents = true;
                    EditableDiffView.this.showCurrentDifference();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            EditableDiffView.this.ignoredUpdateEvents = false;
                        }
                    });
                }
            });
        }
    }

    public JComponent getJComponent() {
        return this.jSplitPane1;
    }

    public boolean isActionsEnabled() {
        return this.actionsEnabled;
    }

    private void initColors() {
        this.colorMissing = DiffModuleConfig.getDefault().getDeletedColor();
        this.colorAdded = DiffModuleConfig.getDefault().getAddedColor();
        this.colorChanged = DiffModuleConfig.getDefault().getChangedColor();
    }

    private void addDocumentListeners() {
        if (this.baseDocument != null) {
            this.baseDocument.addDocumentListener(this);
        }
        if (this.modifiedDocument != null) {
            this.modifiedDocument.addDocumentListener(this);
        }
    }

    private void removeDocumentListeners() {
        if (this.baseDocument != null) {
            this.baseDocument.removeDocumentListener(this);
        }
        if (this.modifiedDocument != null) {
            this.modifiedDocument.removeDocumentListener(this);
        }
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        DiffModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.expandFolds();
        this.initGlobalSizes();
        this.addChangeListeners();
        this.addDocumentListeners();
        this.refreshDiff(50);
        if (this.editableCookie == null) {
            return;
        }
        this.refreshEditableDocument();
        this.editableCookie.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void refreshEditableDocument() {
        StyledDocument styledDocument = null;
        try {
            styledDocument = this.editableCookie.openDocument();
        }
        catch (IOException iOException) {
            Logger.getLogger(EditableDiffView.class.getName()).log(Level.INFO, "Getting new Document from EditorCookie", iOException);
            return;
        }
        this.editableDocument.removeDocumentListener(this);
        if (styledDocument != this.editableDocument) {
            this.editableDocument = styledDocument;
            this.jEditorPane2.getEditorPane().setDocument(this.editableDocument);
            this.refreshDiff(20);
        }
        this.editableDocument.addDocumentListener(this);
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        DiffModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        this.removeDocumentListeners();
        if (this.editableCookie != null) {
            this.saveModifiedDocument();
            this.editableCookie.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.editableCookie.getOpenedPanes() == null) {
                this.editableCookie.close();
            }
        }
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        this.initColors();
        this.diffChanged();
        this.refreshDiff(20);
    }

    private void saveModifiedDocument() {
        SaveCookie saveCookie;
        DataObject dataObject = (DataObject)this.editableDocument.getProperty("stream");
        if (dataObject != null && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
            try {
                saveCookie.save();
            }
            catch (IOException iOException) {
                Logger.getLogger(EditableDiffView.class.getName()).log(Level.INFO, "Error saving Diff document", iOException);
            }
        }
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.refreshDiff(50);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.refreshDiff(50);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.refreshDiff(50);
    }

    Color getColor(Difference difference) {
        if (difference.getType() == 1) {
            return this.colorAdded;
        }
        if (difference.getType() == 2) {
            return this.colorChanged;
        }
        return this.colorMissing;
    }

    JComponent getMyDivider() {
        return this.spui.divider.getDivider();
    }

    DiffContentPanel getEditorPane1() {
        return this.jEditorPane1;
    }

    DiffContentPanel getEditorPane2() {
        return this.jEditorPane2;
    }

    public DiffViewManager getManager() {
        return this.manager;
    }

    Difference[] getDifferences() {
        return this.diffs;
    }

    private void replace(final StyledDocument styledDocument, final int n, final int n2, final String string) {
        NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(){

            public void run() {
                try {
                    styledDocument.remove(n, n2);
                    styledDocument.insertString(n, string, null);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
                }
            }
        });
    }

    void rollback(Difference difference) {
        StyledDocument styledDocument = (StyledDocument)this.getEditorPane2().getEditorPane().getDocument();
        if (difference == null) {
            Document document = this.getEditorPane1().getEditorPane().getDocument();
            try {
                this.replace(styledDocument, 0, styledDocument.getLength(), document.getText(0, document.getLength()));
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            return;
        }
        try {
            if (difference.getType() == 1) {
                int n = DiffViewManager.getRowStartFromLineOffset(styledDocument, difference.getSecondStart() - 1);
                int n2 = DiffViewManager.getRowStartFromLineOffset(styledDocument, difference.getSecondEnd());
                if (n2 == -1) {
                    n2 = styledDocument.getLength();
                }
                styledDocument.remove(n, n2 - n);
            } else if (difference.getType() == 0) {
                int n = DiffViewManager.getRowStartFromLineOffset(styledDocument, difference.getSecondStart());
                String string = difference.getFirstText();
                if (n == -1) {
                    n = styledDocument.getLength();
                    string = EditableDiffView.switchLineEndings(string);
                }
                styledDocument.insertString(n, string, null);
            } else {
                int n = DiffViewManager.getRowStartFromLineOffset(styledDocument, difference.getSecondStart() - 1);
                int n3 = DiffViewManager.getRowStartFromLineOffset(styledDocument, difference.getSecondEnd());
                if (n3 == -1) {
                    n3 = styledDocument.getLength();
                }
                this.replace(styledDocument, n, n3 - n, difference.getFirstText());
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    private static String switchLineEndings(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.insert(0, '\n');
        if (stringBuilder.charAt(stringBuilder.length() - 1) == '\n') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    Stroke getBoldStroke() {
        return this.boldStroke;
    }

    public boolean requestFocusInWindow() {
        return this.jEditorPane1.requestFocusInWindow();
    }

    public JComponent getComponent() {
        return this.jSplitPane1;
    }

    public int getDifferenceCount() {
        return this.diffs.length;
    }

    public boolean canSetCurrentDifference() {
        return true;
    }

    public void setCurrentDifference(int n) throws UnsupportedOperationException {
        this.setLocation(null, DiffController.LocationType.DifferenceIndex, n);
    }

    public int getCurrentDifference() {
        return this.getDifferenceIndex();
    }

    private int computeCurrentDifference() {
        if (this.manager == null || this.jViewport2 == null) {
            return 0;
        }
        Rectangle rectangle = this.jViewport2.getViewRect();
        int n = rectangle.y + rectangle.height * 4 / 5;
        DiffViewManager.DecoratedDifference[] decoratedDifferenceArray = this.manager.getDecorations();
        for (int i = 0; i < decoratedDifferenceArray.length; ++i) {
            int n2 = decoratedDifferenceArray[i].getTopRight();
            int n3 = decoratedDifferenceArray[i].getBottomRight();
            if (n3 <= n && (n3 != -1 || n2 <= n)) continue;
            return Math.max(0, i - 1);
        }
        return decoratedDifferenceArray.length - 1;
    }

    void updateCurrentDifference() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.ignoredUpdateEvents) {
            return;
        }
        int n = this.computeCurrentDifference();
        this.setDifferenceIndex(n);
    }

    public JToolBar getToolBar() {
        return null;
    }

    private void showCurrentDifference() {
        Difference difference = this.diffs[this.getDifferenceIndex()];
        this.initGlobalSizes();
        try {
            int n = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane1.getEditorPane().getDocument()), (int)(difference.getFirstStart() > 0 ? difference.getFirstStart() - 1 : 0));
            int n2 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane2.getEditorPane().getDocument()), (int)(difference.getSecondStart() > 0 ? difference.getSecondStart() - 1 : 0));
            this.jEditorPane1.getEditorPane().setCaretPosition(n);
            this.jEditorPane2.getEditorPane().setCaretPosition(n2);
            DiffViewManager.DecoratedDifference decoratedDifference = this.manager.getDecorations()[this.getDifferenceIndex()];
            int n3 = decoratedDifference.getDiff().getType() == 0 ? this.jEditorPane2.getScrollPane().getViewport().getViewRect().height / 2 + 1 : this.jEditorPane2.getScrollPane().getViewport().getViewRect().height / 5;
            this.jEditorPane2.getScrollPane().getVerticalScrollBar().setValue(decoratedDifference.getTopRight() - n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ErrorManager.getDefault().notify((Throwable)indexOutOfBoundsException);
        }
        this.manager.scroll();
    }

    private void initComponents() {
        this.fileLabel1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.fileLabel1.setHorizontalAlignment(0);
        this.filePanel1.setLayout(new BorderLayout());
        this.filePanel1.add((Component)this.fileLabel1, "First");
        this.fileLabel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.fileLabel2.setHorizontalAlignment(0);
        this.filePanel2.setLayout(new BorderLayout());
        this.filePanel2.add((Component)this.fileLabel2, "First");
        if (this.binaryDiff) {
            NoContentPanel noContentPanel = new NoContentPanel(NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_BinaryFile"));
            this.fileLabel1.setLabelFor(noContentPanel);
            this.filePanel1.add(noContentPanel);
            NoContentPanel noContentPanel2 = new NoContentPanel(NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_BinaryFile"));
            this.fileLabel2.setLabelFor(noContentPanel2);
            this.filePanel2.add(noContentPanel2);
        } else {
            this.jEditorPane1 = new DiffContentPanel(this, true);
            this.jEditorPane2 = new DiffContentPanel(this, false);
            this.jEditorPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_EditorPane1A11yName"));
            this.jEditorPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_EditorPane1A11yDescr"));
            this.jEditorPane2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_EditorPane2A11yName"));
            this.jEditorPane2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_EditorPane2A11yDescr"));
            this.fileLabel1.setLabelFor(this.jEditorPane1);
            this.filePanel1.add(this.jEditorPane1);
            this.fileLabel2.setLabelFor(this.jEditorPane2);
            this.filePanel2.add(this.jEditorPane2);
        }
        this.jSplitPane1.setLeftComponent(this.filePanel1);
        this.jSplitPane1.setRightComponent(this.filePanel2);
    }

    private void expandFolds(JEditorPane jEditorPane) {
        final FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jEditorPane);
        FoldUtilities.expandAll((FoldHierarchy)foldHierarchy);
        foldHierarchy.addFoldHierarchyListener(new FoldHierarchyListener(){

            public void foldHierarchyChanged(FoldHierarchyEvent foldHierarchyEvent) {
                FoldUtilities.expandAll((FoldHierarchy)foldHierarchy);
            }
        });
    }

    private void expandFolds() {
        this.expandFolds(this.jEditorPane1.getEditorPane());
        this.expandFolds(this.jEditorPane2.getEditorPane());
    }

    private void initGlobalSizes() {
        int n;
        int n2;
        int n3;
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getEditorPane().getDocument();
        StyledDocument styledDocument2 = (StyledDocument)this.jEditorPane2.getEditorPane().getDocument();
        int n4 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)styledDocument.getEndPosition().getOffset());
        int n5 = Math.max(n4, n3 = NbDocument.findLineNumber((StyledDocument)styledDocument2, (int)styledDocument2.getEndPosition().getOffset()));
        if (n5 < 1) {
            n5 = 1;
        }
        if ((n2 = this.jEditorPane2.getSize().height) > (n = this.jEditorPane1.getSize().height)) {
            n = n2;
        }
    }

    private void joinScrollBars() {
        final JScrollBar jScrollBar = this.jEditorPane1.getScrollPane().getHorizontalScrollBar();
        final JScrollBar jScrollBar2 = this.jEditorPane2.getScrollPane().getHorizontalScrollBar();
        jScrollBar.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar.getValue();
                if (n == EditableDiffView.this.horizontalScroll1ChangedValue) {
                    return;
                }
                int n2 = jScrollBar.getMaximum();
                int n3 = jScrollBar2.getMaximum();
                int n4 = jScrollBar.getModel().getExtent();
                int n5 = jScrollBar2.getModel().getExtent();
                if (n2 == n4) {
                    EditableDiffView.this.horizontalScroll2ChangedValue = 0;
                } else {
                    EditableDiffView.this.horizontalScroll2ChangedValue = n * (n3 - n5) / (n2 - n4);
                }
                EditableDiffView.this.horizontalScroll1ChangedValue = -1;
                jScrollBar2.setValue(EditableDiffView.this.horizontalScroll2ChangedValue);
            }
        });
        jScrollBar2.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar2.getValue();
                if (n == EditableDiffView.this.horizontalScroll2ChangedValue) {
                    return;
                }
                int n2 = jScrollBar.getMaximum();
                int n3 = jScrollBar2.getMaximum();
                int n4 = jScrollBar.getModel().getExtent();
                int n5 = jScrollBar2.getModel().getExtent();
                if (n3 == n5) {
                    EditableDiffView.this.horizontalScroll1ChangedValue = 0;
                } else {
                    EditableDiffView.this.horizontalScroll1ChangedValue = n * (n2 - n4) / (n3 - n5);
                }
                EditableDiffView.this.horizontalScroll2ChangedValue = -1;
                jScrollBar.setValue(EditableDiffView.this.horizontalScroll1ChangedValue);
            }
        });
    }

    private void customizeEditor(JEditorPane jEditorPane) {
        Document document = jEditorPane.getDocument();
        try {
            StyledDocument styledDocument = (StyledDocument)jEditorPane.getDocument();
        }
        catch (ClassCastException classCastException) {
            DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
            try {
                defaultStyledDocument.insertString(0, document.getText(0, document.getLength()), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            jEditorPane.setDocument(defaultStyledDocument);
        }
    }

    private void addChangeListeners() {
        this.jEditorPane1.getEditorPane().addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditableDiffView.this.diffChanged();
                        EditableDiffView.this.initGlobalSizes();
                        EditableDiffView.this.jEditorPane1.onUISettingsChanged();
                        EditableDiffView.this.getComponent().revalidate();
                        EditableDiffView.this.getComponent().repaint();
                    }
                });
            }
        });
        this.jEditorPane2.getEditorPane().addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditableDiffView.this.diffChanged();
                        EditableDiffView.this.initGlobalSizes();
                        EditableDiffView.this.jEditorPane2.onUISettingsChanged();
                        EditableDiffView.this.getComponent().revalidate();
                        EditableDiffView.this.getComponent().repaint();
                    }
                });
            }
        });
    }

    private synchronized void diffChanged() {
        ++this.diffSerial;
    }

    private void setSource1(StreamSource streamSource) throws IOException {
        Document document;
        Document document2;
        this.firstSourceAvailable = false;
        EditorKit editorKit = this.jEditorPane1.getEditorPane().getEditorKit();
        if (editorKit == null) {
            throw new IOException("Missing Editor Kit");
        }
        this.baseDocument = document2 = this.getSourceDocument(streamSource);
        Document document3 = document = document2 != null ? document2 : editorKit.createDefaultDocument();
        if (!(document instanceof StyledDocument)) {
            document = new DefaultStyledDocument(new StyleContext());
            editorKit = new StyledEditorKit();
            this.jEditorPane1.getEditorPane().setEditorKit(editorKit);
        }
        if (document2 == null) {
            Reader reader = streamSource.createReader();
            if (reader != null) {
                this.firstSourceAvailable = true;
                try {
                    editorKit.read(reader, document, 0);
                }
                catch (BadLocationException badLocationException) {
                    throw new IOException("Can not locate the beginning of the document.");
                }
                finally {
                    reader.close();
                }
            }
        } else {
            this.firstSourceAvailable = true;
        }
        this.jEditorPane1.initActions();
        this.jEditorPane1.getEditorPane().setDocument(document);
        this.customizeEditor(this.jEditorPane1.getEditorPane());
    }

    private Document getSourceDocument(StreamSource streamSource) {
        Document document = null;
        FileObject fileObject = (FileObject)streamSource.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            try {
                EditorCookie editorCookie;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (dataObject.getPrimaryFile() == fileObject && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null) {
                    document = editorCookie.openDocument();
                }
            }
            catch (Exception exception) {}
        } else {
            document = (Document)streamSource.getLookup().lookup(Document.class);
        }
        return document;
    }

    private void setSource2(StreamSource streamSource) throws IOException {
        Object object;
        Document document;
        Document document2;
        this.secondSourceAvailable = false;
        EditorKit editorKit = this.jEditorPane2.getEditorPane().getEditorKit();
        if (editorKit == null) {
            throw new IOException("Missing Editor Kit");
        }
        this.modifiedDocument = document2 = this.getSourceDocument(streamSource);
        if (document2 != null && streamSource.isEditable() && (document = (DataObject)document2.getProperty("stream")) != null) {
            if (document instanceof MultiDataObject) {
                object = (MultiDataObject)document;
                for (MultiDataObject.Entry entry : object.secondaryEntries()) {
                    CookieSet.Factory factory;
                    EditorCookie editorCookie;
                    StyledDocument styledDocument;
                    if (!(entry instanceof CookieSet.Factory) || (styledDocument = (editorCookie = (EditorCookie)(factory = (CookieSet.Factory)entry).createCookie(EditorCookie.class)).getDocument()) != document2 || !(editorCookie instanceof EditorCookie.Observable)) continue;
                    this.editableCookie = (EditorCookie.Observable)editorCookie;
                    this.editableDocument = document2;
                    this.editorUndoRedo = this.getUndoRedo(editorCookie);
                }
            }
            if (this.editableCookie == null && (object = (EditorCookie)document.getCookie(EditorCookie.class)) instanceof EditorCookie.Observable) {
                this.editableCookie = (EditorCookie.Observable)object;
                this.editableDocument = document2;
                this.editorUndoRedo = this.getUndoRedo((EditorCookie)object);
            }
        }
        Document document3 = document = document2 != null ? document2 : editorKit.createDefaultDocument();
        if (!(document instanceof StyledDocument)) {
            document = new DefaultStyledDocument(new StyleContext());
            editorKit = new StyledEditorKit();
            this.jEditorPane2.getEditorPane().setEditorKit(editorKit);
        }
        if (document2 == null) {
            object = streamSource.createReader();
            if (object != null) {
                this.secondSourceAvailable = true;
                try {
                    editorKit.read((Reader)object, document, 0);
                }
                catch (BadLocationException badLocationException) {
                    throw new IOException("Can not locate the beginning of the document.");
                }
                finally {
                    ((Reader)object).close();
                }
            }
        } else {
            this.secondSourceAvailable = true;
        }
        this.jEditorPane2.initActions();
        this.jSplitPane1.putClientProperty(UndoRedo.class, this.editorUndoRedo);
        this.jEditorPane2.getEditorPane().setDocument(document);
        this.jEditorPane2.getEditorPane().setEditable(this.editableCookie != null);
        if (document instanceof NbDocument.CustomEditor && (object = ((NbDocument.CustomEditor)document).createEditor((JEditorPane)this.jEditorPane2.getEditorPane())) instanceof JComponent) {
            this.jEditorPane2.setCustomEditor((JComponent)object);
        }
        this.customizeEditor(this.jEditorPane2.getEditorPane());
        this.jViewport2 = this.jEditorPane2.getScrollPane().getViewport();
        this.joinScrollBars();
    }

    private UndoRedo.Manager getUndoRedo(EditorCookie editorCookie) {
        try {
            Method method = CloneableEditorSupport.class.getDeclaredMethod("getUndoRedo", new Class[0]);
            method.setAccessible(true);
            return (UndoRedo.Manager)method.invoke((Object)editorCookie, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("document".equals(propertyChangeEvent.getPropertyName())) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditableDiffView.this.refreshEditableDocument();
                }
            });
        }
    }

    public void setSourceTitle(JLabel jLabel, String string) {
        jLabel.setText(string);
        jLabel.setToolTipText(string);
        jLabel.setMinimumSize(new Dimension(3, jLabel.getMinimumSize().height));
    }

    public void setDocument1(Document document) {
        if (document != null) {
            this.jEditorPane1.getEditorPane().setDocument(document);
        }
    }

    public void setDocument2(Document document) {
        if (document != null) {
            this.jEditorPane2.getEditorPane().setDocument(document);
        }
    }

    private void refreshDiff(int n) {
        this.refreshDiffTask.schedule(n);
    }

    private void refreshDividerSize() {
        Font font = this.jSplitPane1.getFont();
        if (font == null) {
            return;
        }
        FontMetrics fontMetrics = this.jSplitPane1.getFontMetrics(this.jSplitPane1.getFont());
        String string = Integer.toString(Math.max(1, this.diffs.length));
        int n = fontMetrics.stringWidth(string + " /" + string);
        this.jSplitPane1.setDividerSize(Math.max(n, 32));
    }

    synchronized int getDiffSerial() {
        return this.diffSerial;
    }

    static Difference getFirstDifference(Difference[] differenceArray, int n) {
        if (n < 0) {
            return null;
        }
        for (int i = 0; i < differenceArray.length; ++i) {
            Difference difference = differenceArray[i];
            if (n < difference.getFirstStart()) {
                return null;
            }
            if (difference.getType() == 1 && n == difference.getFirstStart()) {
                return difference;
            }
            if (n > difference.getFirstEnd()) continue;
            return difference;
        }
        return null;
    }

    static Difference getSecondDifference(Difference[] differenceArray, int n) {
        if (n < 0) {
            return null;
        }
        for (int i = 0; i < differenceArray.length; ++i) {
            Difference difference = differenceArray[i];
            if (n < difference.getSecondStart()) {
                return null;
            }
            if (difference.getType() == 0 && n == difference.getSecondStart()) {
                return difference;
            }
            if (n > difference.getSecondEnd()) continue;
            return difference;
        }
        return null;
    }

    Color getColorLines() {
        return this.colorLines;
    }

    static /* synthetic */ Difference[] access$2102(EditableDiffView editableDiffView, Difference[] differenceArray) {
        editableDiffView.diffs = differenceArray;
        return differenceArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EditableDiffMarkProvider
    extends MarkProvider {
        private List<Mark> marks = this.getMarksForDifferences();

        public List<Mark> getMarks() {
            return this.marks;
        }

        void refresh() {
            List<Mark> list = this.marks;
            this.marks = this.getMarksForDifferences();
            this.firePropertyChange("marks", list, this.marks);
        }

        private List<Mark> getMarksForDifferences() {
            if (EditableDiffView.this.diffs == null) {
                return Collections.emptyList();
            }
            ArrayList<Mark> arrayList = new ArrayList<Mark>(EditableDiffView.this.diffs.length);
            for (int i = 0; i < EditableDiffView.this.diffs.length; ++i) {
                Difference difference = EditableDiffView.this.diffs[i];
                arrayList.add(new DiffMark(difference, EditableDiffView.this.getColor(difference)));
            }
            return arrayList;
        }
    }

    public class RefreshDiffTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EditableDiffView editableDiffView = EditableDiffView.this;
            synchronized (editableDiffView) {
                this.computeDiff();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (EditableDiffView.this.getDifferenceIndex() >= EditableDiffView.this.diffs.length) {
                            EditableDiffView.this.updateCurrentDifference();
                        }
                        EditableDiffView.this.support.firePropertyChange("(void) differencesChanged", null, null);
                        EditableDiffView.this.jEditorPane1.setCurrentDiff(EditableDiffView.this.diffs);
                        EditableDiffView.this.jEditorPane2.setCurrentDiff(EditableDiffView.this.diffs);
                        EditableDiffView.this.refreshDividerSize();
                        EditableDiffView.this.jSplitPane1.repaint();
                        EditableDiffView.this.diffMarkprovider.refresh();
                    }
                });
            }
        }

        private void computeDiff() {
            if (!EditableDiffView.this.secondSourceAvailable || !EditableDiffView.this.firstSourceAvailable) {
                EditableDiffView.access$2102(EditableDiffView.this, EditableDiffView.this.NO_DIFFERENCES);
                return;
            }
            StringReader stringReader = null;
            StringReader stringReader2 = null;
            try {
                stringReader = new StringReader(EditableDiffView.this.jEditorPane1.getEditorPane().getDocument().getText(0, EditableDiffView.this.jEditorPane1.getEditorPane().getDocument().getLength()));
                stringReader2 = new StringReader(EditableDiffView.this.jEditorPane2.getEditorPane().getDocument().getText(0, EditableDiffView.this.jEditorPane2.getEditorPane().getDocument().getLength()));
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            DiffProvider diffProvider = DiffModuleConfig.getDefault().getDefaultDiffProvider();
            try {
                EditableDiffView.access$2102(EditableDiffView.this, diffProvider.computeDiff(stringReader, stringReader2));
                EditableDiffView.this.diffChanged();
            }
            catch (IOException iOException) {
                EditableDiffView.access$2102(EditableDiffView.this, EditableDiffView.this.NO_DIFFERENCES);
            }
        }
    }

    class DiffSplitPaneUI
    extends BasicSplitPaneUI {
        final DiffSplitPaneDivider divider;

        public DiffSplitPaneUI(JSplitPane jSplitPane) {
            this.splitPane = jSplitPane;
            this.divider = new DiffSplitPaneDivider(this, EditableDiffView.this);
        }

        public BasicSplitPaneDivider createDefaultDivider() {
            return this.divider;
        }
    }
}

