/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.ws.wadl2java.ast;

import com.sun.codemodel.JDefinedClass;
import com.sun.research.ws.wadl.Doc;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl.ResourceType;
import com.sun.research.ws.wadl2java.ast.MethodNode;
import com.sun.research.ws.wadl2java.ast.PathSegment;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypeNode {
    private String interfaceName;
    private List<MethodNode> methods;
    private PathSegment pathSegment;
    private List<Doc> doc;
    private JDefinedClass generatedInterface;

    public ResourceTypeNode(ResourceType resourceType) {
        this.doc = resourceType.getDoc();
        this.pathSegment = new PathSegment(resourceType);
        this.interfaceName = ResourceTypeNode.makeClassName(resourceType.getId());
        this.methods = new ArrayList<MethodNode>();
        this.generatedInterface = null;
    }

    public String getClassName() {
        return this.interfaceName;
    }

    public static String makeClassName(String input) {
        if (input == null || input.length() == 0) {
            input = "Index";
        }
        input = input.replaceAll("\\W", "_");
        input = input.substring(0, 1).toUpperCase() + input.substring(1);
        return input;
    }

    public List<MethodNode> getMethods() {
        return this.methods;
    }

    public List<Param> getQueryParams() {
        return this.pathSegment.getQueryParameters();
    }

    public List<Doc> getDoc() {
        return this.doc;
    }

    public void setGeneratedInterface(JDefinedClass iface) {
        this.generatedInterface = iface;
    }

    public JDefinedClass getGeneratedInterface() {
        return this.generatedInterface;
    }
}

