/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.lib.uihandler.LogRecords;
import org.netbeans.modules.uihandler.Installer;
import org.netbeans.modules.uihandler.TimeToFailure;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ChoiceView;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
CaretListener,
Comparator<Object> {
    private JLabel jLabel1;
    private JScrollPane jScrollPane2;
    private JComboBox remove;
    JEditorPane text;
    private ExplorerManager manager = new ExplorerManager();

    public SubmitPanel() {
        this.initComponents();
        EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)"text/xml");
        if (editorKit != null) {
            this.text.setEditorKit(editorKit);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.text.addCaretListener(this);
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void initComponents() {
        try {
            this.remove = new JComboBox();
            this.jLabel1 = new JLabel();
            this.jScrollPane2 = new JScrollPane();
            this.text = new JEditorPane();
            this.setPreferredSize(new Dimension(640, 480));
            this.remove.setModel(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.remove = new ChoiceView();
        this.jLabel1.setText(NbBundle.getMessage(SubmitPanel.class, (String)"SubmitPanel.jLabel1.text_1"));
        this.text.setEditable(false);
        this.jScrollPane2.setViewportView(this.text);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.jScrollPane2).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.remove, 0, 514, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.remove, -2, -1, -2)).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 203, Short.MAX_VALUE).addContainerGap()));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void addRecord(LogRecord logRecord, Node node) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n = this.text.getDocument().getLength();
            node.setValue("offset", (Object)n);
            TimeToFailure.logAction();
            LogRecords.write((OutputStream)byteArrayOutputStream, (LogRecord)logRecord);
            this.text.getDocument().insertString(n, byteArrayOutputStream.toString("UTF-8"), null);
            this.text.getCaret().setDot(0);
        }
        catch (IOException iOException) {
            Installer.LOG.log(Level.WARNING, null, iOException);
        }
        catch (BadLocationException badLocationException) {
            Installer.LOG.log(Level.WARNING, null, badLocationException);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
            if (nodeArray.length != 1) {
                return;
            }
            Object object = nodeArray[0].getValue("offset");
            if (object instanceof Integer) {
                this.text.removeCaretListener(this);
                this.text.getCaret().setDot((Integer)object);
                this.text.addCaretListener(this);
                this.text.requestFocus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        int n = this.text.getCaretPosition();
        Node[] nodeArray = this.getExplorerManager().getRootContext().getChildren().getNodes(true);
        int n2 = Arrays.binarySearch(nodeArray, n, this);
        if (n2 < -1) {
            n2 = -n2 - 2;
        }
        if (n2 >= 0 && n2 < nodeArray.length) {
            try {
                this.getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this);
                this.getExplorerManager().setSelectedNodes(new Node[]{nodeArray[n2]});
            }
            catch (PropertyVetoException propertyVetoException) {
                Exceptions.printStackTrace((Throwable)propertyVetoException);
            }
            finally {
                this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object instanceof Node) {
            object = ((Node)object).getValue("offset");
        }
        if (object2 instanceof Node) {
            object2 = ((Node)object2).getValue("offset");
        }
        if (object instanceof Integer && object2 instanceof Integer) {
            return (Integer)object - (Integer)object2;
        }
        throw new IllegalArgumentException("o1: " + object + " o2: " + object2);
    }
}

